/*
 * Decompiled with CFR 0.152.
 */
package ca.spottedleaf.concurrentutil.executor.thread;

import ca.spottedleaf.concurrentutil.executor.PrioritisedExecutor;
import ca.spottedleaf.concurrentutil.executor.queue.PrioritisedTaskQueue;
import ca.spottedleaf.concurrentutil.executor.thread.PrioritisedQueueExecutorThread;
import ca.spottedleaf.concurrentutil.list.COWArrayList;
import ca.spottedleaf.concurrentutil.util.Priority;
import ca.spottedleaf.concurrentutil.util.TimeUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class BalancedPrioritisedThreadPool {
    public static final long DEFAULT_GROUP_TIME_SLICE = 15000000L;
    private static final Logger LOGGER = LoggerFactory.getLogger(BalancedPrioritisedThreadPool.class);
    private final Consumer<Thread> threadModifier;
    private final COWArrayList<OrderedStreamGroup> groups = new COWArrayList<OrderedStreamGroup>(OrderedStreamGroup.class);
    private final COWArrayList<WorkerThread> threads = new COWArrayList<WorkerThread>(WorkerThread.class);
    private final COWArrayList<WorkerThread> aliveThreads = new COWArrayList<WorkerThread>(WorkerThread.class);
    private final long groupTimeSliceNS;
    private boolean shutdown;

    public BalancedPrioritisedThreadPool(long groupTimeSliceNS, Consumer<Thread> threadModifier) {
        this.threadModifier = threadModifier;
        if (threadModifier == null) {
            throw new NullPointerException("Thread factory may not be null");
        }
        this.groupTimeSliceNS = groupTimeSliceNS;
    }

    private void wakeupIdleThread() {
        for (WorkerThread thread : this.threads.getArray()) {
            if (!thread.notifyTasks()) continue;
            return;
        }
    }

    public Thread[] getAliveThreads() {
        WorkerThread[] threads = this.aliveThreads.getArray();
        return (Thread[])Arrays.copyOf(threads, threads.length, Thread[].class);
    }

    public Thread[] getCoreThreads() {
        WorkerThread[] threads = this.threads.getArray();
        return (Thread[])Arrays.copyOf(threads, threads.length, Thread[].class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void halt(boolean shutdownQueues) {
        Object[] objectArray = this;
        synchronized (this) {
            this.shutdown = true;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            if (shutdownQueues) {
                for (OrderedStreamGroup group : this.groups.getArray()) {
                    for (OrderedStreamGroup.Queue queue : group.queues.getArray()) {
                        queue.shutdown();
                    }
                }
            }
            for (WorkerThread thread : this.threads.getArray()) {
                thread.halt(false);
            }
            return;
        }
    }

    public boolean join(long msToWait) {
        try {
            return this.join(msToWait, false);
        }
        catch (InterruptedException ex) {
            throw new IllegalStateException(ex);
        }
    }

    public boolean joinInterruptable(long msToWait) throws InterruptedException {
        return this.join(msToWait, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean join(long msToWait, boolean interruptable) throws InterruptedException {
        long nsToWait = msToWait * 1000000L;
        long start = System.nanoTime();
        long deadline = start + nsToWait;
        boolean interrupted = false;
        try {
            for (WorkerThread thread : this.aliveThreads.getArray()) {
                while (thread.isAlive()) {
                    long current = System.nanoTime();
                    if (current - deadline >= 0L && msToWait > 0L) {
                        boolean bl = false;
                        return bl;
                    }
                    try {
                        thread.join(msToWait <= 0L ? 0L : Math.max(1L, (deadline - current) / 1000000L));
                    }
                    catch (InterruptedException ex) {
                        if (interruptable) {
                            throw ex;
                        }
                        interrupted = true;
                    }
                }
            }
            boolean bl = true;
            return bl;
        }
        finally {
            if (interrupted) {
                Thread.currentThread().interrupt();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown(boolean wait) {
        Object[] objectArray = this;
        synchronized (this) {
            this.shutdown = true;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            for (OrderedStreamGroup group : this.groups.getArray()) {
                for (OrderedStreamGroup.Queue queue : group.queues.getArray()) {
                    queue.shutdown();
                }
            }
            for (WorkerThread thread : this.threads.getArray()) {
                thread.close(false, false);
            }
            if (wait) {
                this.join(0L);
            }
            return;
        }
    }

    private void die(WorkerThread thread) {
        this.aliveThreads.remove(thread);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void adjustThreadCount(int threads) {
        WorkerThread[] workerThreadArray = this;
        synchronized (this) {
            if (this.shutdown) {
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return;
            }
            WorkerThread[] currentThreads = this.threads.getArray();
            if (threads == currentThreads.length) {
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return;
            }
            if (threads < currentThreads.length) {
                difference = currentThreads.length - threads;
                for (i = 0; i < difference; ++i) {
                    WorkerThread remove = currentThreads[currentThreads.length - i - 1];
                    remove.halt(false);
                    this.threads.remove(remove);
                }
            } else {
                difference = threads - currentThreads.length;
                for (i = 0; i < difference; ++i) {
                    WorkerThread thread = (BalancedPrioritisedThreadPool)this.new WorkerThread();
                    this.threadModifier.accept(thread);
                    this.aliveThreads.add(thread);
                    this.threads.add(thread);
                    thread.start();
                }
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            for (WorkerThread thread : this.threads.getArray()) {
                thread.notifyTasks();
            }
            return;
        }
    }

    public OrderedStreamGroup createOrderedStreamGroup() {
        return this.createOrderedStreamGroup(new AtomicLong());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OrderedStreamGroup createOrderedStreamGroup(AtomicLong subOrderGenerate) {
        BalancedPrioritisedThreadPool balancedPrioritisedThreadPool = this;
        synchronized (balancedPrioritisedThreadPool) {
            if (this.shutdown) {
                throw new IllegalStateException("Queue is shutdown");
            }
            OrderedStreamGroup ret = new OrderedStreamGroup(subOrderGenerate);
            this.groups.add(ret);
            return ret;
        }
    }

    private static int compareGroup(OrderedStreamGroup g1, OrderedStreamGroup g2) {
        int parallelismCompare = g1.currentParallelism - g2.currentParallelism;
        if (parallelismCompare != 0) {
            return parallelismCompare;
        }
        return TimeUtil.compareTimes(g1.lastRetrieved, g2.lastRetrieved);
    }

    private List<OrderedStreamGroup> findEligibleGroups() {
        ArrayList<OrderedStreamGroup> nonEmpty = new ArrayList<OrderedStreamGroup>();
        for (OrderedStreamGroup group : this.groups.getArray()) {
            if (!group.hasAnyTasks()) continue;
            nonEmpty.add(group);
        }
        return nonEmpty;
    }

    private OrderedStreamGroup obtainGroup0(List<OrderedStreamGroup> groups, long time) {
        OrderedStreamGroup ret = null;
        for (OrderedStreamGroup group : groups) {
            if (ret != null && BalancedPrioritisedThreadPool.compareGroup(group, ret) >= 0) continue;
            ret = group;
        }
        if (ret != null) {
            ret.lastRetrieved = time;
            ++ret.currentParallelism;
            return ret;
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private OrderedStreamGroup obtainGroup(long time) {
        List<OrderedStreamGroup> groups = this.findEligibleGroups();
        BalancedPrioritisedThreadPool balancedPrioritisedThreadPool = this;
        synchronized (balancedPrioritisedThreadPool) {
            return this.obtainGroup0(groups, time);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void returnGroup(OrderedStreamGroup group) {
        BalancedPrioritisedThreadPool balancedPrioritisedThreadPool = this;
        synchronized (balancedPrioritisedThreadPool) {
            --group.currentParallelism;
        }
    }

    public final class OrderedStreamGroup {
        private final AtomicLong subOrderGenerator;
        private final COWArrayList<Queue> queues = new COWArrayList<Queue>(Queue.class);
        private int currentParallelism;
        private long lastRetrieved = System.nanoTime();

        public OrderedStreamGroup(AtomicLong subOrderGenerator) {
            this.subOrderGenerator = subOrderGenerator;
        }

        public boolean hasAnyTasks() {
            for (Queue queue : this.queues.getArray()) {
                if (queue.wrapped.peekFirst() == null) continue;
                return true;
            }
            return false;
        }

        public boolean executeTask() {
            PrioritisedExecutor.PrioritisedTask task;
            do {
                if ((task = this.peekTask()) != null) continue;
                return false;
            } while (!task.execute());
            return true;
        }

        public PrioritisedExecutor.PrioritisedTask peekTask() {
            PrioritisedExecutor.PrioritisedTask highestTask = null;
            PrioritisedExecutor.PriorityState highestPriority = null;
            for (Queue wrapper : this.queues.getArray()) {
                PrioritisedExecutor.PrioritisedTask first;
                PrioritisedTaskQueue queue = wrapper.wrapped;
                PrioritisedExecutor.PriorityState state = null;
                while ((first = queue.peekFirst()) != null && (state = first.getPriorityState()) == null) {
                }
                if (first != null) {
                    if (highestPriority != null && state.compareTo(highestPriority) >= 0) continue;
                    highestTask = first;
                    highestPriority = state;
                    continue;
                }
                if (!queue.isShutdown() || !queue.hasNoScheduledTasks()) continue;
                this.queues.remove(wrapper);
            }
            return highestTask;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Queue createExecutor() {
            BalancedPrioritisedThreadPool balancedPrioritisedThreadPool = BalancedPrioritisedThreadPool.this;
            synchronized (balancedPrioritisedThreadPool) {
                if (BalancedPrioritisedThreadPool.this.shutdown) {
                    throw new IllegalStateException("Queue is shutdown");
                }
                Queue ret = new Queue(this.subOrderGenerator);
                this.queues.add(ret);
                return ret;
            }
        }

        public final class Queue
        implements PrioritisedExecutor {
            private final PrioritisedTaskQueue wrapped;
            private volatile boolean halt;
            private final AtomicLong executors = new AtomicLong();

            public Queue(AtomicLong subOrderGenerator) {
                this.wrapped = new PrioritisedTaskQueue(subOrderGenerator);
            }

            public void halt() {
                this.halt = true;
                OrderedStreamGroup.this.queues.remove(this);
            }

            public boolean isActive() {
                if (this.halt) {
                    return this.executors.get() > 0L;
                }
                if (!this.isShutdown()) {
                    return true;
                }
                return !this.wrapped.hasNoScheduledTasks();
            }

            @Override
            public long getTotalTasksScheduled() {
                return this.wrapped.getTotalTasksScheduled();
            }

            @Override
            public long getTotalTasksExecuted() {
                return this.wrapped.getTotalTasksExecuted();
            }

            @Override
            public long generateNextSubOrder() {
                return this.wrapped.generateNextSubOrder();
            }

            @Override
            public boolean shutdown() {
                return this.wrapped.shutdown();
            }

            @Override
            public boolean isShutdown() {
                return this.wrapped.isShutdown();
            }

            @Override
            public PrioritisedExecutor.PrioritisedTask createTask(Runnable task) {
                return this.createTask(task, Priority.NORMAL);
            }

            @Override
            public PrioritisedExecutor.PrioritisedTask createTask(Runnable task, Priority priority) {
                return this.createTask(task, priority, this.generateNextSubOrder(), 0L);
            }

            @Override
            public PrioritisedExecutor.PrioritisedTask createTask(Runnable task, Priority priority, long subOrder, long stream) {
                return new Task(this.wrapped.createTask(() -> {
                    this.executors.getAndIncrement();
                    try {
                        task.run();
                    }
                    finally {
                        this.executors.getAndDecrement();
                    }
                }, priority, subOrder, stream));
            }

            @Override
            public PrioritisedExecutor.PrioritisedTask queueTask(Runnable task) {
                PrioritisedExecutor.PrioritisedTask ret = this.createTask(task);
                ret.queue();
                return ret;
            }

            @Override
            public PrioritisedExecutor.PrioritisedTask queueTask(Runnable task, Priority priority) {
                PrioritisedExecutor.PrioritisedTask ret = this.createTask(task, priority);
                ret.queue();
                return ret;
            }

            @Override
            public PrioritisedExecutor.PrioritisedTask queueTask(Runnable task, Priority priority, long subOrder, long stream) {
                PrioritisedExecutor.PrioritisedTask ret = this.createTask(task, priority, subOrder, stream);
                ret.queue();
                return ret;
            }

            @Override
            public boolean executeTask() {
                return this.wrapped.executeTask();
            }

            private final class Task
            implements PrioritisedExecutor.PrioritisedTask {
                private final PrioritisedExecutor.PrioritisedTask wrap;

                public Task(PrioritisedExecutor.PrioritisedTask wrap) {
                    this.wrap = wrap;
                }

                @Override
                public PrioritisedExecutor getExecutor() {
                    return Queue.this;
                }

                @Override
                public boolean queue() {
                    if (this.wrap.queue()) {
                        BalancedPrioritisedThreadPool.this.wakeupIdleThread();
                        return true;
                    }
                    return false;
                }

                @Override
                public boolean isQueued() {
                    return this.wrap.isQueued();
                }

                @Override
                public boolean cancel() {
                    return this.wrap.cancel();
                }

                @Override
                public boolean execute() {
                    return this.wrap.execute();
                }

                @Override
                public Priority getPriority() {
                    return this.wrap.getPriority();
                }

                @Override
                public boolean setPriority(Priority priority) {
                    return this.wrap.setPriority(priority);
                }

                @Override
                public boolean raisePriority(Priority priority) {
                    return this.wrap.raisePriority(priority);
                }

                @Override
                public boolean lowerPriority(Priority priority) {
                    return this.wrap.lowerPriority(priority);
                }

                @Override
                public long getSubOrder() {
                    return this.wrap.getSubOrder();
                }

                @Override
                public boolean setSubOrder(long subOrder) {
                    return this.wrap.setSubOrder(subOrder);
                }

                @Override
                public boolean raiseSubOrder(long subOrder) {
                    return this.wrap.raiseSubOrder(subOrder);
                }

                @Override
                public boolean lowerSubOrder(long subOrder) {
                    return this.wrap.lowerSubOrder(subOrder);
                }

                @Override
                public long getStream() {
                    return this.wrap.getStream();
                }

                @Override
                public boolean setStream(long stream) {
                    return this.wrap.setStream(stream);
                }

                @Override
                public boolean setPrioritySubOrderStream(Priority priority, long subOrder, long stream) {
                    return this.wrap.setPrioritySubOrderStream(priority, subOrder, stream);
                }

                @Override
                public PrioritisedExecutor.PriorityState getPriorityState() {
                    return this.wrap.getPriorityState();
                }
            }
        }
    }

    private final class WorkerThread
    extends PrioritisedQueueExecutorThread {
        public WorkerThread() {
            super((PrioritisedExecutor)null);
        }

        @Override
        protected void die() {
            BalancedPrioritisedThreadPool.this.die(this);
        }

        @Override
        protected boolean pollTasks() {
            OrderedStreamGroup group;
            boolean ret = false;
            while (!this.halted && (group = BalancedPrioritisedThreadPool.this.obtainGroup(System.nanoTime())) != null) {
                long deadline = System.nanoTime() + BalancedPrioritisedThreadPool.this.groupTimeSliceNS;
                do {
                    try {
                        if (this.halted || !group.executeTask()) break;
                        ret = true;
                    }
                    catch (Throwable throwable) {
                        LOGGER.error("Exception thrown from thread '" + this.getName(), throwable);
                    }
                } while (System.nanoTime() - deadline <= 0L);
                BalancedPrioritisedThreadPool.this.returnGroup(group);
            }
            return ret;
        }
    }
}

