/*
 * Decompiled with CFR 0.152.
 */
package ca.spottedleaf.concurrentutil.executor.thread;

import ca.spottedleaf.concurrentutil.executor.PrioritisedExecutor;
import ca.spottedleaf.concurrentutil.util.ConcurrentUtil;
import ca.spottedleaf.concurrentutil.util.Priority;
import java.lang.invoke.VarHandle;
import java.util.concurrent.locks.LockSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PrioritisedQueueExecutorThread
extends Thread
implements PrioritisedExecutor {
    private static final Logger LOGGER = LoggerFactory.getLogger(PrioritisedQueueExecutorThread.class);
    protected final PrioritisedExecutor queue;
    protected volatile boolean threadShutdown;
    protected volatile boolean threadParked;
    protected static final VarHandle THREAD_PARKED_HANDLE = ConcurrentUtil.getVarHandle(PrioritisedQueueExecutorThread.class, "threadParked", Boolean.TYPE);
    protected volatile boolean halted;
    protected final long spinWaitTimeNS;
    protected static final long DEFAULT_SPINWAIT_TIME = 100000L;

    public PrioritisedQueueExecutorThread(PrioritisedExecutor queue) {
        this(queue, 100000L);
    }

    public PrioritisedQueueExecutorThread(PrioritisedExecutor queue, long spinWaitTimeNS) {
        this.queue = queue;
        this.spinWaitTimeNS = spinWaitTimeNS;
    }

    @Override
    public final void run() {
        try {
            this.begin();
            this.doRun();
        }
        finally {
            this.die();
        }
    }

    private boolean mainLoop() {
        this.pollTasks();
        long spinWaitTimeNS = this.spinWaitTimeNS;
        if (spinWaitTimeNS > 0L) {
            long start = System.nanoTime();
            long deadline = start + spinWaitTimeNS;
            long sleepTime = Math.min(100000L, spinWaitTimeNS);
            while (true) {
                this.setParked();
                if (this.pollTasks()) {
                    this.unsetParked();
                    return true;
                }
                if (this.handleClose()) {
                    this.unsetParked();
                    return false;
                }
                Thread.interrupted();
                LockSupport.parkNanos("Short parking", sleepTime);
                this.unsetParked();
                if (this.pollTasks()) {
                    return true;
                }
                long timeToDeadline = deadline - System.nanoTime();
                if (timeToDeadline <= 0L) break;
                sleepTime = Math.min(timeToDeadline, sleepTime);
            }
        }
        this.setParked();
        if (this.pollTasks()) {
            this.unsetParked();
            return true;
        }
        if (this.handleClose()) {
            this.unsetParked();
            return false;
        }
        while (this.getThreadParkedVolatile()) {
            Thread.interrupted();
            LockSupport.park("Long parking");
        }
        return true;
    }

    private void doRun() {
        while (this.mainLoop()) {
        }
    }

    protected void begin() {
    }

    protected void die() {
    }

    protected boolean pollTasks() {
        boolean ret = false;
        while (!this.halted) {
            try {
                if (!this.queue.executeTask()) {
                    return ret;
                }
                ret = true;
                continue;
            }
            catch (Throwable throwable) {
                LOGGER.error("Exception thrown from prioritized runnable task in thread '" + this.getName() + "'", throwable);
                continue;
            }
            break;
        }
        return ret;
    }

    protected final boolean handleClose() {
        if (this.threadShutdown) {
            this.pollTasks();
            return true;
        }
        return false;
    }

    private boolean unsetParked() {
        return this.getThreadParkedVolatile() && this.compareAndExchangeThreadParkedVolatile(true, false);
    }

    private void setParked() {
        this.setThreadParkedVolatile(true);
    }

    public final boolean notifyTasks() {
        if (this.unsetParked()) {
            LockSupport.unpark(this);
            return true;
        }
        return false;
    }

    @Override
    public long getTotalTasksExecuted() {
        return this.queue.getTotalTasksExecuted();
    }

    @Override
    public long getTotalTasksScheduled() {
        return this.queue.getTotalTasksScheduled();
    }

    @Override
    public long generateNextSubOrder() {
        return this.queue.generateNextSubOrder();
    }

    @Override
    public boolean shutdown() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isShutdown() {
        return false;
    }

    @Override
    public boolean executeTask() throws IllegalStateException {
        throw new IllegalStateException();
    }

    @Override
    public PrioritisedExecutor.PrioritisedTask queueTask(Runnable task) {
        PrioritisedExecutor.PrioritisedTask ret = this.createTask(task);
        ret.queue();
        return ret;
    }

    @Override
    public PrioritisedExecutor.PrioritisedTask queueTask(Runnable task, Priority priority) {
        PrioritisedExecutor.PrioritisedTask ret = this.createTask(task, priority);
        ret.queue();
        return ret;
    }

    @Override
    public PrioritisedExecutor.PrioritisedTask queueTask(Runnable task, Priority priority, long subOrder, long stream) {
        PrioritisedExecutor.PrioritisedTask ret = this.createTask(task, priority, subOrder, stream);
        ret.queue();
        return ret;
    }

    @Override
    public PrioritisedExecutor.PrioritisedTask createTask(Runnable task) {
        PrioritisedExecutor.PrioritisedTask queueTask = this.queue.createTask(task);
        return new WrappedTask(queueTask);
    }

    @Override
    public PrioritisedExecutor.PrioritisedTask createTask(Runnable task, Priority priority) {
        PrioritisedExecutor.PrioritisedTask queueTask = this.queue.createTask(task, priority);
        return new WrappedTask(queueTask);
    }

    @Override
    public PrioritisedExecutor.PrioritisedTask createTask(Runnable task, Priority priority, long subOrder, long stream) {
        PrioritisedExecutor.PrioritisedTask queueTask = this.queue.createTask(task, priority, subOrder, stream);
        return new WrappedTask(queueTask);
    }

    public boolean close(boolean wait, boolean killQueue) {
        boolean ret = killQueue && this.queue.shutdown();
        this.threadShutdown = true;
        this.notifyTasks();
        if (wait) {
            boolean interrupted = false;
            while (true) {
                if (!this.isAlive()) {
                    if (!interrupted) break;
                    Thread.currentThread().interrupt();
                    break;
                }
                try {
                    this.join();
                }
                catch (InterruptedException ex) {
                    interrupted = true;
                }
            }
        }
        return ret;
    }

    public void halt(boolean killQueue) {
        if (killQueue) {
            this.queue.shutdown();
        }
        this.threadShutdown = true;
        this.halted = true;
        this.notifyTasks();
    }

    protected final boolean getThreadParkedVolatile() {
        return THREAD_PARKED_HANDLE.getVolatile(this);
    }

    protected final boolean compareAndExchangeThreadParkedVolatile(boolean expect, boolean update) {
        return THREAD_PARKED_HANDLE.compareAndExchange(this, expect, update);
    }

    protected final void setThreadParkedVolatile(boolean value) {
        THREAD_PARKED_HANDLE.setVolatile(this, value);
    }

    private final class WrappedTask
    implements PrioritisedExecutor.PrioritisedTask {
        private final PrioritisedExecutor.PrioritisedTask queueTask;

        public WrappedTask(PrioritisedExecutor.PrioritisedTask queueTask) {
            this.queueTask = queueTask;
        }

        @Override
        public PrioritisedExecutor getExecutor() {
            return PrioritisedQueueExecutorThread.this;
        }

        @Override
        public boolean queue() {
            boolean ret = this.queueTask.queue();
            if (ret) {
                PrioritisedQueueExecutorThread.this.notifyTasks();
            }
            return ret;
        }

        @Override
        public boolean isQueued() {
            return this.queueTask.isQueued();
        }

        @Override
        public boolean cancel() {
            return this.queueTask.cancel();
        }

        @Override
        public boolean execute() {
            return this.queueTask.execute();
        }

        @Override
        public Priority getPriority() {
            return this.queueTask.getPriority();
        }

        @Override
        public boolean setPriority(Priority priority) {
            return this.queueTask.setPriority(priority);
        }

        @Override
        public boolean raisePriority(Priority priority) {
            return this.queueTask.raisePriority(priority);
        }

        @Override
        public boolean lowerPriority(Priority priority) {
            return this.queueTask.lowerPriority(priority);
        }

        @Override
        public long getSubOrder() {
            return this.queueTask.getSubOrder();
        }

        @Override
        public boolean setSubOrder(long subOrder) {
            return this.queueTask.setSubOrder(subOrder);
        }

        @Override
        public boolean raiseSubOrder(long subOrder) {
            return this.queueTask.raiseSubOrder(subOrder);
        }

        @Override
        public boolean lowerSubOrder(long subOrder) {
            return this.queueTask.lowerSubOrder(subOrder);
        }

        @Override
        public long getStream() {
            return this.queueTask.getStream();
        }

        @Override
        public boolean setStream(long stream) {
            return this.queueTask.setStream(stream);
        }

        @Override
        public boolean setPrioritySubOrderStream(Priority priority, long subOrder, long stream) {
            return this.queueTask.setPrioritySubOrderStream(priority, subOrder, stream);
        }

        @Override
        public PrioritisedExecutor.PriorityState getPriorityState() {
            return this.queueTask.getPriorityState();
        }
    }
}

