/*
 * Decompiled with CFR 0.152.
 */
package alternate.current.wire;

import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.LevelChunkSection;
import net.minecraft.world.level.chunk.status.ChunkStatus;
import org.bukkit.block.Block;
import org.bukkit.craftbukkit.block.CraftBlock;
import org.bukkit.event.Event;
import org.bukkit.event.block.BlockRedstoneEvent;

class LevelHelper {
    LevelHelper() {
    }

    static int doRedstoneEvent(ServerLevel level, BlockPos pos, int prevPower, int newPower) {
        BlockRedstoneEvent event = new BlockRedstoneEvent((Block)CraftBlock.at(level, pos), prevPower, newPower);
        level.getCraftServer().getPluginManager().callEvent((Event)event);
        return event.getNewCurrent();
    }

    static boolean setWireState(ServerLevel level, BlockPos pos, BlockState state, boolean updateNeighborShapes) {
        int y = pos.getY();
        if (y < level.getMinY() || y > level.getMaxY()) {
            return false;
        }
        int x = pos.getX();
        int z = pos.getZ();
        int index = level.getSectionIndex(y);
        ChunkAccess chunk = level.getChunk(x >> 4, z >> 4, ChunkStatus.FULL, true);
        LevelChunkSection section = chunk.getSections()[index];
        if (section == null) {
            return false;
        }
        BlockState prevState = section.setBlockState(x & 0xF, y & 0xF, z & 0xF, state);
        if (state == prevState) {
            return false;
        }
        level.getChunkSource().blockChanged(pos);
        chunk.markUnsaved();
        if (updateNeighborShapes) {
            prevState.updateIndirectNeighbourShapes(level, pos, 2);
            state.updateNeighbourShapes(level, pos, 2);
            state.updateIndirectNeighbourShapes(level, pos, 2);
        }
        return true;
    }
}

