/*
 * Decompiled with CFR 0.152.
 */
package ca.spottedleaf.dataconverter.minecraft.converters.attributes;

import ca.spottedleaf.dataconverter.converters.DataConverter;
import ca.spottedleaf.dataconverter.minecraft.converters.helpers.RenameHelper;
import ca.spottedleaf.dataconverter.minecraft.datatypes.MCTypeRegistry;
import ca.spottedleaf.dataconverter.types.ListType;
import ca.spottedleaf.dataconverter.types.MapType;
import ca.spottedleaf.dataconverter.types.ObjectType;
import java.util.function.Function;

public final class ConverterAbstractOldAttributesRename {
    public static void register(int version, Function<String, String> renamer) {
        ConverterAbstractOldAttributesRename.register(version, 0, renamer);
    }

    public static void register(int version, int versionStep, final Function<String, String> renamer) {
        DataConverter<MapType, MapType> entityConverter = new DataConverter<MapType, MapType>(version, versionStep){

            @Override
            public MapType convert(MapType data, long sourceVersion, long toVersion) {
                ListType attributes = data.getList("Attributes", ObjectType.MAP);
                if (attributes == null) {
                    return null;
                }
                int len = attributes.size();
                for (int i = 0; i < len; ++i) {
                    RenameHelper.renameString(attributes.getMap(i), "Name", renamer);
                }
                return null;
            }
        };
        MCTypeRegistry.ENTITY.addStructureConverter(entityConverter);
        MCTypeRegistry.PLAYER.addStructureConverter(entityConverter);
        MCTypeRegistry.ITEM_STACK.addStructureConverter(new DataConverter<MapType, MapType>(version, versionStep){

            @Override
            public MapType convert(MapType data, long sourceVersion, long toVersion) {
                ListType attributes = data.getList("AttributeModifiers", ObjectType.MAP);
                if (attributes == null) {
                    return null;
                }
                int len = attributes.size();
                for (int i = 0; i < len; ++i) {
                    RenameHelper.renameString(attributes.getMap(i), "AttributeName", renamer);
                }
                return null;
            }
        });
    }

    private ConverterAbstractOldAttributesRename() {
    }
}

