/*
 * Decompiled with CFR 0.152.
 */
package ca.spottedleaf.dataconverter.minecraft.versions;

import ca.spottedleaf.dataconverter.converters.DataConverter;
import ca.spottedleaf.dataconverter.minecraft.converters.helpers.HelperItemNameV102;
import ca.spottedleaf.dataconverter.minecraft.datatypes.MCTypeRegistry;
import ca.spottedleaf.dataconverter.types.MapType;
import ca.spottedleaf.dataconverter.types.ObjectType;
import ca.spottedleaf.dataconverter.types.Types;
import com.mojang.logging.LogUtils;
import org.slf4j.Logger;

public final class V102 {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final int VERSION = 102;

    public static void register() {
        MCTypeRegistry.ITEM_NAME.addConverter(new DataConverter<Object, Object>(102){

            @Override
            public Object convert(Object data, long sourceVersion, long toVersion) {
                if (!(data instanceof Number)) {
                    return null;
                }
                int id = ((Number)data).intValue();
                String remap = HelperItemNameV102.getNameFromId(id);
                if (remap == null) {
                    LOGGER.warn("Unknown legacy integer id (V102) " + id);
                }
                return remap == null ? HelperItemNameV102.getNameFromId(0) : remap;
            }
        });
        MCTypeRegistry.ITEM_STACK.addStructureConverter(new DataConverter<MapType, MapType>(102){

            @Override
            public MapType convert(MapType data, long sourceVersion, long toVersion) {
                if (!data.hasKey("id", ObjectType.NUMBER)) {
                    return null;
                }
                int id = data.getInt("id");
                String remap = HelperItemNameV102.getNameFromId(id);
                if (remap == null) {
                    LOGGER.warn("Unknown legacy integer id (V102) " + id);
                    remap = HelperItemNameV102.getNameFromId(0);
                }
                data.setString("id", remap);
                return null;
            }
        });
        MCTypeRegistry.ITEM_STACK.addConverterForId("minecraft:potion", new DataConverter<MapType, MapType>(102){

            @Override
            public MapType convert(MapType data, long sourceVersion, long toVersion) {
                MapType tag;
                short damage = data.getShort("Damage");
                if (damage != 0) {
                    data.setShort("Damage", (short)0);
                }
                if ((tag = data.getMap("tag")) == null) {
                    tag = Types.NBT.createEmptyMap();
                    data.setMap("tag", tag);
                }
                if (!tag.hasKey("Potion", ObjectType.STRING)) {
                    String converted = HelperItemNameV102.getPotionNameFromId(damage);
                    tag.setString("Potion", converted == null ? "minecraft:water" : converted);
                    if ((damage & 0x4000) == 16384) {
                        data.setString("id", "minecraft:splash_potion");
                    }
                }
                return null;
            }
        });
    }

    private V102() {
    }
}

