/*
 * Decompiled with CFR 0.152.
 */
package ca.spottedleaf.dataconverter.minecraft.versions;

import ca.spottedleaf.dataconverter.converters.DataConverter;
import ca.spottedleaf.dataconverter.minecraft.datatypes.MCTypeRegistry;
import ca.spottedleaf.dataconverter.minecraft.walkers.generic.WalkerUtils;
import ca.spottedleaf.dataconverter.types.ListType;
import ca.spottedleaf.dataconverter.types.MapType;
import ca.spottedleaf.dataconverter.types.ObjectType;
import ca.spottedleaf.dataconverter.types.Types;

public final class V106 {
    private static final int VERSION = 106;

    public static void register() {
        MCTypeRegistry.UNTAGGED_SPAWNER.addStructureConverter(new DataConverter<MapType, MapType>(106){

            @Override
            public MapType convert(MapType data, long sourceVersion, long toVersion) {
                ListType spawnPotentials;
                String entityId = data.getString("EntityId");
                if (entityId != null) {
                    data.remove("EntityId");
                    MapType spawnData = data.getMap("SpawnData");
                    if (spawnData == null) {
                        spawnData = Types.NBT.createEmptyMap();
                        data.setMap("SpawnData", spawnData);
                    }
                    spawnData.setString("id", entityId.isEmpty() ? "Pig" : entityId);
                }
                if ((spawnPotentials = data.getList("SpawnPotentials", ObjectType.MAP)) != null) {
                    int len = spawnPotentials.size();
                    for (int i = 0; i < len; ++i) {
                        MapType spawn = spawnPotentials.getMap(i);
                        String spawnType = spawn.getString("Type");
                        if (spawnType == null) continue;
                        spawn.remove("Type");
                        MapType properties = spawn.getMap("Properties");
                        if (properties == null) {
                            properties = Types.NBT.createEmptyMap();
                        } else {
                            spawn.remove("Properties");
                        }
                        properties.setString("id", spawnType);
                        spawn.setMap("Entity", properties);
                    }
                }
                return null;
            }
        });
        MCTypeRegistry.UNTAGGED_SPAWNER.addStructureWalker(106, (data, fromVersion, toVersion) -> {
            ListType spawnPotentials = data.getList("SpawnPotentials", ObjectType.MAP);
            if (spawnPotentials != null) {
                int len = spawnPotentials.size();
                for (int i = 0; i < len; ++i) {
                    MapType spawnPotential = spawnPotentials.getMap(i);
                    WalkerUtils.convert(MCTypeRegistry.ENTITY, spawnPotential, "Entity", fromVersion, toVersion);
                }
            }
            WalkerUtils.convert(MCTypeRegistry.ENTITY, data, "SpawnData", fromVersion, toVersion);
            return null;
        });
    }

    private V106() {
    }
}

