/*
 * Decompiled with CFR 0.152.
 */
package ca.spottedleaf.dataconverter.minecraft.versions;

import ca.spottedleaf.dataconverter.converters.DataConverter;
import ca.spottedleaf.dataconverter.minecraft.datatypes.MCTypeRegistry;
import ca.spottedleaf.dataconverter.minecraft.hooks.DataHookValueTypeEnforceNamespaced;
import ca.spottedleaf.dataconverter.minecraft.walkers.generic.WalkerUtils;
import ca.spottedleaf.dataconverter.types.ListType;
import ca.spottedleaf.dataconverter.types.MapType;
import ca.spottedleaf.dataconverter.types.ObjectType;
import ca.spottedleaf.dataconverter.types.Types;

public final class V1125 {
    private static final int VERSION = 1125;
    private static final int BED_BLOCK_ID = 416;

    public static void register() {
        MCTypeRegistry.CHUNK.addStructureConverter(new DataConverter<MapType, MapType>(1125){

            @Override
            public MapType convert(MapType data, long sourceVersion, long toVersion) {
                MapType level = data.getMap("Level");
                if (level == null) {
                    return null;
                }
                int chunkX = level.getInt("xPos");
                int chunkZ = level.getInt("zPos");
                ListType sections = level.getList("Sections", ObjectType.MAP);
                if (sections == null) {
                    return null;
                }
                ListType tileEntities = level.getList("TileEntities", ObjectType.MAP);
                if (tileEntities == null) {
                    tileEntities = Types.NBT.createEmptyList();
                    level.setList("TileEntities", tileEntities);
                }
                int len = sections.size();
                for (int i = 0; i < len; ++i) {
                    MapType section = sections.getMap(i);
                    byte sectionY = section.getByte("Y");
                    byte[] blocks = section.getBytes("Blocks");
                    if (blocks == null) continue;
                    for (int blockIndex = 0; blockIndex < blocks.length; ++blockIndex) {
                        if (416 != (blocks[blockIndex] & 0xFF) << 4) continue;
                        int localX = blockIndex & 0xF;
                        int localZ = blockIndex >> 4 & 0xF;
                        int localY = blockIndex >> 8 & 0xF;
                        MapType newTile = Types.NBT.createEmptyMap();
                        newTile.setString("id", "minecraft:bed");
                        newTile.setInt("x", localX + (chunkX << 4));
                        newTile.setInt("y", localY + (sectionY << 4));
                        newTile.setInt("z", localZ + (chunkZ << 4));
                        newTile.setShort("color", (short)14);
                        tileEntities.addMap(newTile);
                    }
                }
                return null;
            }
        });
        MCTypeRegistry.ITEM_STACK.addConverterForId("minecraft:bed", new DataConverter<MapType, MapType>(1125){

            @Override
            public MapType convert(MapType data, long sourceVersion, long toVersion) {
                if (data.getShort("Damage") == 0) {
                    data.setShort("Damage", (short)14);
                }
                return null;
            }
        });
        MCTypeRegistry.ADVANCEMENTS.addStructureWalker(1125, (data, fromVersion, toVersion) -> {
            WalkerUtils.convertKeys(MCTypeRegistry.BIOME, data.getMap("minecraft:adventure/adventuring_time"), "criteria", fromVersion, toVersion);
            WalkerUtils.convertKeys(MCTypeRegistry.ENTITY_NAME, data.getMap("minecraft:adventure/kill_a_mob"), "criteria", fromVersion, toVersion);
            WalkerUtils.convertKeys(MCTypeRegistry.ENTITY_NAME, data.getMap("minecraft:adventure/kill_all_mobs"), "criteria", fromVersion, toVersion);
            WalkerUtils.convertKeys(MCTypeRegistry.ENTITY_NAME, data.getMap("minecraft:adventure/bred_all_animals"), "criteria", fromVersion, toVersion);
            return null;
        });
        MCTypeRegistry.BIOME.addStructureHook(1125, new DataHookValueTypeEnforceNamespaced());
    }

    private V1125() {
    }
}

