/*
 * Decompiled with CFR 0.152.
 */
package ca.spottedleaf.dataconverter.minecraft.versions;

import ca.spottedleaf.dataconverter.converters.DataConverter;
import ca.spottedleaf.dataconverter.minecraft.datatypes.MCTypeRegistry;
import ca.spottedleaf.dataconverter.types.ListType;
import ca.spottedleaf.dataconverter.types.MapType;
import ca.spottedleaf.dataconverter.types.ObjectType;
import ca.spottedleaf.dataconverter.types.Types;
import net.minecraft.util.Mth;

public final class V1955 {
    private static final int VERSION = 1955;
    private static final int[] LEVEL_XP_THRESHOLDS = new int[]{0, 10, 50, 100, 150};

    private static int getMinXpPerLevel(int level) {
        return LEVEL_XP_THRESHOLDS[Mth.clamp(level - 1, 0, LEVEL_XP_THRESHOLDS.length - 1)];
    }

    private static void addLevel(MapType data, int level) {
        MapType villagerData = data.getMap("VillagerData");
        if (villagerData == null) {
            villagerData = Types.NBT.createEmptyMap();
            data.setMap("VillagerData", villagerData);
        }
        villagerData.setInt("level", level);
    }

    private static void addXpFromLevel(MapType data, int level) {
        data.setInt("Xp", V1955.getMinXpPerLevel(level));
    }

    public static void register() {
        MCTypeRegistry.ENTITY.addConverterForId("minecraft:villager", new DataConverter<MapType, MapType>(1955){

            @Override
            public MapType convert(MapType data, long sourceVersion, long toVersion) {
                MapType offers;
                ListType recipes;
                int recipeCount;
                int level;
                MapType villagerData = data.getMap("VillagerData");
                int n = level = villagerData == null ? 0 : villagerData.getInt("level");
                if ((level == 0 || level == 1) && (level = Mth.clamp((recipeCount = (recipes = (offers = data.getMap("Offers")) == null ? null : offers.getList("Recipes", ObjectType.MAP)) != null ? recipes.size() : 0) / 2, 1, 5)) > 1) {
                    V1955.addLevel(data, level);
                }
                if (!data.hasKey("Xp", ObjectType.NUMBER)) {
                    V1955.addXpFromLevel(data, level);
                }
                return null;
            }
        });
        MCTypeRegistry.ENTITY.addConverterForId("minecraft:zombie_villager", new DataConverter<MapType, MapType>(1955){

            @Override
            public MapType convert(MapType data, long sourceVersion, long toVersion) {
                Number xp = data.getNumber("Xp");
                if (xp == null) {
                    MapType villagerData = data.getMap("VillagerData");
                    int level = villagerData == null ? 1 : villagerData.getInt("level", 1);
                    data.setInt("Xp", V1955.getMinXpPerLevel(level));
                }
                return null;
            }
        });
    }

    private V1955() {
    }
}

