/*
 * Decompiled with CFR 0.152.
 */
package ca.spottedleaf.dataconverter.minecraft.versions;

import ca.spottedleaf.dataconverter.converters.DataConverter;
import ca.spottedleaf.dataconverter.minecraft.datatypes.MCTypeRegistry;
import ca.spottedleaf.dataconverter.types.ListType;
import ca.spottedleaf.dataconverter.types.MapType;
import ca.spottedleaf.dataconverter.types.ObjectType;
import com.mojang.datafixers.DataFixUtils;
import net.minecraft.util.Mth;

public final class V2527 {
    private static final int VERSION = 2527;

    public static void register() {
        MCTypeRegistry.CHUNK.addStructureConverter(new DataConverter<MapType, MapType>(2527){

            @Override
            public MapType convert(MapType data, long sourceVersion, long toVersion) {
                MapType heightMaps;
                MapType level = data.getMap("Level");
                if (level == null) {
                    return null;
                }
                ListType sections = level.getList("Sections", ObjectType.MAP);
                if (sections != null) {
                    int len = sections.size();
                    for (int i = 0; i < len; ++i) {
                        long[] states;
                        int bits;
                        MapType section = sections.getMap(i);
                        ListType palette = section.getList("Palette", ObjectType.MAP);
                        if (palette == null || Mth.isPowerOfTwo(bits = Math.max(4, DataFixUtils.ceillog2((int)palette.size()))) || (states = section.getLongs("BlockStates")) == null) continue;
                        section.setLongs("BlockStates", V2527.addPadding(4096, bits, states));
                    }
                }
                if ((heightMaps = level.getMap("Heightmaps")) != null) {
                    for (String key : heightMaps.keys()) {
                        long[] old = heightMaps.getLongs(key);
                        heightMaps.setLongs(key, V2527.addPadding(256, 9, old));
                    }
                }
                return null;
            }
        });
    }

    public static long[] addPadding(int indices, int bits, long[] old) {
        int k = old.length;
        if (k == 0) {
            return old;
        }
        long l = (1L << bits) - 1L;
        int m = 64 / bits;
        int n = (indices + m - 1) / m;
        long[] padded = new long[n];
        int o = 0;
        int p = 0;
        long q = 0L;
        int r = 0;
        long s = old[0];
        long t = k > 1 ? old[1] : 0L;
        for (int u = 0; u < indices; ++u) {
            int ac;
            long ab;
            int v = u * bits;
            int w = v >> 6;
            int x = (u + 1) * bits - 1 >> 6;
            int y = v ^ w << 6;
            if (w != r) {
                s = t;
                t = w + 1 < k ? old[w + 1] : 0L;
                r = w;
            }
            if (w == x) {
                ab = s >>> y & l;
            } else {
                ac = 64 - y;
                ab = (s >>> y | t << ac) & l;
            }
            ac = p + bits;
            if (ac >= 64) {
                padded[o++] = q;
                q = ab;
                p = bits;
                continue;
            }
            q |= ab << p;
            p = ac;
        }
        if (q != 0L) {
            padded[o] = q;
        }
        return padded;
    }

    private V2527() {
    }
}

