/*
 * Decompiled with CFR 0.152.
 */
package ca.spottedleaf.dataconverter.minecraft.versions;

import ca.spottedleaf.dataconverter.converters.DataConverter;
import ca.spottedleaf.dataconverter.minecraft.datatypes.MCTypeRegistry;
import ca.spottedleaf.dataconverter.types.ListType;
import ca.spottedleaf.dataconverter.types.MapType;
import ca.spottedleaf.dataconverter.types.ObjectType;

public final class V3077 {
    private static final int VERSION = 3077;

    public static void register() {
        MCTypeRegistry.CHUNK.addStructureConverter(new DataConverter<MapType, MapType>(3077){

            @Override
            public MapType convert(MapType data, long sourceVersion, long toVersion) {
                boolean isLightOn = data.getBoolean("isLightOn");
                if (isLightOn) {
                    return null;
                }
                ListType sections = data.getList("sections", ObjectType.MAP);
                if (sections == null) {
                    return null;
                }
                int len = sections.size();
                for (int i = 0; i < len; ++i) {
                    MapType section = sections.getMap(i);
                    section.remove("BlockLight");
                    section.remove("SkyLight");
                }
                return null;
            }
        });
    }

    private V3077() {
    }
}

