/*
 * Decompiled with CFR 0.152.
 */
package ca.spottedleaf.dataconverter.minecraft.versions;

import ca.spottedleaf.dataconverter.converters.DataConverter;
import ca.spottedleaf.dataconverter.minecraft.datatypes.MCTypeRegistry;
import ca.spottedleaf.dataconverter.types.ListType;
import ca.spottedleaf.dataconverter.types.MapType;

public final class V4293 {
    private static final int VERSION = 4293;

    public static void register() {
        MCTypeRegistry.ENTITY.addStructureConverter(new DataConverter<MapType, MapType>(4293){
            private static final float DEFAULT = 0.085f;
            private static final String[] ARMOR_SLOTS = new String[]{"feet", "legs", "chest", "head"};
            private static final String[] HAND_SLOTS = new String[]{"mainhand", "offhand"};

            private static void convertDropChances(MapType root, String srcPath, String[] names, MapType dst) {
                ListType oldChances = root.getListUnchecked(srcPath);
                if (oldChances == null) {
                    return;
                }
                int len = Math.min(oldChances.size(), names.length);
                for (int i = 0; i < len; ++i) {
                    float chance = oldChances.getFloat(i, 0.085f);
                    if (chance == 0.085f) continue;
                    dst.setFloat(names[i], chance);
                }
            }

            @Override
            public MapType convert(MapType data, long sourceVersion, long toVersion) {
                MapType dropChances = data.getTypeUtil().createEmptyMap();
                1.convertDropChances(data, "ArmorDropChances", ARMOR_SLOTS, dropChances);
                1.convertDropChances(data, "HandDropChances", HAND_SLOTS, dropChances);
                data.remove("ArmorDropChances");
                data.remove("HandDropChances");
                float body = data.getFloat("body_armor_drop_chance", 0.085f);
                data.remove("body_armor_drop_chance");
                if (body != 0.085f) {
                    dropChances.setFloat("body", body);
                }
                if (!dropChances.isEmpty()) {
                    data.setMap("drop_chances", dropChances);
                }
                return null;
            }
        });
    }

    private V4293() {
    }
}

