/*
 * Decompiled with CFR 0.152.
 */
package ca.spottedleaf.dataconverter.types.json;

import ca.spottedleaf.dataconverter.types.ListType;
import ca.spottedleaf.dataconverter.types.MapType;
import ca.spottedleaf.dataconverter.types.ObjectType;
import ca.spottedleaf.dataconverter.types.TypeUtil;
import ca.spottedleaf.dataconverter.types.Types;
import ca.spottedleaf.dataconverter.types.json.JsonListType;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;

public final class JsonMapType
implements MapType {
    final JsonObject map;
    final boolean compressed;

    public JsonMapType(boolean compressed) {
        this.map = new JsonObject();
        this.compressed = compressed;
    }

    public JsonMapType(JsonObject map, boolean compressed) {
        this.map = map;
        this.compressed = compressed;
    }

    public TypeUtil<JsonElement> getTypeUtil() {
        return this.compressed ? Types.JSON_COMPRESSED : Types.JSON;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || obj.getClass() != JsonMapType.class) {
            return false;
        }
        return this.map.equals((Object)((JsonMapType)obj).map);
    }

    @Override
    public int hashCode() {
        return this.map.hashCode();
    }

    public String toString() {
        return "JsonMapType{map=" + String.valueOf(this.map) + ", compressed=" + this.compressed + "}";
    }

    public JsonObject getJson() {
        return this.map;
    }

    @Override
    public int size() {
        return this.map.entrySet().size();
    }

    @Override
    public boolean isEmpty() {
        return this.map.entrySet().isEmpty();
    }

    @Override
    public void clear() {
        this.map.entrySet().clear();
    }

    @Override
    public Set<String> keys() {
        LinkedHashSet<String> keys = new LinkedHashSet<String>();
        for (Map.Entry entry : this.map.entrySet()) {
            keys.add((String)entry.getKey());
        }
        return keys;
    }

    @Override
    public MapType copy() {
        return new JsonMapType(this.map.deepCopy(), this.compressed);
    }

    @Override
    public boolean hasKey(String key) {
        return this.map.has(key);
    }

    @Override
    public boolean hasKey(String key, ObjectType type) {
        JsonElement element = this.map.get(key);
        if (element == null) {
            return false;
        }
        if (type == ObjectType.UNDEFINED) {
            return true;
        }
        if (element.isJsonArray()) {
            return type == ObjectType.LIST;
        }
        if (element.isJsonObject()) {
            return type == ObjectType.MAP;
        }
        if (element.isJsonNull()) {
            return false;
        }
        JsonPrimitive primitive = (JsonPrimitive)element;
        if (primitive.isString()) {
            return type == ObjectType.STRING || this.compressed && type == ObjectType.NUMBER;
        }
        if (primitive.isBoolean()) {
            return type.isNumber();
        }
        Number number = primitive.getAsNumber();
        if (number instanceof Byte) {
            return type == ObjectType.BYTE || this.compressed && type == ObjectType.STRING;
        }
        if (number instanceof Short) {
            return type == ObjectType.SHORT || this.compressed && type == ObjectType.STRING;
        }
        if (number instanceof Integer) {
            return type == ObjectType.INT || this.compressed && type == ObjectType.STRING;
        }
        if (number instanceof Long) {
            return type == ObjectType.LONG || this.compressed && type == ObjectType.STRING;
        }
        if (number instanceof Float) {
            return type == ObjectType.FLOAT || this.compressed && type == ObjectType.STRING;
        }
        return type == ObjectType.DOUBLE || this.compressed && type == ObjectType.STRING;
    }

    @Override
    public void remove(String key) {
        this.map.remove(key);
    }

    @Override
    public Object getGeneric(String key) {
        JsonElement element = this.map.get(key);
        if (element == null || element.isJsonNull()) {
            return null;
        }
        if (element.isJsonObject()) {
            return new JsonMapType((JsonObject)element, this.compressed);
        }
        if (element.isJsonArray()) {
            return new JsonListType((JsonArray)element, this.compressed);
        }
        JsonPrimitive primitive = (JsonPrimitive)element;
        if (primitive.isNumber()) {
            return primitive.getAsNumber();
        }
        if (primitive.isString()) {
            return primitive.getAsString();
        }
        if (primitive.isBoolean()) {
            return primitive.getAsBoolean();
        }
        throw new IllegalStateException("Unknown json object " + String.valueOf(element));
    }

    @Override
    public Number getNumber(String key) {
        return this.getNumber(key, null);
    }

    @Override
    public Number getNumber(String key, Number dfl) {
        JsonElement element = this.map.get(key);
        if (element instanceof JsonPrimitive) {
            JsonPrimitive primitive = (JsonPrimitive)element;
            if (primitive.isNumber()) {
                return primitive.getAsNumber();
            }
            if (primitive.isBoolean()) {
                return primitive.getAsBoolean() ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
            }
            if (this.compressed && primitive.isString()) {
                try {
                    return Integer.parseInt(primitive.getAsString());
                }
                catch (NumberFormatException ex) {
                    return null;
                }
            }
        }
        return dfl;
    }

    @Override
    public boolean getBoolean(String key) {
        return this.getBoolean(key, false);
    }

    @Override
    public boolean getBoolean(String key, boolean dfl) {
        JsonElement element = this.map.get(key);
        if (element instanceof JsonPrimitive) {
            JsonPrimitive primitive = (JsonPrimitive)element;
            if (primitive.isNumber()) {
                return primitive.getAsNumber().byteValue() != 0;
            }
            if (primitive.isBoolean()) {
                return primitive.getAsBoolean();
            }
        }
        return dfl;
    }

    @Override
    public void setBoolean(String key, boolean val) {
        this.map.addProperty(key, Boolean.valueOf(val));
    }

    @Override
    public byte getByte(String key) {
        return this.getByte(key, (byte)0);
    }

    @Override
    public byte getByte(String key, byte dfl) {
        Number ret = this.getNumber(key, null);
        return ret == null ? dfl : ret.byteValue();
    }

    @Override
    public void setByte(String key, byte val) {
        this.map.addProperty(key, (Number)val);
    }

    @Override
    public short getShort(String key) {
        return this.getShort(key, (short)0);
    }

    @Override
    public short getShort(String key, short dfl) {
        Number ret = this.getNumber(key, null);
        return ret == null ? dfl : ret.shortValue();
    }

    @Override
    public void setShort(String key, short val) {
        this.map.addProperty(key, (Number)val);
    }

    @Override
    public int getInt(String key) {
        return this.getInt(key, 0);
    }

    @Override
    public int getInt(String key, int dfl) {
        Number ret = this.getNumber(key, null);
        return ret == null ? dfl : ret.intValue();
    }

    @Override
    public void setInt(String key, int val) {
        this.map.addProperty(key, (Number)val);
    }

    @Override
    public long getLong(String key) {
        return this.getLong(key, 0L);
    }

    @Override
    public long getLong(String key, long dfl) {
        Number ret = this.getNumber(key, null);
        return ret == null ? dfl : ret.longValue();
    }

    @Override
    public void setLong(String key, long val) {
        this.map.addProperty(key, (Number)val);
    }

    @Override
    public float getFloat(String key) {
        return this.getFloat(key, 0.0f);
    }

    @Override
    public float getFloat(String key, float dfl) {
        Number ret = this.getNumber(key, null);
        return ret == null ? dfl : ret.floatValue();
    }

    @Override
    public void setFloat(String key, float val) {
        this.map.addProperty(key, (Number)Float.valueOf(val));
    }

    @Override
    public double getDouble(String key) {
        return this.getDouble(key, 0.0);
    }

    @Override
    public double getDouble(String key, double dfl) {
        Number ret = this.getNumber(key, null);
        return ret == null ? dfl : ret.doubleValue();
    }

    @Override
    public void setDouble(String key, double val) {
        this.map.addProperty(key, (Number)val);
    }

    @Override
    public byte[] getBytes(String key) {
        return this.getBytes(key, null);
    }

    @Override
    public byte[] getBytes(String key, byte[] dfl) {
        return dfl;
    }

    @Override
    public void setBytes(String key, byte[] val) {
        throw new UnsupportedOperationException();
    }

    @Override
    public short[] getShorts(String key) {
        return this.getShorts(key, null);
    }

    @Override
    public short[] getShorts(String key, short[] dfl) {
        return dfl;
    }

    @Override
    public void setShorts(String key, short[] val) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int[] getInts(String key) {
        return this.getInts(key, null);
    }

    @Override
    public int[] getInts(String key, int[] dfl) {
        return dfl;
    }

    @Override
    public void setInts(String key, int[] val) {
        throw new UnsupportedOperationException();
    }

    @Override
    public long[] getLongs(String key) {
        return this.getLongs(key, null);
    }

    @Override
    public long[] getLongs(String key, long[] dfl) {
        return dfl;
    }

    @Override
    public void setLongs(String key, long[] val) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ListType getListUnchecked(String key) {
        return this.getListUnchecked(key, null);
    }

    @Override
    public ListType getListUnchecked(String key, ListType dfl) {
        JsonElement element = this.map.get(key);
        if (element instanceof JsonArray) {
            return new JsonListType((JsonArray)element, this.compressed);
        }
        return dfl;
    }

    @Override
    public void setList(String key, ListType val) {
        this.map.add(key, (JsonElement)((JsonListType)val).getJson());
    }

    @Override
    public MapType getMap(String key) {
        return this.getMap(key, null);
    }

    @Override
    public MapType getMap(String key, MapType dfl) {
        JsonElement element = this.map.get(key);
        if (element instanceof JsonObject) {
            return new JsonMapType((JsonObject)element, this.compressed);
        }
        return dfl;
    }

    @Override
    public void setMap(String key, MapType val) {
        this.map.add(key, (JsonElement)((JsonMapType)val).map);
    }

    @Override
    public String getString(String key) {
        return this.getString(key, null);
    }

    @Override
    public String getString(String key, String dfl) {
        JsonElement element = this.map.get(key);
        if (element instanceof JsonPrimitive) {
            JsonPrimitive primitive = (JsonPrimitive)element;
            if (primitive.isString()) {
                return primitive.getAsString();
            }
            if (this.compressed && primitive.isNumber()) {
                return primitive.getAsString();
            }
        }
        return dfl;
    }

    public String getForcedString(String key) {
        return this.getForcedString(key, null);
    }

    public String getForcedString(String key, String dfl) {
        JsonElement element = this.map.get(key);
        if (element instanceof JsonPrimitive) {
            JsonPrimitive primitive = (JsonPrimitive)element;
            if (primitive.isString()) {
                return primitive.getAsString();
            }
            if (primitive.isNumber()) {
                return primitive.getAsString();
            }
            return primitive.toString();
        }
        if (element != null) {
            return element.toString();
        }
        return dfl;
    }

    @Override
    public void setString(String key, String val) {
        this.map.addProperty(key, val);
    }
}

