/*
 * Decompiled with CFR 0.152.
 */
package ca.spottedleaf.moonrise.paper;

import ca.spottedleaf.dataconverter.minecraft.MCDataConverter;
import ca.spottedleaf.dataconverter.minecraft.datatypes.MCTypeRegistry;
import ca.spottedleaf.moonrise.common.PlatformHooks;
import ca.spottedleaf.moonrise.paper.util.BaseChunkSystemHooks;
import com.mojang.datafixers.DSL;
import com.mojang.datafixers.DataFixer;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Dynamic;
import io.papermc.paper.configuration.GlobalConfiguration;
import it.unimi.dsi.fastutil.longs.LongArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.server.level.ChunkHolder;
import net.minecraft.server.level.GenerationChunkHolder;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.level.TicketType;
import net.minecraft.util.ProblemReporter;
import net.minecraft.util.datafix.fixes.References;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.boss.EnderDragonPart;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.chunk.ProtoChunk;
import net.minecraft.world.level.chunk.status.ChunkStatusTasks;
import net.minecraft.world.level.chunk.storage.SerializableChunkData;
import net.minecraft.world.level.entity.EntityTypeTest;
import net.minecraft.world.level.storage.TagValueInput;
import net.minecraft.world.phys.AABB;
import org.bukkit.event.entity.EntityRemoveEvent;
import org.slf4j.Logger;
import org.spigotmc.TrackingRange;

public final class PaperHooks
extends BaseChunkSystemHooks
implements PlatformHooks {
    private static final Logger LOGGER = LogUtils.getLogger();

    @Override
    public String getBrand() {
        return "Paper";
    }

    @Override
    public int getLightEmission(BlockState blockState, BlockGetter world, BlockPos pos) {
        return blockState.getLightEmission();
    }

    @Override
    public Predicate<BlockState> maybeHasLightEmission() {
        return state -> state.getLightEmission() != 0;
    }

    @Override
    public boolean hasCurrentlyLoadingChunk() {
        return false;
    }

    @Override
    public LevelChunk getCurrentlyLoadingChunk(GenerationChunkHolder holder) {
        return null;
    }

    @Override
    public void setCurrentlyLoading(GenerationChunkHolder holder, LevelChunk levelChunk) {
    }

    @Override
    public void chunkFullStatusComplete(LevelChunk newChunk, ProtoChunk original) {
    }

    @Override
    public boolean allowAsyncTicketUpdates() {
        return true;
    }

    @Override
    public void onChunkHolderTicketChange(ServerLevel world, ChunkHolder holder, int oldLevel, int newLevel) {
    }

    @Override
    public void chunkUnloadFromWorld(LevelChunk chunk) {
    }

    @Override
    public void chunkSyncSave(ServerLevel world, ChunkAccess chunk, SerializableChunkData data) {
    }

    @Override
    public void onChunkWatch(ServerLevel world, LevelChunk chunk, ServerPlayer player) {
    }

    @Override
    public void onChunkUnWatch(ServerLevel world, ChunkPos chunk, ServerPlayer player) {
    }

    @Override
    public void addToGetEntities(Level world, Entity entity, AABB boundingBox, Predicate<? super Entity> predicate, List<Entity> into) {
        Collection<EnderDragonPart> parts = world.dragonParts();
        if (parts.isEmpty()) {
            return;
        }
        for (EnderDragonPart part : parts) {
            if (part == entity || !part.getBoundingBox().intersects(boundingBox) || predicate != null && !predicate.test(part)) continue;
            into.add(part);
        }
    }

    @Override
    public <T extends Entity> void addToGetEntities(Level world, EntityTypeTest<Entity, T> entityTypeTest, AABB boundingBox, Predicate<? super T> predicate, List<? super T> into, int maxCount) {
        if (into.size() >= maxCount) {
            return;
        }
        Collection<EnderDragonPart> parts = world.dragonParts();
        if (parts.isEmpty()) {
            return;
        }
        for (EnderDragonPart part : parts) {
            Entity casted;
            if (!part.getBoundingBox().intersects(boundingBox) || (casted = (Entity)entityTypeTest.tryCast(part)) == null || predicate != null && !predicate.test(casted)) continue;
            into.add(casted);
            if (into.size() < maxCount) continue;
            break;
        }
    }

    @Override
    public void entityMove(Entity entity, long oldSection, long newSection) {
    }

    @Override
    public boolean screenEntity(ServerLevel world, Entity entity, boolean fromDisk, boolean event) {
        return true;
    }

    @Override
    public long[] getCounterTypesUncached(TicketType type) {
        LongArrayList ret = new LongArrayList();
        if (type == TicketType.FORCED) {
            ret.add(0L);
        }
        if (type.shouldKeepDimensionActive()) {
            ret.add(1L);
        }
        return ret.toLongArray();
    }

    @Override
    public boolean configFixMC224294() {
        return true;
    }

    @Override
    public boolean configAutoConfigSendDistance() {
        return GlobalConfiguration.get().chunkLoadingAdvanced.autoConfigSendDistance;
    }

    @Override
    public double configPlayerMaxLoadRate() {
        return GlobalConfiguration.get().chunkLoadingBasic.playerMaxChunkLoadRate;
    }

    @Override
    public double configPlayerMaxGenRate() {
        return GlobalConfiguration.get().chunkLoadingBasic.playerMaxChunkGenerateRate;
    }

    @Override
    public double configPlayerMaxSendRate() {
        return GlobalConfiguration.get().chunkLoadingBasic.playerMaxChunkSendRate;
    }

    @Override
    public int configPlayerMaxConcurrentLoads() {
        return GlobalConfiguration.get().chunkLoadingAdvanced.playerMaxConcurrentChunkLoads;
    }

    @Override
    public int configPlayerMaxConcurrentGens() {
        return GlobalConfiguration.get().chunkLoadingAdvanced.playerMaxConcurrentChunkGenerates;
    }

    @Override
    public long configAutoSaveInterval(ServerLevel world) {
        return world.paperConfig().chunks.autoSaveInterval.value();
    }

    @Override
    public int configMaxAutoSavePerTick(ServerLevel world) {
        return world.paperConfig().chunks.maxAutoSaveChunksPerTick;
    }

    @Override
    public boolean configFixMC159283() {
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean forceNoSave(ChunkAccess chunk) {
        if (!(chunk instanceof LevelChunk)) return false;
        LevelChunk levelChunk = (LevelChunk)chunk;
        if (!levelChunk.mustNotSave) return false;
        return true;
    }

    @Override
    public CompoundTag convertNBT(DSL.TypeReference type, DataFixer dataFixer, CompoundTag nbt, int fromVersion, int toVersion) {
        if (type == References.PLAYER) {
            return MCDataConverter.convertTag(MCTypeRegistry.PLAYER, nbt, fromVersion, toVersion);
        }
        if (type == References.CHUNK) {
            return MCDataConverter.convertTag(MCTypeRegistry.CHUNK, nbt, fromVersion, toVersion);
        }
        if (type == References.STRUCTURE) {
            return MCDataConverter.convertTag(MCTypeRegistry.STRUCTURE, nbt, fromVersion, toVersion);
        }
        if (type == References.POI_CHUNK) {
            return MCDataConverter.convertTag(MCTypeRegistry.POI_CHUNK, nbt, fromVersion, toVersion);
        }
        if (type == References.ENTITY_CHUNK) {
            return MCDataConverter.convertTag(MCTypeRegistry.ENTITY_CHUNK, nbt, fromVersion, toVersion);
        }
        if (type == References.ITEM_STACK) {
            return MCDataConverter.convertTag(MCTypeRegistry.ITEM_STACK, nbt, fromVersion, toVersion);
        }
        if (type == References.ENTITY || type == References.ENTITY_TREE) {
            return MCDataConverter.convertTag(MCTypeRegistry.ENTITY, nbt, fromVersion, toVersion);
        }
        return (CompoundTag)dataFixer.update(type, new Dynamic<CompoundTag>(NbtOps.INSTANCE, nbt), fromVersion, toVersion).getValue();
    }

    @Override
    public boolean hasMainChunkLoadHook() {
        return false;
    }

    @Override
    public void mainChunkLoad(ChunkAccess chunk, SerializableChunkData chunkData) {
    }

    @Override
    public List<Entity> modifySavedEntities(ServerLevel world, int chunkX, int chunkZ, List<Entity> entities) {
        return entities;
    }

    @Override
    public void unloadEntity(Entity entity) {
        entity.setRemoved(Entity.RemovalReason.UNLOADED_TO_CHUNK, EntityRemoveEvent.Cause.UNLOAD);
    }

    @Override
    public void postLoadProtoChunk(ServerLevel world, ProtoChunk chunk) {
        try (ProblemReporter.ScopedCollector scopedCollector = new ProblemReporter.ScopedCollector(chunk.problemPath(), LOGGER);){
            ChunkStatusTasks.postLoadProtoChunk(world, TagValueInput.create((ProblemReporter)scopedCollector, (HolderLookup.Provider)world.registryAccess(), chunk.getEntities()), chunk.getPos());
        }
    }

    @Override
    public int modifyEntityTrackingRange(Entity entity, int currentRange) {
        return TrackingRange.getEntityTrackingRange(entity, currentRange);
    }

    @Override
    public boolean addTicketForEnderPearls(ServerLevel world) {
        return !world.paperConfig().misc.legacyEnderPearlBehavior;
    }
}

