/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.paper;

import com.destroystokyo.paper.PaperSkinParts;
import com.destroystokyo.paper.SkinParts;
import io.papermc.paper.InternalAPIBridge;
import io.papermc.paper.adventure.PaperAdventure;
import io.papermc.paper.command.brigadier.CommandSourceStack;
import io.papermc.paper.datacomponent.item.PaperResolvableProfile;
import io.papermc.paper.datacomponent.item.ResolvableProfile;
import io.papermc.paper.world.damagesource.CombatEntry;
import io.papermc.paper.world.damagesource.FallLocationType;
import io.papermc.paper.world.damagesource.PaperCombatEntryWrapper;
import io.papermc.paper.world.damagesource.PaperCombatTrackerWrapper;
import java.util.function.Predicate;
import net.kyori.adventure.text.Component;
import net.minecraft.Optionull;
import net.minecraft.commands.PermissionSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.FallLocation;
import net.minecraft.world.entity.decoration.Mannequin;
import org.bukkit.block.Biome;
import org.bukkit.craftbukkit.block.CraftBiome;
import org.bukkit.craftbukkit.damage.CraftDamageEffect;
import org.bukkit.craftbukkit.damage.CraftDamageSource;
import org.bukkit.craftbukkit.entity.CraftLivingEntity;
import org.bukkit.damage.DamageEffect;
import org.bukkit.entity.LivingEntity;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

@NullMarked
public class PaperServerInternalAPIBridge
implements InternalAPIBridge {
    public static final PaperServerInternalAPIBridge INSTANCE = new PaperServerInternalAPIBridge();

    public DamageEffect getDamageEffect(String key) {
        return CraftDamageEffect.getById(key);
    }

    public Biome constructLegacyCustomBiome() {
        class Holder {
            static final Biome LEGACY_CUSTOM = new CraftBiome.LegacyCustomBiomeImpl();

            Holder(PaperServerInternalAPIBridge this$0) {
            }
        }
        return Holder.LEGACY_CUSTOM;
    }

    public CombatEntry createCombatEntry(LivingEntity entity, org.bukkit.damage.DamageSource damageSource, float damage) {
        net.minecraft.world.entity.LivingEntity mob = ((CraftLivingEntity)entity).getHandle();
        FallLocation fallLocation = FallLocation.getCurrentFallLocation(mob);
        return this.createCombatEntry(((CraftDamageSource)damageSource).getHandle(), damage, fallLocation, (float)mob.fallDistance);
    }

    public CombatEntry createCombatEntry(org.bukkit.damage.DamageSource damageSource, float damage, @Nullable FallLocationType fallLocationType, float fallDistance) {
        return this.createCombatEntry(((CraftDamageSource)damageSource).getHandle(), damage, Optionull.map(fallLocationType, PaperCombatTrackerWrapper::paperToMinecraft), fallDistance);
    }

    private CombatEntry createCombatEntry(DamageSource damageSource, float damage, @Nullable FallLocation fallLocation, float fallDistance) {
        return new PaperCombatEntryWrapper(new net.minecraft.world.damagesource.CombatEntry(damageSource, damage, fallLocation, fallDistance));
    }

    public Predicate<CommandSourceStack> restricted(Predicate<CommandSourceStack> predicate) {
        record RestrictedPredicate(Predicate<CommandSourceStack> predicate) implements Predicate<CommandSourceStack>,
        PermissionSource.RestrictedMarker
        {
            @Override
            public boolean test(CommandSourceStack commandSourceStack) {
                return this.predicate.test(commandSourceStack);
            }
        }
        return new RestrictedPredicate(predicate);
    }

    public ResolvableProfile defaultMannequinProfile() {
        return new PaperResolvableProfile(Mannequin.DEFAULT_PROFILE);
    }

    public SkinParts.Mutable allSkinParts() {
        return new PaperSkinParts.Mutable(Mannequin.ALL_LAYERS);
    }

    public Component defaultMannequinDescription() {
        return PaperAdventure.asAdventure(Mannequin.DEFAULT_DESCRIPTION);
    }
}

