/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.paper.command.subcommands;

import com.google.common.collect.Maps;
import io.papermc.paper.FeatureHooks;
import io.papermc.paper.command.CommandUtil;
import io.papermc.paper.command.PaperSubcommand;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.event.ClickEvent;
import net.kyori.adventure.text.event.HoverEvent;
import net.kyori.adventure.text.event.HoverEventSource;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerChunkCache;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Marker;
import net.minecraft.world.level.ChunkPos;
import org.apache.commons.lang3.tuple.MutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.bukkit.Bukkit;
import org.bukkit.HeightMap;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.craftbukkit.CraftWorld;
import org.bukkit.entity.Player;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.framework.qual.DefaultQualifier;

@DefaultQualifier(value=NonNull.class)
public final class EntityCommand
implements PaperSubcommand {
    @Override
    public boolean execute(CommandSender sender, String subCommand, String[] args) {
        this.listEntities(sender, args);
        return true;
    }

    @Override
    public List<String> tabComplete(CommandSender sender, String subCommand, String[] args) {
        if (args.length == 1) {
            return CommandUtil.getListMatchingLast(sender, args, "help", "list");
        }
        if (args.length == 2) {
            return CommandUtil.getListMatchingLast(sender, args, BuiltInRegistries.ENTITY_TYPE.keySet());
        }
        return Collections.emptyList();
    }

    private void listEntities(CommandSender sender, String[] args) {
        if (args.length < 1 || !args[0].toLowerCase(Locale.ROOT).equals("list")) {
            sender.sendMessage((Component)Component.text((String)"Use /paper entity [list] help for more information on a specific command", (TextColor)NamedTextColor.RED));
            return;
        }
        if ("list".equals(args[0].toLowerCase(Locale.ROOT))) {
            String worldName;
            String filter = "*";
            if (args.length > 1) {
                if (args[1].toLowerCase(Locale.ROOT).equals("help")) {
                    sender.sendMessage((Component)Component.text((String)"Use /paper entity list [filter] [worldName] to get entity info that matches the optional filter.", (TextColor)NamedTextColor.RED));
                    return;
                }
                filter = args[1];
            }
            String cleanfilter = filter.replace("?", ".?").replace("*", ".*?");
            Set names = BuiltInRegistries.ENTITY_TYPE.keySet().stream().filter(n -> n.toString().matches(cleanfilter)).collect(Collectors.toSet());
            if (names.isEmpty()) {
                sender.sendMessage((Component)Component.text((String)"Invalid filter, does not match any entities. Use /paper entity list for a proper list", (TextColor)NamedTextColor.RED));
                sender.sendMessage((Component)Component.text((String)"Usage: /paper entity list [filter] [worldName]", (TextColor)NamedTextColor.RED));
                return;
            }
            if (args.length > 2) {
                worldName = args[2];
            } else if (sender instanceof Player) {
                worldName = ((Player)sender).getWorld().getName();
            } else {
                sender.sendMessage((Component)Component.text((String)"Please specify the name of a world", (TextColor)NamedTextColor.RED));
                sender.sendMessage((Component)Component.text((String)"To do so without a filter, specify '*' as the filter", (TextColor)NamedTextColor.RED));
                sender.sendMessage((Component)Component.text((String)"Usage: /paper entity list [filter] [worldName]", (TextColor)NamedTextColor.RED));
                return;
            }
            HashMap list = Maps.newHashMap();
            @Nullable World bukkitWorld = Bukkit.getWorld((String)worldName);
            if (bukkitWorld == null) {
                sender.sendMessage((Component)Component.text((String)("Could not load world for " + worldName + ". Please select a valid world."), (TextColor)NamedTextColor.RED));
                sender.sendMessage((Component)Component.text((String)"Usage: /paper entity list [filter] [worldName]", (TextColor)NamedTextColor.RED));
                return;
            }
            ServerLevel world = ((CraftWorld)bukkitWorld).getHandle();
            HashMap nonEntityTicking = Maps.newHashMap();
            ServerChunkCache chunkProviderServer = world.getChunkSource();
            FeatureHooks.getAllEntities(world).forEach(e -> {
                ResourceLocation key = EntityType.getKey(e.getType());
                MutablePair info = list.computeIfAbsent(key, k -> MutablePair.of((Object)0, (Object)Maps.newHashMap()));
                ChunkPos chunk = e.chunkPosition();
                MutablePair mutablePair = info;
                Integer n = (Integer)mutablePair.left;
                mutablePair.left = (Integer)mutablePair.left + 1;
                ((Map)info.right).put(chunk, ((Map)info.right).getOrDefault(chunk, 0) + 1);
                if (!world.isPositionEntityTicking(e.blockPosition()) || e instanceof Marker && !world.paperConfig().entities.markers.tick) {
                    nonEntityTicking.merge(key, 1, Integer::sum);
                }
            });
            if (names.size() == 1) {
                ResourceLocation name = (ResourceLocation)names.iterator().next();
                Pair info = (Pair)list.get(name);
                int nonTicking = nonEntityTicking.getOrDefault(name, 0);
                if (info == null) {
                    sender.sendMessage((Component)Component.text((String)"No entities found.", (TextColor)NamedTextColor.RED));
                    return;
                }
                sender.sendMessage("Entity: " + String.valueOf(name) + " Total Ticking: " + ((Integer)info.getLeft() - nonTicking) + ", Total Non-Ticking: " + nonTicking);
                ((Map)info.getRight()).entrySet().stream().sorted((a, b) -> !((Integer)a.getValue()).equals(b.getValue()) ? (Integer)b.getValue() - (Integer)a.getValue() : ((ChunkPos)a.getKey()).toString().compareTo(((ChunkPos)b.getKey()).toString())).limit(10L).forEach(e -> {
                    int x = (((ChunkPos)e.getKey()).x << 4) + 8;
                    int z = (((ChunkPos)e.getKey()).z << 4) + 8;
                    Component message = ((TextComponent)Component.text((String)("  " + String.valueOf(e.getValue()) + ": " + ((ChunkPos)e.getKey()).x + ", " + ((ChunkPos)e.getKey()).z + (chunkProviderServer.isPositionTicking(((ChunkPos)e.getKey()).toLong()) ? " (Ticking)" : " (Non-Ticking)"))).hoverEvent((HoverEventSource)HoverEvent.showText((Component)Component.text((String)"Click to teleport to chunk", (TextColor)NamedTextColor.GREEN)))).clickEvent(ClickEvent.clickEvent((ClickEvent.Action)ClickEvent.Action.RUN_COMMAND, (String)("/minecraft:execute as @s in " + String.valueOf(world.getWorld().getKey()) + " run tp " + x + " " + (world.getWorld().getHighestBlockYAt(x, z, HeightMap.MOTION_BLOCKING) + 1) + " " + z)));
                    sender.sendMessage(message);
                });
            } else {
                List<Pair> info = list.entrySet().stream().filter(e -> names.contains(e.getKey())).map(e -> Pair.of((Object)((ResourceLocation)e.getKey()), (Object)((Integer)((MutablePair)e.getValue()).left))).sorted((a, b) -> !((Integer)a.getRight()).equals(b.getRight()) ? (Integer)b.getRight() - (Integer)a.getRight() : ((ResourceLocation)a.getKey()).toString().compareTo(((ResourceLocation)b.getKey()).toString())).toList();
                if (info.isEmpty()) {
                    sender.sendMessage((Component)Component.text((String)"No entities found.", (TextColor)NamedTextColor.RED));
                    return;
                }
                int count = info.stream().mapToInt(Pair::getRight).sum();
                int nonTickingCount = nonEntityTicking.values().stream().mapToInt(Integer::intValue).sum();
                sender.sendMessage("Total Ticking: " + (count - nonTickingCount) + ", Total Non-Ticking: " + nonTickingCount);
                info.forEach(e -> {
                    int nonTicking = nonEntityTicking.getOrDefault(e.getKey(), 0);
                    sender.sendMessage("  " + ((Integer)e.getValue() - nonTicking) + " (" + nonTicking + ") : " + String.valueOf(e.getKey()));
                });
                sender.sendMessage("* First number is ticking entities, second number is non-ticking entities");
            }
        }
    }
}

