/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.paper.commands;

import io.papermc.paper.adventure.PaperAdventure;
import java.util.function.Consumer;
import net.kyori.adventure.audience.MessageType;
import net.kyori.adventure.identity.Identity;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import net.minecraft.commands.CommandSource;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import org.bukkit.command.CommandSender;
import org.bukkit.craftbukkit.CraftServer;
import org.bukkit.craftbukkit.command.ServerCommandSender;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.framework.qual.DefaultQualifier;

@DefaultQualifier(value=NonNull.class)
public final class FeedbackForwardingSender
extends ServerCommandSender {
    private final Consumer<? super net.kyori.adventure.text.Component> feedback;
    private final CraftServer server;

    public FeedbackForwardingSender(Consumer<? super net.kyori.adventure.text.Component> feedback, CraftServer server) {
        super(((ServerCommandSender)server.getConsoleSender()).perm);
        this.server = server;
        this.feedback = feedback;
    }

    public void sendMessage(String message) {
        this.sendMessage((net.kyori.adventure.text.Component)LegacyComponentSerializer.legacySection().deserialize(message));
    }

    public void sendMessage(String ... messages) {
        for (String message : messages) {
            this.sendMessage(message);
        }
    }

    public void sendMessage(Identity identity, net.kyori.adventure.text.Component message, MessageType type) {
        this.feedback.accept((net.kyori.adventure.text.Component)message);
    }

    public String getName() {
        return "FeedbackForwardingSender";
    }

    public net.kyori.adventure.text.Component name() {
        return net.kyori.adventure.text.Component.text((String)this.getName());
    }

    public boolean isOp() {
        return true;
    }

    public void setOp(boolean value) {
        throw new UnsupportedOperationException("Cannot change operator status of " + this.getClass().getName());
    }

    public CommandSourceStack asVanilla() {
        @Nullable ServerLevel respawnDimension = this.server.getServer().findRespawnDimension();
        return new CommandSourceStack(new Source(this), respawnDimension == null ? Vec3.ZERO : Vec3.atLowerCornerOf(respawnDimension.getRespawnData().pos()), Vec2.ZERO, respawnDimension, 4, this.getName(), Component.literal(this.getName()), this.server.getServer(), null);
    }

    private record Source(FeedbackForwardingSender sender) implements CommandSource
    {
        @Override
        public void sendSystemMessage(Component message) {
            this.sender.sendMessage(Identity.nil(), PaperAdventure.asAdventure(message));
        }

        @Override
        public boolean acceptsSuccess() {
            return true;
        }

        @Override
        public boolean acceptsFailure() {
            return true;
        }

        @Override
        public boolean shouldInformAdmins() {
            return false;
        }

        @Override
        public CommandSender getBukkitSender(CommandSourceStack stack) {
            return this.sender;
        }
    }
}

