/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.paper.configuration.serializer.registry;

import io.leangen.geantyref.TypeToken;
import java.lang.reflect.AnnotatedType;
import java.util.function.Predicate;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import org.spongepowered.configurate.serialize.ScalarSerializer;
import org.spongepowered.configurate.serialize.SerializationException;

abstract class RegistryEntrySerializer<T, R>
extends ScalarSerializer.Annotated<T> {
    private final RegistryAccess registryAccess;
    private final ResourceKey<? extends Registry<R>> registryKey;
    private final boolean omitMinecraftNamespace;

    protected RegistryEntrySerializer(TypeToken<T> type, RegistryAccess registryAccess, ResourceKey<? extends Registry<R>> registryKey, boolean omitMinecraftNamespace) {
        super(type);
        this.registryAccess = registryAccess;
        this.registryKey = registryKey;
        this.omitMinecraftNamespace = omitMinecraftNamespace;
    }

    protected RegistryEntrySerializer(Class<T> type, RegistryAccess registryAccess, ResourceKey<? extends Registry<R>> registryKey, boolean omitMinecraftNamespace) {
        super(type);
        this.registryAccess = registryAccess;
        this.registryKey = registryKey;
        this.omitMinecraftNamespace = omitMinecraftNamespace;
    }

    protected final Registry<R> registry() {
        return this.registryAccess.lookupOrThrow(this.registryKey);
    }

    protected abstract T convertFromResourceKey(ResourceKey<R> var1) throws SerializationException;

    public final T deserialize(AnnotatedType type, Object obj) throws SerializationException {
        return this.convertFromResourceKey(this.deserializeKey(obj));
    }

    protected abstract ResourceKey<R> convertToResourceKey(T var1);

    protected final Object serialize(AnnotatedType type, T item, Predicate<Class<?>> typeSupported) {
        ResourceKey<R> key = this.convertToResourceKey(item);
        if (this.omitMinecraftNamespace && key.location().getNamespace().equals("minecraft")) {
            return key.location().getPath();
        }
        return key.location().toString();
    }

    private ResourceKey<R> deserializeKey(Object input) throws SerializationException {
        ResourceLocation key = ResourceLocation.tryParse(input.toString());
        if (key == null) {
            throw new SerializationException("Could not create a key from " + String.valueOf(input));
        }
        return ResourceKey.create(this.registryKey, key);
    }
}

