/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.paper.datacomponent.item;

import com.google.common.base.Preconditions;
import io.papermc.paper.datacomponent.item.PotionContents;
import io.papermc.paper.util.MCUtil;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import net.minecraft.world.effect.MobEffectInstance;
import org.bukkit.Color;
import org.bukkit.craftbukkit.potion.CraftPotionType;
import org.bukkit.craftbukkit.potion.CraftPotionUtil;
import org.bukkit.craftbukkit.util.Handleable;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionType;
import org.jetbrains.annotations.Unmodifiable;
import org.jspecify.annotations.Nullable;

public record PaperPotionContents(net.minecraft.world.item.alchemy.PotionContents impl) implements PotionContents,
Handleable<net.minecraft.world.item.alchemy.PotionContents>
{
    @Override
    public net.minecraft.world.item.alchemy.PotionContents getHandle() {
        return this.impl;
    }

    public @Unmodifiable List<PotionEffect> customEffects() {
        return MCUtil.transformUnmodifiable(this.impl.customEffects(), CraftPotionUtil::toBukkit);
    }

    public @Nullable PotionType potion() {
        return this.impl.potion().map(CraftPotionType::minecraftHolderToBukkit).orElse(null);
    }

    public @Nullable Color customColor() {
        return this.impl.customColor().map(Color::fromARGB).orElse(null);
    }

    public @Nullable String customName() {
        return this.impl.customName().orElse(null);
    }

    public @Unmodifiable List<PotionEffect> allEffects() {
        return StreamSupport.stream(this.impl.getAllEffects().spliterator(), false).map(CraftPotionUtil::toBukkit).collect(Collectors.toUnmodifiableList());
    }

    public Color computeEffectiveColor() {
        return Color.fromARGB((int)this.impl.getColor());
    }

    static final class BuilderImpl
    implements PotionContents.Builder {
        private final List<MobEffectInstance> customEffects = new ObjectArrayList();
        private @Nullable PotionType type;
        private @Nullable Color color;
        private @Nullable String customName;

        BuilderImpl() {
        }

        public PotionContents.Builder potion(@Nullable PotionType type) {
            this.type = type;
            return this;
        }

        public PotionContents.Builder customColor(@Nullable Color color) {
            this.color = color;
            return this;
        }

        public PotionContents.Builder customName(@Nullable String name) {
            Preconditions.checkArgument((name == null || name.length() <= Short.MAX_VALUE ? 1 : 0) != 0, (String)"Custom name is longer than %s characters", (int)Short.MAX_VALUE);
            this.customName = name;
            return this;
        }

        public PotionContents.Builder addCustomEffect(PotionEffect effect) {
            this.customEffects.add(CraftPotionUtil.fromBukkit(effect));
            return this;
        }

        public PotionContents.Builder addCustomEffects(List<PotionEffect> effects) {
            effects.forEach(this::addCustomEffect);
            return this;
        }

        public PotionContents build() {
            if (this.type == null && this.color == null && this.customEffects.isEmpty() && this.customName == null) {
                return new PaperPotionContents(net.minecraft.world.item.alchemy.PotionContents.EMPTY);
            }
            return new PaperPotionContents(new net.minecraft.world.item.alchemy.PotionContents(Optional.ofNullable(this.type).map(CraftPotionType::bukkitToMinecraftHolder), Optional.ofNullable(this.color).map(Color::asARGB), (List<MobEffectInstance>)new ObjectArrayList(this.customEffects), Optional.ofNullable(this.customName)));
        }
    }
}

