/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.paper.plugin.manager;

import com.destroystokyo.paper.util.SneakyThrow;
import io.papermc.paper.plugin.entrypoint.Entrypoint;
import io.papermc.paper.plugin.entrypoint.LaunchEntryPointHandler;
import io.papermc.paper.plugin.entrypoint.dependency.MetaDependencyTree;
import io.papermc.paper.plugin.provider.PluginProvider;
import io.papermc.paper.plugin.provider.type.paper.PaperPluginParent;
import io.papermc.paper.plugin.storage.ServerPluginProviderStorage;
import java.util.Optional;
import org.bukkit.plugin.InvalidPluginException;
import org.bukkit.plugin.java.JavaPlugin;

class SingularRuntimePluginProviderStorage
extends ServerPluginProviderStorage {
    private final MetaDependencyTree dependencyTree;
    private PluginProvider<JavaPlugin> lastProvider;
    private JavaPlugin singleLoaded;

    SingularRuntimePluginProviderStorage(MetaDependencyTree dependencyTree) {
        this.dependencyTree = dependencyTree;
    }

    @Override
    public void register(PluginProvider<JavaPlugin> provider) {
        super.register(provider);
        if (this.lastProvider != null) {
            SneakyThrow.sneaky((Throwable)new InvalidPluginException("Plugin registered two JavaPlugins"));
        }
        if (provider instanceof PaperPluginParent.PaperServerPluginProvider) {
            throw new IllegalStateException("Cannot register paper plugins during runtime!");
        }
        this.lastProvider = provider;
        LaunchEntryPointHandler.INSTANCE.register(Entrypoint.PLUGIN, provider);
    }

    @Override
    public void enter() {
        PluginProvider<JavaPlugin> provider = this.lastProvider;
        if (provider == null) {
            return;
        }
        super.enter();
    }

    @Override
    public void processProvided(PluginProvider<JavaPlugin> provider, JavaPlugin provided) {
        super.processProvided(provider, provided);
        this.singleLoaded = provided;
    }

    @Override
    public boolean throwOnCycle() {
        return false;
    }

    public Optional<JavaPlugin> getSingleLoaded() {
        return Optional.ofNullable(this.singleLoaded);
    }

    @Override
    public MetaDependencyTree createDependencyTree() {
        return this.dependencyTree;
    }
}

