/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.paper.registry.data;

import io.papermc.paper.registry.PaperRegistryBuilder;
import io.papermc.paper.registry.data.PigVariantRegistryEntry;
import io.papermc.paper.registry.data.client.ClientTextureAsset;
import io.papermc.paper.registry.data.util.Checks;
import io.papermc.paper.registry.data.util.Conversions;
import net.minecraft.core.ClientAsset;
import net.minecraft.world.entity.animal.PigVariant;
import net.minecraft.world.entity.variant.ModelAndTexture;
import net.minecraft.world.entity.variant.SpawnPrioritySelectors;
import org.bukkit.entity.Pig;
import org.jspecify.annotations.Nullable;

public class PaperPigVariantRegistryEntry
implements PigVariantRegistryEntry {
    protected @Nullable PigVariant.ModelType model;
    protected @Nullable ClientAsset.ResourceTexture clientTextureAsset;
    protected SpawnPrioritySelectors spawnConditions;
    protected final Conversions conversions;

    public PaperPigVariantRegistryEntry(Conversions conversions, @Nullable PigVariant internal) {
        this.conversions = conversions;
        if (internal == null) {
            this.spawnConditions = SpawnPrioritySelectors.EMPTY;
            return;
        }
        this.clientTextureAsset = internal.modelAndTexture().asset();
        this.model = internal.modelAndTexture().model();
        this.spawnConditions = internal.spawnConditions();
    }

    public ClientTextureAsset clientTextureAsset() {
        return this.conversions.asBukkit(Checks.asConfigured(this.clientTextureAsset, "clientTextureAsset"));
    }

    public PigVariantRegistryEntry.Model model() {
        return switch (Checks.asConfigured(this.model, "model")) {
            default -> throw new MatchException(null, null);
            case PigVariant.ModelType.NORMAL -> PigVariantRegistryEntry.Model.NORMAL;
            case PigVariant.ModelType.COLD -> PigVariantRegistryEntry.Model.COLD;
        };
    }

    public static final class PaperBuilder
    extends PaperPigVariantRegistryEntry
    implements PigVariantRegistryEntry.Builder,
    PaperRegistryBuilder<PigVariant, Pig.Variant> {
        public PaperBuilder(Conversions conversions, @Nullable PigVariant internal) {
            super(conversions, internal);
        }

        public PigVariantRegistryEntry.Builder clientTextureAsset(ClientTextureAsset clientTextureAsset) {
            this.clientTextureAsset = this.conversions.asVanilla(Checks.asArgument(clientTextureAsset, "clientTextureAsset"));
            return this;
        }

        public PigVariantRegistryEntry.Builder model(PigVariantRegistryEntry.Model model) {
            this.model = switch (Checks.asArgument(model, "model")) {
                default -> throw new MatchException(null, null);
                case PigVariantRegistryEntry.Model.NORMAL -> PigVariant.ModelType.NORMAL;
                case PigVariantRegistryEntry.Model.COLD -> PigVariant.ModelType.COLD;
            };
            return this;
        }

        @Override
        public PigVariant build() {
            return new PigVariant(new ModelAndTexture<PigVariant.ModelType>(Checks.asConfigured(this.model, "model"), Checks.asConfigured(this.clientTextureAsset, "clientTextureAsset")), Checks.asConfigured(this.spawnConditions, "spawnConditions"));
        }
    }
}

