/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.paper.registry.data.dialog;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.Encoder;
import com.mojang.serialization.Lifecycle;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.papermc.paper.adventure.AdventureCodecs;
import io.papermc.paper.dialog.Dialog;
import io.papermc.paper.dialog.PaperDialog;
import io.papermc.paper.registry.RegistryKey;
import io.papermc.paper.registry.data.dialog.ActionButton;
import io.papermc.paper.registry.data.dialog.DialogBase;
import io.papermc.paper.registry.data.dialog.action.DialogAction;
import io.papermc.paper.registry.data.dialog.body.DialogBody;
import io.papermc.paper.registry.data.dialog.body.ItemDialogBody;
import io.papermc.paper.registry.data.dialog.body.PlainMessageDialogBody;
import io.papermc.paper.registry.data.dialog.input.BooleanDialogInput;
import io.papermc.paper.registry.data.dialog.input.DialogInput;
import io.papermc.paper.registry.data.dialog.input.NumberRangeDialogInput;
import io.papermc.paper.registry.data.dialog.input.SingleOptionDialogInput;
import io.papermc.paper.registry.data.dialog.input.TextDialogInput;
import io.papermc.paper.util.PaperCodecs;
import java.lang.runtime.SwitchBootstraps;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.kyori.adventure.key.Key;
import net.kyori.adventure.nbt.api.BinaryTagHolder;
import net.kyori.adventure.text.Component;
import net.minecraft.Util;
import net.minecraft.core.MappedRegistry;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.dialog.action.ParsedTemplate;
import net.minecraft.util.ExtraCodecs;
import org.bukkit.craftbukkit.inventory.CraftItemStack;
import org.bukkit.inventory.ItemStack;

public final class PaperDialogCodecs {
    private static final MapCodec<DialogAction.CommandTemplateAction> COMMAND_TEMPLATE_ACTION_CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.STRING.fieldOf("template").forGetter(DialogAction.CommandTemplateAction::template)).apply((Applicative)instance, DialogAction::commandTemplate));
    private static final MapCodec<DialogAction.CustomClickAction> CUSTOM_ALL_ACTION_CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)AdventureCodecs.KEY_CODEC.fieldOf("id").forGetter(DialogAction.CustomClickAction::id), (App)AdventureCodecs.BINARY_TAG_HOLDER_COMPOUND_CODEC.optionalFieldOf("additions").forGetter(action -> Optional.ofNullable(action.additions()))).apply((Applicative)instance, (key, binaryTagHolder) -> DialogAction.customClick((Key)key, (BinaryTagHolder)binaryTagHolder.orElse(null))));
    private static final Map<AdventureCodecs.ClickEventType, MapCodec<DialogAction.StaticAction>> STATIC_ACTION_CODECS = Arrays.stream(AdventureCodecs.CLICK_EVENT_TYPES.get()).collect(Collectors.toMap(Function.identity(), type -> type.codec().xmap(DialogAction::staticAction, DialogAction.StaticAction::value)));
    private static final Registry<MapCodec<? extends DialogAction>> DIALOG_ACTION_TYPES = Util.make(() -> {
        MappedRegistry registry = new MappedRegistry(ResourceKey.createRegistryKey(ResourceLocation.fromNamespaceAndPath("paper", "dialog_action_type")), Lifecycle.experimental());
        STATIC_ACTION_CODECS.forEach((clickType, actionCodec) -> Registry.register(registry, clickType.getSerializedName(), actionCodec));
        Registry.register(registry, "dynamic/run_command", COMMAND_TEMPLATE_ACTION_CODEC);
        Registry.register(registry, "dynamic/custom", CUSTOM_ALL_ACTION_CODEC);
        return registry.freeze();
    });
    private static final Function<DialogAction, MapCodec<? extends DialogAction>> GET_DIALOG_ACTION_TYPE = dialogAction -> {
        DialogAction dialogAction2 = dialogAction;
        Objects.requireNonNull(dialogAction2);
        DialogAction selector0$temp = dialogAction2;
        int index$1 = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{DialogAction.CommandTemplateAction.class, DialogAction.CustomClickAction.class, DialogAction.StaticAction.class}, (Object)selector0$temp, index$1)) {
            default -> throw new MatchException(null, null);
            case 0 -> {
                DialogAction.CommandTemplateAction $ = (DialogAction.CommandTemplateAction)selector0$temp;
                yield COMMAND_TEMPLATE_ACTION_CODEC;
            }
            case 1 -> {
                DialogAction.CustomClickAction $ = (DialogAction.CustomClickAction)selector0$temp;
                yield CUSTOM_ALL_ACTION_CODEC;
            }
            case 2 -> {
                DialogAction.StaticAction action = (DialogAction.StaticAction)selector0$temp;
                yield STATIC_ACTION_CODECS.get(AdventureCodecs.GET_CLICK_EVENT_TYPE.apply(action.value()));
            }
        };
    };
    private static final Codec<DialogAction> DIALOG_ACTION_CODEC = DIALOG_ACTION_TYPES.byNameCodec().dispatch(GET_DIALOG_ACTION_TYPE, Function.identity());
    public static final Codec<ActionButton> ACTION_BUTTON_CODEC = RecordCodecBuilder.create(instance -> instance.group((App)AdventureCodecs.COMPONENT_CODEC.fieldOf("label").forGetter(ActionButton::label), (App)AdventureCodecs.COMPONENT_CODEC.optionalFieldOf("tooltip").forGetter(button -> Optional.ofNullable(button.tooltip())), (App)net.minecraft.server.dialog.Dialog.WIDTH_CODEC.optionalFieldOf("width", (Object)150).forGetter(ActionButton::width), (App)DIALOG_ACTION_CODEC.optionalFieldOf("action").forGetter(button -> Optional.ofNullable(button.action()))).apply((Applicative)instance, (label, tooltip, width, action) -> ActionButton.create((Component)label, (Component)tooltip.orElse(null), (int)width, (DialogAction)action.orElse(null))));
    private static final MapCodec<PlainMessageDialogBody> PLAIN_MESSAGE_BODY_CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)AdventureCodecs.COMPONENT_CODEC.fieldOf("contents").forGetter(PlainMessageDialogBody::contents), (App)net.minecraft.server.dialog.Dialog.WIDTH_CODEC.optionalFieldOf("width", (Object)200).forGetter(PlainMessageDialogBody::width)).apply((Applicative)instance, DialogBody::plainMessage));
    private static final Codec<PlainMessageDialogBody> SIMPLE_PLAIN_MESSAGE_BODY_CODEC = Codec.withAlternative((Codec)PLAIN_MESSAGE_BODY_CODEC.codec(), AdventureCodecs.COMPONENT_CODEC, component -> DialogBody.plainMessage((Component)component, (int)200));
    private static final MapCodec<ItemDialogBody> ITEM_BODY_CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)net.minecraft.world.item.ItemStack.STRICT_CODEC.xmap(CraftItemStack::asBukkitCopy, CraftItemStack::asNMSCopy).fieldOf("item").forGetter(ItemDialogBody::item), (App)SIMPLE_PLAIN_MESSAGE_BODY_CODEC.optionalFieldOf("description").forGetter(body -> Optional.ofNullable(body.description())), (App)Codec.BOOL.optionalFieldOf("show_decorations", (Object)true).forGetter(ItemDialogBody::showDecorations), (App)Codec.BOOL.optionalFieldOf("show_tooltip", (Object)true).forGetter(ItemDialogBody::showTooltip), (App)ExtraCodecs.intRange(1, 256).optionalFieldOf("width", (Object)16).forGetter(ItemDialogBody::width), (App)ExtraCodecs.intRange(1, 256).optionalFieldOf("height", (Object)16).forGetter(ItemDialogBody::height)).apply((Applicative)instance, (itemStack, plainMessageBody, showDecorations, showTooltip, width, height) -> DialogBody.item((ItemStack)itemStack, (PlainMessageDialogBody)plainMessageBody.orElse(null), (boolean)showDecorations, (boolean)showTooltip, (int)width, (int)height)));
    private static final Registry<MapCodec<? extends DialogBody>> DIALOG_BODY_TYPES = Util.make(() -> {
        MappedRegistry registry = new MappedRegistry(ResourceKey.createRegistryKey(ResourceLocation.fromNamespaceAndPath("paper", "dialog_body_type")), Lifecycle.experimental());
        Registry.register(registry, "item", ITEM_BODY_CODEC);
        Registry.register(registry, "plain_message", PLAIN_MESSAGE_BODY_CODEC);
        return registry.freeze();
    });
    private static final Function<DialogBody, MapCodec<? extends DialogBody>> GET_DIALOG_BODY_TYPE = dialogAction -> {
        DialogBody dialogBody = dialogAction;
        Objects.requireNonNull(dialogBody);
        DialogBody selector0$temp = dialogBody;
        int index$1 = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{PlainMessageDialogBody.class, ItemDialogBody.class}, (Object)selector0$temp, index$1)) {
            default -> throw new MatchException(null, null);
            case 0 -> {
                PlainMessageDialogBody $ = (PlainMessageDialogBody)selector0$temp;
                yield PLAIN_MESSAGE_BODY_CODEC;
            }
            case 1 -> {
                ItemDialogBody $ = (ItemDialogBody)selector0$temp;
                yield ITEM_BODY_CODEC;
            }
        };
    };
    private static final Codec<DialogBody> DIALOG_BODY_CODEC = DIALOG_BODY_TYPES.byNameCodec().dispatch(GET_DIALOG_BODY_TYPE, Function.identity());
    private static final Codec<List<DialogBody>> DIALOG_BODY_LIST_CODEC = ExtraCodecs.compactListCodec(DIALOG_BODY_CODEC);
    private static final MapCodec<BooleanDialogInput> BOOLEAN_DIALOG_INPUT_TYPE_MAP_CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)ParsedTemplate.VARIABLE_CODEC.fieldOf("key").forGetter(DialogInput::key), (App)AdventureCodecs.COMPONENT_CODEC.fieldOf("label").forGetter(BooleanDialogInput::label), (App)Codec.BOOL.optionalFieldOf("initial", (Object)false).forGetter(BooleanDialogInput::initial), (App)Codec.STRING.optionalFieldOf("on_true", (Object)"true").forGetter(BooleanDialogInput::onTrue), (App)Codec.STRING.optionalFieldOf("on_false", (Object)"false").forGetter(BooleanDialogInput::onFalse)).apply((Applicative)instance, DialogInput::bool));
    private static final MapCodec<NumberRangeDialogInput> NUMBER_RANGE_INPUT_MAP_CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)ParsedTemplate.VARIABLE_CODEC.fieldOf("key").forGetter(DialogInput::key), (App)net.minecraft.server.dialog.Dialog.WIDTH_CODEC.optionalFieldOf("width", (Object)200).forGetter(NumberRangeDialogInput::width), (App)AdventureCodecs.COMPONENT_CODEC.fieldOf("label").forGetter(NumberRangeDialogInput::label), (App)Codec.STRING.optionalFieldOf("label_format", (Object)"options.generic_value").forGetter(NumberRangeDialogInput::labelFormat), (App)Codec.FLOAT.fieldOf("start").forGetter(NumberRangeDialogInput::start), (App)Codec.FLOAT.fieldOf("end").forGetter(NumberRangeDialogInput::end), (App)Codec.FLOAT.optionalFieldOf("initial").forGetter(type -> Optional.ofNullable(type.initial())), (App)ExtraCodecs.POSITIVE_FLOAT.optionalFieldOf("step").forGetter(type -> Optional.ofNullable(type.step()))).apply((Applicative)instance, (key, width, label, labelFormat, start, end, initial, step) -> DialogInput.numberRange((String)key, (int)width, (Component)label, (String)labelFormat, (float)start.floatValue(), (float)end.floatValue(), (Float)initial.orElse(null), (Float)step.orElse(null))));
    private static final Codec<SingleOptionDialogInput.OptionEntry> SINGLE_OPTION_DIALOG_INPUT_ENTRY_FULL_CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.STRING.fieldOf("id").forGetter(SingleOptionDialogInput.OptionEntry::id), (App)AdventureCodecs.COMPONENT_CODEC.optionalFieldOf("display").forGetter(entry -> Optional.ofNullable(entry.display())), (App)Codec.BOOL.optionalFieldOf("initial", (Object)false).forGetter(SingleOptionDialogInput.OptionEntry::initial)).apply((Applicative)instance, (id, display, initial) -> SingleOptionDialogInput.OptionEntry.create((String)id, (Component)display.orElse(null), (boolean)initial)));
    private static final Codec<SingleOptionDialogInput.OptionEntry> SINGLE_OPTION_DIALOG_INPUT_ENTRY_CODEC = Codec.withAlternative(SINGLE_OPTION_DIALOG_INPUT_ENTRY_FULL_CODEC, (Codec)Codec.STRING, string -> SingleOptionDialogInput.OptionEntry.create((String)string, null, (boolean)false));
    private static final MapCodec<SingleOptionDialogInput> SINGLE_OPTION_DIALOG_INPUT_TYPE_MAP_CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)ParsedTemplate.VARIABLE_CODEC.fieldOf("key").forGetter(DialogInput::key), (App)net.minecraft.server.dialog.Dialog.WIDTH_CODEC.optionalFieldOf("width", (Object)200).forGetter(SingleOptionDialogInput::width), (App)ExtraCodecs.nonEmptyList(SINGLE_OPTION_DIALOG_INPUT_ENTRY_CODEC.listOf()).fieldOf("options").forGetter(SingleOptionDialogInput::entries), (App)AdventureCodecs.COMPONENT_CODEC.fieldOf("label").forGetter(SingleOptionDialogInput::label), (App)Codec.BOOL.optionalFieldOf("label_visible", (Object)true).forGetter(SingleOptionDialogInput::labelVisible)).apply((Applicative)instance, DialogInput::singleOption));
    private static final Codec<TextDialogInput.MultilineOptions> TEXT_DIALOG_INPUT_MULTILINE_OPTIONS_CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ExtraCodecs.POSITIVE_INT.optionalFieldOf("max_lines").forGetter(options -> Optional.ofNullable(options.maxLines())), (App)ExtraCodecs.intRange(1, 512).optionalFieldOf("height").forGetter(options -> Optional.ofNullable(options.height()))).apply((Applicative)instance, (maxLines, height) -> TextDialogInput.MultilineOptions.create((Integer)maxLines.orElse(null), (Integer)height.orElse(null))));
    private static final MapCodec<TextDialogInput> TEXT_DIALOG_INPUT_TYPE_MAP_CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)ParsedTemplate.VARIABLE_CODEC.fieldOf("key").forGetter(DialogInput::key), (App)net.minecraft.server.dialog.Dialog.WIDTH_CODEC.optionalFieldOf("width", (Object)200).forGetter(TextDialogInput::width), (App)AdventureCodecs.COMPONENT_CODEC.fieldOf("label").forGetter(TextDialogInput::label), (App)Codec.BOOL.optionalFieldOf("label_visible", (Object)true).forGetter(TextDialogInput::labelVisible), (App)Codec.STRING.optionalFieldOf("initial", (Object)"").forGetter(TextDialogInput::initial), (App)ExtraCodecs.POSITIVE_INT.optionalFieldOf("max_length", (Object)32).forGetter(TextDialogInput::maxLength), (App)TEXT_DIALOG_INPUT_MULTILINE_OPTIONS_CODEC.optionalFieldOf("multiline").forGetter(inputType -> Optional.ofNullable(inputType.multiline()))).apply((Applicative)instance, (key, width, label, labelVisible, initial, maxLength, multilineOptions) -> DialogInput.text((String)key, (int)width, (Component)label, (boolean)labelVisible, (String)initial, (int)maxLength, (TextDialogInput.MultilineOptions)multilineOptions.orElse(null))));
    private static final Registry<MapCodec<? extends DialogInput>> DIALOG_INPUT_TYPES = Util.make(() -> {
        MappedRegistry registry = new MappedRegistry(ResourceKey.createRegistryKey(ResourceLocation.fromNamespaceAndPath("paper", "dialog_input_type")), Lifecycle.experimental());
        Registry.register(registry, "boolean", BOOLEAN_DIALOG_INPUT_TYPE_MAP_CODEC);
        Registry.register(registry, "number_range", NUMBER_RANGE_INPUT_MAP_CODEC);
        Registry.register(registry, "single_option", SINGLE_OPTION_DIALOG_INPUT_TYPE_MAP_CODEC);
        Registry.register(registry, "text", TEXT_DIALOG_INPUT_TYPE_MAP_CODEC);
        return registry.freeze();
    });
    private static final Function<DialogInput, MapCodec<? extends DialogInput>> GET_DIALOG_INPUT_TYPE_TYPE = dialogAction -> {
        DialogInput dialogInput = dialogAction;
        Objects.requireNonNull(dialogInput);
        DialogInput selector0$temp = dialogInput;
        int index$1 = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{TextDialogInput.class, SingleOptionDialogInput.class, NumberRangeDialogInput.class, BooleanDialogInput.class}, (Object)selector0$temp, index$1)) {
            default -> throw new MatchException(null, null);
            case 0 -> {
                TextDialogInput $ = (TextDialogInput)selector0$temp;
                yield TEXT_DIALOG_INPUT_TYPE_MAP_CODEC;
            }
            case 1 -> {
                SingleOptionDialogInput $ = (SingleOptionDialogInput)selector0$temp;
                yield SINGLE_OPTION_DIALOG_INPUT_TYPE_MAP_CODEC;
            }
            case 2 -> {
                NumberRangeDialogInput $ = (NumberRangeDialogInput)selector0$temp;
                yield NUMBER_RANGE_INPUT_MAP_CODEC;
            }
            case 3 -> {
                BooleanDialogInput $ = (BooleanDialogInput)selector0$temp;
                yield BOOLEAN_DIALOG_INPUT_TYPE_MAP_CODEC;
            }
        };
    };
    private static final Codec<DialogInput> DIALOG_INPUT_CODEC = DIALOG_INPUT_TYPES.byNameCodec().dispatchMap(GET_DIALOG_INPUT_TYPE_TYPE, Function.identity()).codec();
    public static final Codec<DialogBase> DIALOG_BASE_CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)AdventureCodecs.COMPONENT_CODEC.fieldOf("title").forGetter(DialogBase::title), (App)AdventureCodecs.COMPONENT_CODEC.optionalFieldOf("external_title").forGetter(base -> Optional.ofNullable(base.externalTitle())), (App)Codec.BOOL.optionalFieldOf("can_close_with_escape", (Object)true).forGetter(DialogBase::canCloseWithEscape), (App)Codec.BOOL.optionalFieldOf("pause", (Object)true).forGetter(DialogBase::pause), (App)AdventureCodecs.indexCodec(DialogBase.DialogAfterAction.NAMES).optionalFieldOf("after_action", (Object)DialogBase.DialogAfterAction.CLOSE).forGetter(DialogBase::afterAction), (App)DIALOG_BODY_LIST_CODEC.optionalFieldOf("body", List.of()).forGetter(DialogBase::body), (App)DIALOG_INPUT_CODEC.listOf().optionalFieldOf("inputs", List.of()).forGetter(DialogBase::inputs)).apply((Applicative)instance, (title, externalTitle, canCloseWithEsc, pause, afterAction, body, inputs) -> DialogBase.create((Component)title, (Component)externalTitle.orElse(null), (boolean)canCloseWithEsc, (boolean)pause, (DialogBase.DialogAfterAction)afterAction, (List)body, (List)inputs))).codec();
    public static final Codec<Dialog> DIALOG_CODEC = Codec.of((Encoder)net.minecraft.server.dialog.Dialog.CODEC.comap(PaperDialog::bukkitToMinecraftHolder), PaperCodecs.registryFileDecoderFor(net.minecraft.server.dialog.Dialog.DIRECT_CODEC, PaperDialog::minecraftHolderToBukkit, RegistryKey.DIALOG, true));

    private PaperDialogCodecs() {
    }
}

