/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.paper.threadedregions;

import ca.spottedleaf.moonrise.common.list.ReferenceList;
import ca.spottedleaf.moonrise.common.util.TickThread;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import net.minecraft.world.entity.Entity;
import org.bukkit.craftbukkit.entity.CraftEntity;

public final class EntityScheduler {
    public final CraftEntity entity;
    private long tickCount = 0L;
    private static final long RETIRED_TICK_COUNT = -1L;
    private final Object stateLock = new Object();
    private final Long2ObjectOpenHashMap<List<ScheduledTask>> oneTimeDelayed = new Long2ObjectOpenHashMap();
    private EntitySchedulerTickList scheduledList;
    private boolean insideScheduledList;
    private final ArrayDeque<ScheduledTask> currentlyExecuting = new ArrayDeque();

    public EntityScheduler(CraftEntity entity) {
        this.entity = Objects.requireNonNull(entity);
    }

    private boolean hasTasks() {
        return !this.currentlyExecuting.isEmpty() || !this.oneTimeDelayed.isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerTo(EntitySchedulerTickList newTickList) {
        Object object = this.stateLock;
        synchronized (object) {
            EntitySchedulerTickList prevList = this.scheduledList;
            if (prevList == newTickList) {
                return;
            }
            this.scheduledList = newTickList;
            if (prevList == null && this.hasTasks()) {
                this.insideScheduledList = true;
            }
            if (this.insideScheduledList) {
                if (prevList != null) {
                    prevList.remove(this);
                }
                if (newTickList != null) {
                    newTickList.add(this);
                } else {
                    this.insideScheduledList = false;
                }
            }
        }
    }

    public boolean isRetired() {
        return this.tickCount == -1L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void retire() {
        Object object = this.stateLock;
        synchronized (object) {
            if (this.tickCount == -1L) {
                throw new IllegalStateException("Already retired");
            }
            this.tickCount = -1L;
            this.registerTo(null);
        }
        Entity thisEntity = this.entity.getHandleRaw();
        int len = this.currentlyExecuting.size();
        for (int i = 0; i < len; ++i) {
            ScheduledTask task = this.currentlyExecuting.pollFirst();
            Consumer<? extends Entity> retireTask = task.retired;
            if (retireTask == null) continue;
            retireTask.accept(thisEntity);
        }
        for (List tasks : this.oneTimeDelayed.values()) {
            int len2 = tasks.size();
            for (int i = 0; i < len2; ++i) {
                ScheduledTask task = (ScheduledTask)tasks.get(i);
                Consumer<? extends Entity> retireTask = task.retired;
                if (retireTask == null) continue;
                retireTask.accept(thisEntity);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean schedule(Consumer<? extends Entity> run, Consumer<? extends Entity> retired, long delay) {
        Objects.requireNonNull(run, "Run task may not be null");
        ScheduledTask task = new ScheduledTask(run, retired);
        Object object = this.stateLock;
        synchronized (object) {
            if (this.tickCount == -1L) {
                return false;
            }
            ((List)this.oneTimeDelayed.computeIfAbsent(this.tickCount + Math.max(1L, delay), keyInMap -> new ArrayList())).add(task);
            if (!this.insideScheduledList && this.scheduledList != null) {
                this.scheduledList.add(this);
                this.insideScheduledList = true;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeTick() {
        int len;
        List toRun;
        Entity thisEntity = this.entity.getHandleRaw();
        TickThread.ensureTickThread(thisEntity, "May not tick entity scheduler asynchronously");
        Object object = this.stateLock;
        synchronized (object) {
            if (this.tickCount == -1L) {
                throw new IllegalStateException("Ticking retired scheduler");
            }
            ++this.tickCount;
            if (this.scheduledList != null && !this.hasTasks()) {
                this.scheduledList.remove(this);
                this.insideScheduledList = false;
            }
            toRun = this.oneTimeDelayed.isEmpty() ? null : (List)this.oneTimeDelayed.remove(this.tickCount);
        }
        if (toRun != null) {
            len = toRun.size();
            for (int i = 0; i < len; ++i) {
                this.currentlyExecuting.addLast((ScheduledTask)toRun.get(i));
            }
        }
        len = this.currentlyExecuting.size();
        for (int i = 0; i < len && TickThread.isTickThreadFor(thisEntity); ++i) {
            ScheduledTask task = this.currentlyExecuting.pollFirst();
            if (this.tickCount == -1L) break;
            task.run.accept(thisEntity);
        }
    }

    public static final class EntitySchedulerTickList {
        private static final EntityScheduler[] ENTITY_SCHEDULER_ARRAY = new EntityScheduler[0];
        private final ReferenceList<EntityScheduler> entitySchedulers = new ReferenceList<EntityScheduler>(ENTITY_SCHEDULER_ARRAY);

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean add(EntityScheduler scheduler) {
            EntitySchedulerTickList entitySchedulerTickList = this;
            synchronized (entitySchedulerTickList) {
                return this.entitySchedulers.add(scheduler);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void remove(EntityScheduler scheduler) {
            EntitySchedulerTickList entitySchedulerTickList = this;
            synchronized (entitySchedulerTickList) {
                this.entitySchedulers.remove(scheduler);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public EntityScheduler[] getAllSchedulers() {
            EntityScheduler[] ret = new EntityScheduler[this.entitySchedulers.size()];
            EntitySchedulerTickList entitySchedulerTickList = this;
            synchronized (entitySchedulerTickList) {
                if (ret.length != this.entitySchedulers.size()) {
                    ret = new EntityScheduler[this.entitySchedulers.size()];
                }
                System.arraycopy(this.entitySchedulers.getRawDataUnchecked(), 0, ret, 0, this.entitySchedulers.size());
                return ret;
            }
        }
    }

    private record ScheduledTask(Consumer<? extends Entity> run, Consumer<? extends Entity> retired) {
    }
}

