/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.paper.util;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.JsonOps;
import io.papermc.paper.registry.RegistryAccess;
import io.papermc.paper.registry.RegistryKey;
import io.papermc.paper.util.JsonObjectWrapper;
import io.papermc.paper.util.MCUtil;
import java.lang.runtime.SwitchBootstraps;
import java.util.Objects;
import net.kyori.adventure.key.Key;
import net.minecraft.core.Holder;
import net.minecraft.resources.RegistryOps;
import org.bukkit.Keyed;
import org.bukkit.NamespacedKey;
import org.bukkit.Registry;
import org.bukkit.craftbukkit.CraftRegistry;
import org.bukkit.craftbukkit.util.Handleable;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

@NullMarked
public interface Holderable<M>
extends Handleable<M> {
    public Holder<M> getHolder();

    @Override
    default public M getHandle() {
        return this.getHolder().value();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static <T extends Keyed, M> @Nullable T fromBukkitSerializationObject(Object deserialized, Codec<M> directCodec, RegistryKey<T> registryKey) {
        Registry registry = RegistryAccess.registryAccess().getRegistry(registryKey);
        Object object = deserialized;
        Objects.requireNonNull(object);
        Object object2 = object;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{String.class, JsonObjectWrapper.class}, (Object)object2, n)) {
            case 0: {
                Keyed keyed;
                String string = (String)object2;
                if (!Key.parseable((String)string)) {
                    keyed = null;
                    return (T)keyed;
                }
                keyed = registry.get(Key.key((String)string));
                return (T)keyed;
            }
            case 1: {
                JsonObject element;
                JsonObjectWrapper jsonObjectWrapper = (JsonObjectWrapper)object2;
                try {
                    JsonObject jsonObject;
                    element = jsonObject = jsonObjectWrapper.element();
                }
                catch (Throwable throwable) {
                    throw new MatchException(throwable.toString(), throwable);
                }
                if (!(registry instanceof CraftRegistry)) throw new IllegalArgumentException("Cannot deserialize direct holders for " + String.valueOf(registry));
                CraftRegistry craftRegistry = (CraftRegistry)registry;
                if (!craftRegistry.supportsDirectHolders()) {
                    throw new IllegalArgumentException("Cannot deserialize direct holders for " + String.valueOf(registry));
                }
                RegistryOps ops = CraftRegistry.getMinecraftRegistry().createSerializationContext(JsonOps.INSTANCE);
                Object holder = ((Pair)directCodec.decode(ops, (Object)element).getOrThrow()).getFirst();
                Keyed keyed = (Keyed)((CraftRegistry)registry).createBukkit(Holder.direct(holder));
                return (T)keyed;
            }
        }
        throw new IllegalArgumentException("Cannot deserialize " + String.valueOf(deserialized));
    }

    default public Object toBukkitSerializationObject(Codec<? super M> directCodec) {
        Holder<M> holder = this.getHolder();
        Objects.requireNonNull(holder);
        Holder<M> holder2 = holder;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Holder.Direct.class, Holder.Reference.class}, holder2, n)) {
            case 0 -> {
                Holder.Direct direct = (Holder.Direct)holder2;
                RegistryOps ops = CraftRegistry.getMinecraftRegistry().createSerializationContext(JsonOps.INSTANCE);
                yield new JsonObjectWrapper(((JsonElement)directCodec.encodeStart(ops, direct.value()).getOrThrow()).getAsJsonObject());
            }
            case 1 -> {
                Holder.Reference reference = (Holder.Reference)holder2;
                yield reference.key().location().toString();
            }
            default -> throw new IllegalArgumentException("Cannot serialize " + String.valueOf(this.getHolder()));
        };
    }

    default public int implHashCode() {
        return this.getHolder().hashCode();
    }

    default public boolean implEquals(@Nullable Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Holderable that = (Holderable)o;
        return this.getHolder().equals(that.getHolder());
    }

    default public String implToString() {
        return "%s{holder=%s}".formatted(this.getClass().getSimpleName(), this.getHolder().toString());
    }

    default public @Nullable NamespacedKey getKeyOrNull() {
        return this.getHolder().unwrapKey().map(MCUtil::fromResourceKey).orElse(null);
    }

    default public NamespacedKey getKey() {
        return MCUtil.fromResourceKey(this.getHolder().unwrapKey().orElseThrow(() -> new IllegalStateException("Cannot get key for this registry item, because it is not registered.")));
    }
}

