/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.advancements.critereon;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.advancements.critereon.MinMaxBounds;

public interface CollectionCountsPredicate<T, P extends Predicate<T>>
extends Predicate<Iterable<T>> {
    public List<Entry<T, P>> unpack();

    public static <T, P extends Predicate<T>> Codec<CollectionCountsPredicate<T, P>> codec(Codec<P> testCodec) {
        return Entry.codec(testCodec).listOf().xmap(CollectionCountsPredicate::of, CollectionCountsPredicate::unpack);
    }

    @SafeVarargs
    public static <T, P extends Predicate<T>> CollectionCountsPredicate<T, P> of(Entry<T, P> ... entries) {
        return CollectionCountsPredicate.of(List.of(entries));
    }

    public static <T, P extends Predicate<T>> CollectionCountsPredicate<T, P> of(List<Entry<T, P>> entries) {
        return switch (entries.size()) {
            case 0 -> new Zero();
            case 1 -> new Single<T, P>(entries.getFirst());
            default -> new Multiple<T, P>(entries);
        };
    }

    public record Entry<T, P extends Predicate<T>>(P test, MinMaxBounds.Ints count) {
        public static <T, P extends Predicate<T>> Codec<Entry<T, P>> codec(Codec<P> testCodec) {
            return RecordCodecBuilder.create(instance -> instance.group((App)testCodec.fieldOf("test").forGetter(Entry::test), (App)MinMaxBounds.Ints.CODEC.fieldOf("count").forGetter(Entry::count)).apply((Applicative)instance, Entry::new));
        }

        public boolean test(Iterable<T> collection) {
            int i = 0;
            for (T object : collection) {
                if (!this.test.test(object)) continue;
                ++i;
            }
            return this.count.matches(i);
        }
    }

    public static class Zero<T, P extends Predicate<T>>
    implements CollectionCountsPredicate<T, P> {
        @Override
        public boolean test(Iterable<T> collection) {
            return true;
        }

        @Override
        public List<Entry<T, P>> unpack() {
            return List.of();
        }
    }

    public record Single<T, P extends Predicate<T>>(Entry<T, P> entry) implements CollectionCountsPredicate<T, P>
    {
        @Override
        public boolean test(Iterable<T> collection) {
            return this.entry.test(collection);
        }

        @Override
        public List<Entry<T, P>> unpack() {
            return List.of(this.entry);
        }
    }

    public record Multiple<T, P extends Predicate<T>>(List<Entry<T, P>> entries) implements CollectionCountsPredicate<T, P>
    {
        @Override
        public boolean test(Iterable<T> collection) {
            for (Entry<T, P> entry : this.entries) {
                if (entry.test(collection)) continue;
                return false;
            }
            return true;
        }

        @Override
        public List<Entry<T, P>> unpack() {
            return this.entries;
        }
    }
}

