/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.advancements.critereon;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import net.minecraft.advancements.CriterionTrigger;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.critereon.ContextAwarePredicate;
import net.minecraft.advancements.critereon.CriterionValidator;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.server.PlayerAdvancements;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.storage.loot.LootContext;

public abstract class SimpleCriterionTrigger<T extends SimpleInstance>
implements CriterionTrigger<T> {
    @Override
    public final void addPlayerListener(PlayerAdvancements playerAdvancements, CriterionTrigger.Listener<T> listener) {
        playerAdvancements.criterionData.computeIfAbsent(this, managerx -> Sets.newHashSet()).add(listener);
    }

    @Override
    public final void removePlayerListener(PlayerAdvancements playerAdvancements, CriterionTrigger.Listener<T> listener) {
        Set<CriterionTrigger.Listener<?>> set = playerAdvancements.criterionData.get(this);
        if (set != null) {
            set.remove(listener);
            if (set.isEmpty()) {
                playerAdvancements.criterionData.remove(this);
            }
        }
    }

    @Override
    public final void removePlayerListeners(PlayerAdvancements playerAdvancements) {
        playerAdvancements.criterionData.remove(this);
    }

    protected void trigger(ServerPlayer player, Predicate<T> testTrigger) {
        PlayerAdvancements advancements = player.getAdvancements();
        Set<CriterionTrigger.Listener<?>> set = advancements.criterionData.get(this);
        if (set != null && !set.isEmpty()) {
            LootContext lootContext = null;
            List list = null;
            for (CriterionTrigger.Listener<?> listener : set) {
                Optional<ContextAwarePredicate> optional;
                SimpleInstance simpleInstance = (SimpleInstance)listener.trigger();
                if (!testTrigger.test(simpleInstance) || !(optional = simpleInstance.player()).isEmpty() && !optional.get().matches(lootContext = lootContext == null ? EntityPredicate.createContext(player, player) : lootContext)) continue;
                if (list == null) {
                    list = Lists.newArrayList();
                }
                list.add(listener);
            }
            if (list != null) {
                for (CriterionTrigger.Listener<Object> listenerx : list) {
                    listenerx.run(advancements);
                }
            }
        }
    }

    public static interface SimpleInstance
    extends CriterionTriggerInstance {
        @Override
        default public void validate(CriterionValidator validator) {
            validator.validateEntity(this.player(), "player");
        }

        public Optional<ContextAwarePredicate> player();
    }
}

