/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.commands.arguments;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.MessageSignature;
import net.minecraft.network.chat.SignableCommand;

public record ArgumentSignatures(List<Entry> entries) {
    public static final ArgumentSignatures EMPTY = new ArgumentSignatures(List.of());
    private static final int MAX_ARGUMENT_COUNT = 8;
    private static final int MAX_ARGUMENT_NAME_LENGTH = 16;

    public ArgumentSignatures(FriendlyByteBuf buffer) {
        this(buffer.readCollection(FriendlyByteBuf.limitValue(ArrayList::new, 8), Entry::new));
    }

    public void write(FriendlyByteBuf buffer) {
        buffer.writeCollection(this.entries, (buffer1, entry) -> entry.write((FriendlyByteBuf)((Object)buffer1)));
    }

    public static ArgumentSignatures signCommand(SignableCommand<?> command, Signer signer) {
        List<Entry> list = command.arguments().stream().map(signedArgument -> {
            MessageSignature messageSignature = signer.sign(signedArgument.value());
            return messageSignature != null ? new Entry(signedArgument.name(), messageSignature) : null;
        }).filter(Objects::nonNull).toList();
        return new ArgumentSignatures(list);
    }

    @FunctionalInterface
    public static interface Signer {
        @Nullable
        public MessageSignature sign(String var1);
    }

    public record Entry(String name, MessageSignature signature) {
        public Entry(FriendlyByteBuf buffer) {
            this(buffer.readUtf(16), MessageSignature.read(buffer));
        }

        public void write(FriendlyByteBuf buffer) {
            buffer.writeUtf(this.name, 16);
            MessageSignature.write(buffer, this.signature);
        }
    }
}

