/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.nbt;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.collect.Comparators;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.Dynamic;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.SharedConstants;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.ByteArrayTag;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.EndTag;
import net.minecraft.nbt.IntArrayTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.LongArrayTag;
import net.minecraft.nbt.PrimitiveTag;
import net.minecraft.nbt.SnbtPrinterTagVisitor;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.nbt.TagParser;
import net.minecraft.nbt.TextComponentTagVisitor;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.StateHolder;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.storage.ValueOutput;
import org.slf4j.Logger;

public final class NbtUtils {
    private static final Comparator<ListTag> YXZ_LISTTAG_INT_COMPARATOR = Comparator.comparingInt(listTag -> listTag.getIntOr(1, 0)).thenComparingInt(listTag -> listTag.getIntOr(0, 0)).thenComparingInt(listTag -> listTag.getIntOr(2, 0));
    private static final Comparator<ListTag> YXZ_LISTTAG_DOUBLE_COMPARATOR = Comparator.comparingDouble(listTag -> listTag.getDoubleOr(1, 0.0)).thenComparingDouble(listTag -> listTag.getDoubleOr(0, 0.0)).thenComparingDouble(listTag -> listTag.getDoubleOr(2, 0.0));
    private static final Codec<ResourceKey<Block>> BLOCK_NAME_CODEC = ResourceKey.codec(Registries.BLOCK);
    public static final String SNBT_DATA_TAG = "data";
    private static final char PROPERTIES_START = '{';
    private static final char PROPERTIES_END = '}';
    private static final String ELEMENT_SEPARATOR = ",";
    private static final char KEY_VALUE_SEPARATOR = ':';
    private static final Splitter COMMA_SPLITTER = Splitter.on((String)",");
    private static final Splitter COLON_SPLITTER = Splitter.on((char)':').limit(2);
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final int INDENT = 2;
    private static final int NOT_FOUND = -1;

    private NbtUtils() {
    }

    @VisibleForTesting
    public static boolean compareNbt(@Nullable Tag tag, @Nullable Tag other, boolean compareListTag) {
        if (tag == other) {
            return true;
        }
        if (tag == null) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (!tag.getClass().equals(other.getClass())) {
            return false;
        }
        if (tag instanceof CompoundTag) {
            CompoundTag compoundTag = (CompoundTag)tag;
            CompoundTag compoundTag1 = (CompoundTag)other;
            if (compoundTag1.size() < compoundTag.size()) {
                return false;
            }
            for (Map.Entry<String, Tag> entry : compoundTag.entrySet()) {
                Tag tag1 = entry.getValue();
                if (NbtUtils.compareNbt(tag1, compoundTag1.get(entry.getKey()), compareListTag)) continue;
                return false;
            }
            return true;
        }
        if (tag instanceof ListTag) {
            ListTag listTag = (ListTag)tag;
            if (compareListTag) {
                ListTag listTag1 = (ListTag)other;
                if (listTag.isEmpty()) {
                    return listTag1.isEmpty();
                }
                if (listTag1.size() < listTag.size()) {
                    return false;
                }
                for (Tag tag2 : listTag) {
                    boolean flag = false;
                    for (Tag tag3 : listTag1) {
                        if (!NbtUtils.compareNbt(tag2, tag3, compareListTag)) continue;
                        flag = true;
                        break;
                    }
                    if (flag) continue;
                    return false;
                }
                return true;
            }
        }
        return tag.equals(other);
    }

    public static BlockState readBlockState(HolderGetter<Block> blockGetter, CompoundTag tag) {
        Optional optional = tag.read("Name", BLOCK_NAME_CODEC).flatMap(blockGetter::get);
        if (optional.isEmpty()) {
            return Blocks.AIR.defaultBlockState();
        }
        Block block = (Block)((Holder)optional.get()).value();
        BlockState blockState = block.defaultBlockState();
        Optional<CompoundTag> compound = tag.getCompound("Properties");
        if (compound.isPresent()) {
            StateDefinition<Block, BlockState> stateDefinition = block.getStateDefinition();
            for (String string : compound.get().keySet()) {
                Property<?> property = stateDefinition.getProperty(string);
                if (property == null) continue;
                blockState = NbtUtils.setValueHelper(blockState, property, string, compound.get(), tag);
            }
        }
        return blockState;
    }

    private static <S extends StateHolder<?, S>, T extends Comparable<T>> S setValueHelper(S stateHolder, Property<T> property, String propertyName, CompoundTag propertiesTag, CompoundTag blockStateTag) {
        Optional optional = propertiesTag.getString(propertyName).flatMap(property::getValue);
        if (optional.isPresent()) {
            return (S)((StateHolder)stateHolder.setValue(property, (Comparable)((Comparable)optional.get())));
        }
        LOGGER.warn("Unable to read property: {} with value: {} for blockstate: {}", new Object[]{propertyName, propertiesTag.get(propertyName), blockStateTag});
        return stateHolder;
    }

    public static CompoundTag writeBlockState(BlockState state) {
        CompoundTag compoundTag = new CompoundTag();
        compoundTag.putString("Name", BuiltInRegistries.BLOCK.getKey(state.getBlock()).toString());
        Map<Property<?>, Comparable<?>> values = state.getValues();
        if (!values.isEmpty()) {
            CompoundTag compoundTag1 = new CompoundTag();
            for (Map.Entry<Property<?>, Comparable<?>> entry : values.entrySet()) {
                Property<?> property = entry.getKey();
                compoundTag1.putString(property.getName(), NbtUtils.getName(property, entry.getValue()));
            }
            compoundTag.put("Properties", compoundTag1);
        }
        return compoundTag;
    }

    public static CompoundTag writeFluidState(FluidState state) {
        CompoundTag compoundTag = new CompoundTag();
        compoundTag.putString("Name", BuiltInRegistries.FLUID.getKey(state.getType()).toString());
        Map<Property<?>, Comparable<?>> values = state.getValues();
        if (!values.isEmpty()) {
            CompoundTag compoundTag1 = new CompoundTag();
            for (Map.Entry<Property<?>, Comparable<?>> entry : values.entrySet()) {
                Property<?> property = entry.getKey();
                compoundTag1.putString(property.getName(), NbtUtils.getName(property, entry.getValue()));
            }
            compoundTag.put("Properties", compoundTag1);
        }
        return compoundTag;
    }

    private static <T extends Comparable<T>> String getName(Property<T> property, Comparable<?> value) {
        return property.getName(value);
    }

    public static String prettyPrint(Tag tag) {
        return NbtUtils.prettyPrint(tag, false);
    }

    public static String prettyPrint(Tag tag, boolean prettyPrintArray) {
        return NbtUtils.prettyPrint(new StringBuilder(), tag, 0, prettyPrintArray).toString();
    }

    public static StringBuilder prettyPrint(StringBuilder stringBuilder, Tag tag, int indentLevel, boolean prettyPrintArray) {
        Tag tag2 = tag;
        Objects.requireNonNull(tag2);
        Tag tag3 = tag2;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{PrimitiveTag.class, EndTag.class, ByteArrayTag.class, ListTag.class, IntArrayTag.class, CompoundTag.class, LongArrayTag.class}, (Object)tag3, n)) {
            case 0 -> {
                PrimitiveTag primitiveTag = (PrimitiveTag)tag3;
                yield stringBuilder.append(primitiveTag);
            }
            case 1 -> {
                EndTag endTag = (EndTag)tag3;
                yield stringBuilder;
            }
            case 2 -> {
                ByteArrayTag byteArrayTag = (ByteArrayTag)tag3;
                byte[] asByteArray = byteArrayTag.getAsByteArray();
                int i = asByteArray.length;
                NbtUtils.indent(indentLevel, stringBuilder).append("byte[").append(i).append("] {\n");
                if (prettyPrintArray) {
                    NbtUtils.indent(indentLevel + 1, stringBuilder);
                    for (int i1 = 0; i1 < asByteArray.length; ++i1) {
                        if (i1 != 0) {
                            stringBuilder.append(',');
                        }
                        if (i1 % 16 == 0 && i1 / 16 > 0) {
                            stringBuilder.append('\n');
                            if (i1 < asByteArray.length) {
                                NbtUtils.indent(indentLevel + 1, stringBuilder);
                            }
                        } else if (i1 != 0) {
                            stringBuilder.append(' ');
                        }
                        stringBuilder.append(String.format(Locale.ROOT, "0x%02X", asByteArray[i1] & 0xFF));
                    }
                } else {
                    NbtUtils.indent(indentLevel + 1, stringBuilder).append(" // Skipped, supply withBinaryBlobs true");
                }
                stringBuilder.append('\n');
                NbtUtils.indent(indentLevel, stringBuilder).append('}');
                yield stringBuilder;
            }
            case 3 -> {
                ListTag listTag = (ListTag)tag3;
                int i = listTag.size();
                NbtUtils.indent(indentLevel, stringBuilder).append("list").append("[").append(i).append("] [");
                if (i != 0) {
                    stringBuilder.append('\n');
                }
                for (int i1 = 0; i1 < i; ++i1) {
                    if (i1 != 0) {
                        stringBuilder.append(",\n");
                    }
                    NbtUtils.indent(indentLevel + 1, stringBuilder);
                    NbtUtils.prettyPrint(stringBuilder, listTag.get(i1), indentLevel + 1, prettyPrintArray);
                }
                if (i != 0) {
                    stringBuilder.append('\n');
                }
                NbtUtils.indent(indentLevel, stringBuilder).append(']');
                yield stringBuilder;
            }
            case 4 -> {
                IntArrayTag intArrayTag = (IntArrayTag)tag3;
                int[] asIntArray = intArrayTag.getAsIntArray();
                int i2 = 0;
                for (int i3 : asIntArray) {
                    i2 = Math.max(i2, String.format(Locale.ROOT, "%X", i3).length());
                }
                int i4 = asIntArray.length;
                NbtUtils.indent(indentLevel, stringBuilder).append("int[").append(i4).append("] {\n");
                if (prettyPrintArray) {
                    NbtUtils.indent(indentLevel + 1, stringBuilder);
                    for (int i5 = 0; i5 < asIntArray.length; ++i5) {
                        if (i5 != 0) {
                            stringBuilder.append(',');
                        }
                        if (i5 % 16 == 0 && i5 / 16 > 0) {
                            stringBuilder.append('\n');
                            if (i5 < asIntArray.length) {
                                NbtUtils.indent(indentLevel + 1, stringBuilder);
                            }
                        } else if (i5 != 0) {
                            stringBuilder.append(' ');
                        }
                        stringBuilder.append(String.format(Locale.ROOT, "0x%0" + i2 + "X", asIntArray[i5]));
                    }
                } else {
                    NbtUtils.indent(indentLevel + 1, stringBuilder).append(" // Skipped, supply withBinaryBlobs true");
                }
                stringBuilder.append('\n');
                NbtUtils.indent(indentLevel, stringBuilder).append('}');
                yield stringBuilder;
            }
            case 5 -> {
                CompoundTag compoundTag = (CompoundTag)tag3;
                ArrayList list = Lists.newArrayList(compoundTag.keySet());
                Collections.sort(list);
                NbtUtils.indent(indentLevel, stringBuilder).append('{');
                if (stringBuilder.length() - stringBuilder.lastIndexOf("\n") > 2 * (indentLevel + 1)) {
                    stringBuilder.append('\n');
                    NbtUtils.indent(indentLevel + 1, stringBuilder);
                }
                int i4 = list.stream().mapToInt(String::length).max().orElse(0);
                String repeated = Strings.repeat((String)" ", (int)i4);
                for (int i6 = 0; i6 < list.size(); ++i6) {
                    if (i6 != 0) {
                        stringBuilder.append(",\n");
                    }
                    String string = (String)list.get(i6);
                    NbtUtils.indent(indentLevel + 1, stringBuilder).append('\"').append(string).append('\"').append(repeated, 0, repeated.length() - string.length()).append(": ");
                    NbtUtils.prettyPrint(stringBuilder, compoundTag.get(string), indentLevel + 1, prettyPrintArray);
                }
                if (!list.isEmpty()) {
                    stringBuilder.append('\n');
                }
                NbtUtils.indent(indentLevel, stringBuilder).append('}');
                yield stringBuilder;
            }
            case 6 -> {
                LongArrayTag longArrayTag = (LongArrayTag)tag3;
                long[] asLongArray = longArrayTag.getAsLongArray();
                long l = 0L;
                for (long l1 : asLongArray) {
                    l = Math.max(l, (long)String.format(Locale.ROOT, "%X", l1).length());
                }
                long l2 = asLongArray.length;
                NbtUtils.indent(indentLevel, stringBuilder).append("long[").append(l2).append("] {\n");
                if (prettyPrintArray) {
                    NbtUtils.indent(indentLevel + 1, stringBuilder);
                    for (int i7 = 0; i7 < asLongArray.length; ++i7) {
                        if (i7 != 0) {
                            stringBuilder.append(',');
                        }
                        if (i7 % 16 == 0 && i7 / 16 > 0) {
                            stringBuilder.append('\n');
                            if (i7 < asLongArray.length) {
                                NbtUtils.indent(indentLevel + 1, stringBuilder);
                            }
                        } else if (i7 != 0) {
                            stringBuilder.append(' ');
                        }
                        stringBuilder.append(String.format(Locale.ROOT, "0x%0" + l + "X", asLongArray[i7]));
                    }
                } else {
                    NbtUtils.indent(indentLevel + 1, stringBuilder).append(" // Skipped, supply withBinaryBlobs true");
                }
                stringBuilder.append('\n');
                NbtUtils.indent(indentLevel, stringBuilder).append('}');
                yield stringBuilder;
            }
            default -> throw new MatchException(null, null);
        };
    }

    private static StringBuilder indent(int indentLevel, StringBuilder stringBuilder) {
        int i = stringBuilder.lastIndexOf("\n") + 1;
        int i1 = stringBuilder.length() - i;
        for (int i2 = 0; i2 < 2 * indentLevel - i1; ++i2) {
            stringBuilder.append(' ');
        }
        return stringBuilder;
    }

    public static Component toPrettyComponent(Tag tag) {
        return new TextComponentTagVisitor("").visit(tag);
    }

    public static String structureToSnbt(CompoundTag tag) {
        return new SnbtPrinterTagVisitor().visit(NbtUtils.packStructureTemplate(tag));
    }

    public static CompoundTag snbtToStructure(String text) throws CommandSyntaxException {
        return NbtUtils.unpackStructureTemplate(TagParser.parseCompoundFully(text));
    }

    @VisibleForTesting
    static CompoundTag packStructureTemplate(CompoundTag tag) {
        ListTag listTag2;
        Optional<ListTag> list1;
        Optional<ListTag> list = tag.getList("palettes");
        ListTag listOrEmpty = list.isPresent() ? list.get().getListOrEmpty(0) : tag.getListOrEmpty("palette");
        ListTag listTag = listOrEmpty.compoundStream().map(NbtUtils::packBlockState).map(StringTag::valueOf).collect(Collectors.toCollection(ListTag::new));
        tag.put("palette", listTag);
        if (list.isPresent()) {
            ListTag listTag1 = new ListTag();
            list.get().stream().flatMap(tag1 -> tag1.asList().stream()).forEach(listTag3 -> {
                CompoundTag compoundTag = new CompoundTag();
                for (int i = 0; i < listTag3.size(); ++i) {
                    compoundTag.putString(listTag.getString(i).orElseThrow(), NbtUtils.packBlockState(listTag3.getCompound(i).orElseThrow()));
                }
                listTag1.add(compoundTag);
            });
            tag.put("palettes", listTag1);
        }
        if ((list1 = tag.getList("entities")).isPresent()) {
            listTag2 = list1.get().compoundStream().sorted(Comparator.comparing(compoundTag -> compoundTag.getList("pos"), Comparators.emptiesLast(YXZ_LISTTAG_DOUBLE_COMPARATOR))).collect(Collectors.toCollection(ListTag::new));
            tag.put("entities", listTag2);
        }
        listTag2 = tag.getList("blocks").stream().flatMap(ListTag::compoundStream).sorted(Comparator.comparing(compoundTag -> compoundTag.getList("pos"), Comparators.emptiesLast(YXZ_LISTTAG_INT_COMPARATOR))).peek(compoundTag -> compoundTag.putString("state", listTag.getString(compoundTag.getIntOr("state", 0)).orElseThrow())).collect(Collectors.toCollection(ListTag::new));
        tag.put(SNBT_DATA_TAG, listTag2);
        tag.remove("blocks");
        return tag;
    }

    @VisibleForTesting
    static CompoundTag unpackStructureTemplate(CompoundTag tag) {
        ListTag listOrEmpty = tag.getListOrEmpty("palette");
        Map map = (Map)listOrEmpty.stream().flatMap(tag1 -> tag1.asString().stream()).collect(ImmutableMap.toImmutableMap(Function.identity(), NbtUtils::unpackBlockState));
        Optional<ListTag> list = tag.getList("palettes");
        if (list.isPresent()) {
            tag.put("palettes", list.get().compoundStream().map(compoundTag1 -> map.keySet().stream().map(string1 -> compoundTag1.getString((String)string1).orElseThrow()).map(NbtUtils::unpackBlockState).collect(Collectors.toCollection(ListTag::new))).collect(Collectors.toCollection(ListTag::new)));
            tag.remove("palette");
        } else {
            tag.put("palette", map.values().stream().collect(Collectors.toCollection(ListTag::new)));
        }
        Optional<ListTag> list1 = tag.getList(SNBT_DATA_TAG);
        if (list1.isPresent()) {
            Object2IntOpenHashMap map1 = new Object2IntOpenHashMap();
            map1.defaultReturnValue(-1);
            for (int i = 0; i < listOrEmpty.size(); ++i) {
                map1.put((Object)listOrEmpty.getString(i).orElseThrow(), i);
            }
            ListTag listTag = list1.get();
            for (int i1 = 0; i1 < listTag.size(); ++i1) {
                CompoundTag compoundTag = listTag.getCompound(i1).orElseThrow();
                String string = compoundTag.getString("state").orElseThrow();
                int _int = map1.getInt((Object)string);
                if (_int == -1) {
                    throw new IllegalStateException("Entry " + string + " missing from palette");
                }
                compoundTag.putInt("state", _int);
            }
            tag.put("blocks", listTag);
            tag.remove(SNBT_DATA_TAG);
        }
        return tag;
    }

    @VisibleForTesting
    static String packBlockState(CompoundTag tag) {
        StringBuilder stringBuilder = new StringBuilder(tag.getString("Name").orElseThrow());
        tag.getCompound("Properties").ifPresent(compoundTag -> {
            String string = compoundTag.entrySet().stream().sorted(Map.Entry.comparingByKey()).map(entry -> (String)entry.getKey() + ":" + ((Tag)entry.getValue()).asString().orElseThrow()).collect(Collectors.joining(ELEMENT_SEPARATOR));
            stringBuilder.append('{').append(string).append('}');
        });
        return stringBuilder.toString();
    }

    @VisibleForTesting
    static CompoundTag unpackBlockState(String blockStateText) {
        String sub;
        CompoundTag compoundTag = new CompoundTag();
        int index = blockStateText.indexOf(123);
        if (index >= 0) {
            sub = blockStateText.substring(0, index);
            CompoundTag compoundTag1 = new CompoundTag();
            if (index + 2 <= blockStateText.length()) {
                String sub1 = blockStateText.substring(index + 1, blockStateText.indexOf(125, index));
                COMMA_SPLITTER.split((CharSequence)sub1).forEach(string -> {
                    List parts = COLON_SPLITTER.splitToList((CharSequence)string);
                    if (parts.size() == 2) {
                        compoundTag1.putString((String)parts.get(0), (String)parts.get(1));
                    } else {
                        LOGGER.error("Something went wrong parsing: '{}' -- incorrect gamedata!", (Object)blockStateText);
                    }
                });
                compoundTag.put("Properties", compoundTag1);
            }
        } else {
            sub = blockStateText;
        }
        compoundTag.putString("Name", sub);
        return compoundTag;
    }

    public static CompoundTag addCurrentDataVersion(CompoundTag tag) {
        int version = SharedConstants.getCurrentVersion().dataVersion().version();
        return NbtUtils.addDataVersion(tag, version);
    }

    public static CompoundTag addDataVersion(CompoundTag tag, int dataVersion) {
        tag.putInt("DataVersion", dataVersion);
        return tag;
    }

    public static Dynamic<Tag> addCurrentDataVersion(Dynamic<Tag> dynamic) {
        int version = SharedConstants.getCurrentVersion().dataVersion().version();
        return NbtUtils.addDataVersion(dynamic, version);
    }

    public static Dynamic<Tag> addDataVersion(Dynamic<Tag> dynamic, int dataVersion) {
        return dynamic.set("DataVersion", dynamic.createInt(dataVersion));
    }

    public static void addCurrentDataVersion(ValueOutput output) {
        int version = SharedConstants.getCurrentVersion().dataVersion().version();
        NbtUtils.addDataVersion(output, version);
    }

    public static void addDataVersion(ValueOutput output, int dataVersion) {
        output.putInt("DataVersion", dataVersion);
    }

    public static int getDataVersion(CompoundTag tag, int defaultValue) {
        return tag.getIntOr("DataVersion", defaultValue);
    }

    public static int getDataVersion(Dynamic<?> tag, int defaultValue) {
        return tag.get("DataVersion").asInt(defaultValue);
    }
}

