/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network;

import com.velocitypowered.natives.Native;
import com.velocitypowered.natives.compression.VelocityCompressor;
import com.velocitypowered.natives.util.MoreByteBufUtils;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.MessageToByteEncoder;
import java.util.zip.Deflater;
import javax.annotation.Nullable;
import net.minecraft.network.VarInt;

public class CompressionEncoder
extends MessageToByteEncoder<ByteBuf> {
    @Nullable
    private final byte[] encodeBuf;
    @Nullable
    private final Deflater deflater;
    @Nullable
    private final VelocityCompressor compressor;
    private int threshold;

    public CompressionEncoder(int threshold) {
        this(null, threshold);
    }

    public CompressionEncoder(@Nullable VelocityCompressor compressor, int threshold) {
        this.threshold = threshold;
        if (compressor == null) {
            this.encodeBuf = new byte[8192];
            this.deflater = new Deflater();
        } else {
            this.encodeBuf = null;
            this.deflater = null;
        }
        this.compressor = compressor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void encode(ChannelHandlerContext ctx, ByteBuf encodingByteBuf, ByteBuf byteBuf) throws Exception {
        int i = encodingByteBuf.readableBytes();
        if (i > 0x800000) {
            throw new IllegalArgumentException("Packet too big (is " + i + ", should be less than 8388608)");
        }
        if (i < this.threshold) {
            VarInt.write(byteBuf, 0);
            byteBuf.writeBytes(encodingByteBuf);
        } else {
            if (this.deflater != null) {
                byte[] bytes = new byte[i];
                encodingByteBuf.readBytes(bytes);
                VarInt.write(byteBuf, bytes.length);
                this.deflater.setInput(bytes, 0, i);
                this.deflater.finish();
                while (!this.deflater.finished()) {
                    int i1 = this.deflater.deflate(this.encodeBuf);
                    byteBuf.writeBytes(this.encodeBuf, 0, i1);
                }
                this.deflater.reset();
                return;
            }
            VarInt.write(byteBuf, i);
            ByteBuf compatibleIn = MoreByteBufUtils.ensureCompatible((ByteBufAllocator)ctx.alloc(), (Native)this.compressor, (ByteBuf)encodingByteBuf);
            try {
                this.compressor.deflate(compatibleIn, byteBuf);
            }
            finally {
                compatibleIn.release();
            }
        }
    }

    public int getThreshold() {
        return this.threshold;
    }

    public void setThreshold(int threshold) {
        this.threshold = threshold;
    }

    protected ByteBuf allocateBuffer(ChannelHandlerContext ctx, ByteBuf msg, boolean preferDirect) throws Exception {
        if (this.compressor != null) {
            int initialBufferSize = msg.readableBytes() + 1;
            return MoreByteBufUtils.preferredBuffer((ByteBufAllocator)ctx.alloc(), (Native)this.compressor, (int)initialBufferSize);
        }
        return super.allocateBuffer(ctx, (Object)msg, preferDirect);
    }

    public void handlerRemoved(ChannelHandlerContext ctx) {
        if (this.compressor != null) {
            this.compressor.close();
        }
    }
}

