/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.protocol.game;

import com.google.common.base.MoreObjects;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.properties.PropertyMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.Optionull;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentSerialization;
import net.minecraft.network.chat.RemoteChatSession;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.PacketType;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.GamePacketTypes;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.PlayerModelPart;
import net.minecraft.world.level.GameType;
import org.bukkit.craftbukkit.entity.CraftPlayer;

public class ClientboundPlayerInfoUpdatePacket
implements Packet<ClientGamePacketListener> {
    public static final StreamCodec<RegistryFriendlyByteBuf, ClientboundPlayerInfoUpdatePacket> STREAM_CODEC = Packet.codec(ClientboundPlayerInfoUpdatePacket::write, ClientboundPlayerInfoUpdatePacket::new);
    private final EnumSet<Action> actions;
    private final List<Entry> entries;

    public ClientboundPlayerInfoUpdatePacket(EnumSet<Action> actions, Collection<ServerPlayer> players) {
        this.actions = actions;
        this.entries = players.stream().map(Entry::new).toList();
    }

    public ClientboundPlayerInfoUpdatePacket(Action action, ServerPlayer player) {
        this.actions = EnumSet.of(action);
        this.entries = List.of(new Entry(player));
    }

    public ClientboundPlayerInfoUpdatePacket(EnumSet<Action> actions, List<Entry> entries) {
        this.actions = actions;
        this.entries = entries;
    }

    public ClientboundPlayerInfoUpdatePacket(EnumSet<Action> actions, Entry entry) {
        this.actions = actions;
        this.entries = List.of(entry);
    }

    public static ClientboundPlayerInfoUpdatePacket createPlayerInitializing(Collection<ServerPlayer> players) {
        EnumSet<Action[]> set = EnumSet.of(Action.ADD_PLAYER, new Action[]{Action.INITIALIZE_CHAT, Action.UPDATE_GAME_MODE, Action.UPDATE_LISTED, Action.UPDATE_LATENCY, Action.UPDATE_DISPLAY_NAME, Action.UPDATE_HAT, Action.UPDATE_LIST_ORDER});
        return new ClientboundPlayerInfoUpdatePacket(set, players);
    }

    public static ClientboundPlayerInfoUpdatePacket createPlayerInitializing(Collection<ServerPlayer> players, ServerPlayer forPlayer) {
        EnumSet<Action[]> enumSet = EnumSet.of(Action.ADD_PLAYER, new Action[]{Action.INITIALIZE_CHAT, Action.UPDATE_GAME_MODE, Action.UPDATE_LISTED, Action.UPDATE_LATENCY, Action.UPDATE_DISPLAY_NAME, Action.UPDATE_HAT, Action.UPDATE_LIST_ORDER});
        ArrayList<Entry> entries = new ArrayList<Entry>(players.size());
        CraftPlayer bukkitEntity = forPlayer.getBukkitEntity();
        for (ServerPlayer player : players) {
            entries.add(new Entry(player, bukkitEntity.isListed(player.getBukkitEntity())));
        }
        return new ClientboundPlayerInfoUpdatePacket((EnumSet<Action>)enumSet, (List<Entry>)entries);
    }

    public static ClientboundPlayerInfoUpdatePacket createSinglePlayerInitializing(ServerPlayer player, boolean listed) {
        EnumSet<Action[]> enumSet = EnumSet.of(Action.ADD_PLAYER, new Action[]{Action.INITIALIZE_CHAT, Action.UPDATE_GAME_MODE, Action.UPDATE_LISTED, Action.UPDATE_LATENCY, Action.UPDATE_DISPLAY_NAME, Action.UPDATE_HAT, Action.UPDATE_LIST_ORDER});
        List<Entry> entries = List.of(new Entry(player, listed));
        return new ClientboundPlayerInfoUpdatePacket(enumSet, entries);
    }

    public static ClientboundPlayerInfoUpdatePacket updateListed(UUID playerInfoId, boolean listed) {
        EnumSet<Action> enumSet = EnumSet.of(Action.UPDATE_LISTED);
        return new ClientboundPlayerInfoUpdatePacket(enumSet, new Entry(playerInfoId, listed));
    }

    private ClientboundPlayerInfoUpdatePacket(RegistryFriendlyByteBuf buffer) {
        this.actions = buffer.readEnumSet(Action.class);
        this.entries = buffer.readList(buffer1 -> {
            EntryBuilder entryBuilder = new EntryBuilder(buffer1.readUUID());
            for (Action action : this.actions) {
                action.reader.read(entryBuilder, (RegistryFriendlyByteBuf)((Object)buffer1));
            }
            return entryBuilder.build();
        });
    }

    private void write(RegistryFriendlyByteBuf buffer) {
        buffer.writeEnumSet(this.actions, Action.class);
        buffer.writeCollection(this.entries, (buffer1, entry) -> {
            buffer1.writeUUID(entry.profileId());
            for (Action action : this.actions) {
                action.writer.write((RegistryFriendlyByteBuf)((Object)buffer1), (Entry)entry);
            }
        });
    }

    @Override
    public PacketType<ClientboundPlayerInfoUpdatePacket> type() {
        return GamePacketTypes.CLIENTBOUND_PLAYER_INFO_UPDATE;
    }

    @Override
    public void handle(ClientGamePacketListener handler) {
        handler.handlePlayerInfoUpdate(this);
    }

    public EnumSet<Action> actions() {
        return this.actions;
    }

    public List<Entry> entries() {
        return this.entries;
    }

    public List<Entry> newEntries() {
        return this.actions.contains((Object)Action.ADD_PLAYER) ? this.entries : List.of();
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("actions", this.actions).add("entries", this.entries).toString();
    }

    public record Entry(UUID profileId, @Nullable GameProfile profile, boolean listed, int latency, GameType gameMode, @Nullable Component displayName, boolean showHat, int listOrder, @Nullable RemoteChatSession.Data chatSession) {
        Entry(ServerPlayer player) {
            this(player, true);
        }

        Entry(ServerPlayer player, boolean listed) {
            this(player.getUUID(), player.getGameProfile(), listed, player.connection.latency(), player.gameMode(), player.getTabListDisplayName(), player.isModelPartShown(PlayerModelPart.HAT), player.getTabListOrder(), Optionull.map(player.getChatSession(), RemoteChatSession::asData));
        }

        Entry(UUID profileId, boolean listed) {
            this(profileId, null, listed, 0, GameType.DEFAULT_MODE, null, true, 0, null);
        }
    }

    public static enum Action {
        ADD_PLAYER((entryBuilder, buffer) -> {
            String string = (String)ByteBufCodecs.PLAYER_NAME.decode(buffer);
            PropertyMap propertyMap = (PropertyMap)ByteBufCodecs.GAME_PROFILE_PROPERTIES.decode(buffer);
            entryBuilder.profile = new GameProfile(entryBuilder.profileId, string, propertyMap);
        }, (buffer, entry) -> {
            GameProfile gameProfile = Objects.requireNonNull(entry.profile());
            ByteBufCodecs.PLAYER_NAME.encode(buffer, gameProfile.name());
            ByteBufCodecs.GAME_PROFILE_PROPERTIES.encode(buffer, gameProfile.properties());
        }),
        INITIALIZE_CHAT((entryBuilder, buffer) -> {
            entryBuilder.chatSession = buffer.readNullable(RemoteChatSession.Data::read);
        }, (buffer, entry) -> {
            RemoteChatSession.Data chatSession = entry.chatSession;
            if (chatSession != null && chatSession.profilePublicKey().hasExpired()) {
                chatSession = null;
            }
            buffer.writeNullable(chatSession, RemoteChatSession.Data::write);
        }),
        UPDATE_GAME_MODE((entryBuilder, buffer) -> {
            entryBuilder.gameMode = GameType.byId(buffer.readVarInt());
        }, (buffer, entry) -> buffer.writeVarInt(entry.gameMode().getId())),
        UPDATE_LISTED((entryBuilder, buffer) -> {
            entryBuilder.listed = buffer.readBoolean();
        }, (buffer, entry) -> buffer.writeBoolean(entry.listed())),
        UPDATE_LATENCY((entryBuilder, buffer) -> {
            entryBuilder.latency = buffer.readVarInt();
        }, (buffer, entry) -> buffer.writeVarInt(entry.latency())),
        UPDATE_DISPLAY_NAME((entryBuilder, buffer) -> {
            entryBuilder.displayName = FriendlyByteBuf.readNullable(buffer, ComponentSerialization.TRUSTED_STREAM_CODEC);
        }, (buffer, entry) -> FriendlyByteBuf.writeNullable(buffer, entry.displayName(), ComponentSerialization.TRUSTED_STREAM_CODEC)),
        UPDATE_LIST_ORDER((entryBuilder, buffer) -> {
            entryBuilder.listOrder = buffer.readVarInt();
        }, (buffer, entry) -> buffer.writeVarInt(entry.listOrder)),
        UPDATE_HAT((entryBuilder, buffer) -> {
            entryBuilder.showHat = buffer.readBoolean();
        }, (buffer, entry) -> buffer.writeBoolean(entry.showHat));

        final Reader reader;
        final Writer writer;

        private Action(Reader reader, Writer writer) {
            this.reader = reader;
            this.writer = writer;
        }

        public static interface Reader {
            public void read(EntryBuilder var1, RegistryFriendlyByteBuf var2);
        }

        public static interface Writer {
            public void write(RegistryFriendlyByteBuf var1, Entry var2);
        }
    }

    static class EntryBuilder {
        final UUID profileId;
        @Nullable
        GameProfile profile;
        boolean listed;
        int latency;
        GameType gameMode = GameType.DEFAULT_MODE;
        @Nullable
        Component displayName;
        boolean showHat;
        int listOrder;
        @Nullable
        RemoteChatSession.Data chatSession;

        EntryBuilder(UUID profileId) {
            this.profileId = profileId;
        }

        Entry build() {
            return new Entry(this.profileId, this.profile, this.listed, this.latency, this.gameMode, this.displayName, this.showHat, this.listOrder, this.chatSession);
        }
    }
}

