/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.bossevents;

import com.google.common.collect.Sets;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.UUIDUtil;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentSerialization;
import net.minecraft.network.chat.ComponentUtils;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerBossEvent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.BossEvent;
import org.bukkit.boss.KeyedBossBar;
import org.bukkit.craftbukkit.boss.CraftKeyedBossbar;

public class CustomBossEvent
extends ServerBossEvent {
    private static final int DEFAULT_MAX = 100;
    private final ResourceLocation id;
    private final Set<UUID> players = Sets.newHashSet();
    private int value;
    private int max = 100;
    @Nullable
    private KeyedBossBar bossBar;

    public KeyedBossBar getBukkitEntity() {
        if (this.bossBar == null) {
            this.bossBar = new CraftKeyedBossbar(this);
        }
        return this.bossBar;
    }

    public CustomBossEvent(ResourceLocation id, Component name) {
        super(name, BossEvent.BossBarColor.WHITE, BossEvent.BossBarOverlay.PROGRESS);
        this.id = id;
        this.setProgress(0.0f);
    }

    public ResourceLocation getTextId() {
        return this.id;
    }

    @Override
    public void addPlayer(ServerPlayer player) {
        super.addPlayer(player);
        this.players.add(player.getUUID());
    }

    public void addOfflinePlayer(UUID player) {
        this.players.add(player);
    }

    @Override
    public void removePlayer(ServerPlayer player) {
        super.removePlayer(player);
        this.players.remove(player.getUUID());
    }

    @Override
    public void removeAllPlayers() {
        super.removeAllPlayers();
        this.players.clear();
    }

    public int getValue() {
        return this.value;
    }

    public int getMax() {
        return this.max;
    }

    public void setValue(int value) {
        this.value = value;
        this.setProgress(Mth.clamp((float)value / (float)this.max, 0.0f, 1.0f));
    }

    public void setMax(int max) {
        this.max = max;
        this.setProgress(Mth.clamp((float)this.value / (float)max, 0.0f, 1.0f));
    }

    public final Component getDisplayName() {
        return ComponentUtils.wrapInSquareBrackets(this.getName()).withStyle(style -> style.withColor(this.getColor().getFormatting()).withHoverEvent(new HoverEvent.ShowText(Component.literal(this.getTextId().toString()))).withInsertion(this.getTextId().toString()));
    }

    public boolean setPlayers(Collection<ServerPlayer> players) {
        boolean flag;
        HashSet set = Sets.newHashSet();
        HashSet set1 = Sets.newHashSet();
        for (UUID uuid : this.players) {
            flag = false;
            for (ServerPlayer serverPlayer : players) {
                if (!serverPlayer.getUUID().equals(uuid)) continue;
                flag = true;
                break;
            }
            if (flag) continue;
            set.add(uuid);
        }
        for (ServerPlayer serverPlayer1 : players) {
            flag = false;
            for (UUID uuid1 : this.players) {
                if (!serverPlayer1.getUUID().equals(uuid1)) continue;
                flag = true;
                break;
            }
            if (flag) continue;
            set1.add(serverPlayer1);
        }
        for (UUID uuid : set) {
            for (ServerPlayer serverPlayer2 : this.getPlayers()) {
                if (!serverPlayer2.getUUID().equals(uuid)) continue;
                this.removePlayer(serverPlayer2);
                break;
            }
            this.players.remove(uuid);
        }
        for (ServerPlayer serverPlayer1 : set1) {
            this.addPlayer(serverPlayer1);
        }
        return !set.isEmpty() || !set1.isEmpty();
    }

    public static CustomBossEvent load(ResourceLocation id, Packed packed) {
        CustomBossEvent customBossEvent = new CustomBossEvent(id, packed.name);
        customBossEvent.setVisible(packed.visible);
        customBossEvent.setValue(packed.value);
        customBossEvent.setMax(packed.max);
        customBossEvent.setColor(packed.color);
        customBossEvent.setOverlay(packed.overlay);
        customBossEvent.setDarkenScreen(packed.darkenScreen);
        customBossEvent.setPlayBossMusic(packed.playBossMusic);
        customBossEvent.setCreateWorldFog(packed.createWorldFog);
        packed.players.forEach(customBossEvent::addOfflinePlayer);
        return customBossEvent;
    }

    public Packed pack() {
        return new Packed(this.getName(), this.isVisible(), this.getValue(), this.getMax(), this.getColor(), this.getOverlay(), this.shouldDarkenScreen(), this.shouldPlayBossMusic(), this.shouldCreateWorldFog(), Set.copyOf(this.players));
    }

    public void onPlayerConnect(ServerPlayer player) {
        if (this.players.contains(player.getUUID())) {
            this.addPlayer(player);
        }
    }

    public void onPlayerDisconnect(ServerPlayer player) {
        super.removePlayer(player);
    }

    public record Packed(Component name, boolean visible, int value, int max, BossEvent.BossBarColor color, BossEvent.BossBarOverlay overlay, boolean darkenScreen, boolean playBossMusic, boolean createWorldFog, Set<UUID> players) {
        public static final Codec<Packed> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ComponentSerialization.CODEC.fieldOf("Name").forGetter(Packed::name), (App)Codec.BOOL.optionalFieldOf("Visible", (Object)false).forGetter(Packed::visible), (App)Codec.INT.optionalFieldOf("Value", (Object)0).forGetter(Packed::value), (App)Codec.INT.optionalFieldOf("Max", (Object)100).forGetter(Packed::max), (App)BossEvent.BossBarColor.CODEC.optionalFieldOf("Color", (Object)BossEvent.BossBarColor.WHITE).forGetter(Packed::color), (App)BossEvent.BossBarOverlay.CODEC.optionalFieldOf("Overlay", (Object)BossEvent.BossBarOverlay.PROGRESS).forGetter(Packed::overlay), (App)Codec.BOOL.optionalFieldOf("DarkenScreen", (Object)false).forGetter(Packed::darkenScreen), (App)Codec.BOOL.optionalFieldOf("PlayBossMusic", (Object)false).forGetter(Packed::playBossMusic), (App)Codec.BOOL.optionalFieldOf("CreateWorldFog", (Object)false).forGetter(Packed::createWorldFog), (App)UUIDUtil.CODEC_SET.optionalFieldOf("Players", Set.of()).forGetter(Packed::players)).apply((Applicative)instance, Packed::new));
    }
}

