/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import java.util.Collection;
import java.util.Collections;
import java.util.function.Predicate;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.commands.arguments.item.ItemPredicateArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.ItemStack;

public class ClearInventoryCommands {
    private static final DynamicCommandExceptionType ERROR_SINGLE = new DynamicCommandExceptionType(player -> Component.translatableEscape("clear.failed.single", player));
    private static final DynamicCommandExceptionType ERROR_MULTIPLE = new DynamicCommandExceptionType(playerCount -> Component.translatableEscape("clear.failed.multiple", playerCount));

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher, CommandBuildContext context) {
        dispatcher.register((LiteralArgumentBuilder<CommandSourceStack>)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal("clear").requires(Commands.hasPermission(2))).executes(commandContext -> ClearInventoryCommands.clearUnlimited((CommandSourceStack)commandContext.getSource(), Collections.singleton(((CommandSourceStack)commandContext.getSource()).getPlayerOrException()), itemStack -> true))).then(((RequiredArgumentBuilder)Commands.argument("targets", EntityArgument.players()).executes(commandContext -> ClearInventoryCommands.clearUnlimited((CommandSourceStack)commandContext.getSource(), EntityArgument.getPlayers((CommandContext<CommandSourceStack>)commandContext, "targets"), itemStack -> true))).then(((RequiredArgumentBuilder)Commands.argument("item", ItemPredicateArgument.itemPredicate(context)).executes(context1 -> ClearInventoryCommands.clearUnlimited((CommandSourceStack)context1.getSource(), EntityArgument.getPlayers((CommandContext<CommandSourceStack>)context1, "targets"), ItemPredicateArgument.getItemPredicate((CommandContext<CommandSourceStack>)context1, "item")))).then(Commands.argument("maxCount", IntegerArgumentType.integer((int)0)).executes(context1 -> ClearInventoryCommands.clearInventory((CommandSourceStack)context1.getSource(), EntityArgument.getPlayers((CommandContext<CommandSourceStack>)context1, "targets"), ItemPredicateArgument.getItemPredicate((CommandContext<CommandSourceStack>)context1, "item"), IntegerArgumentType.getInteger((CommandContext)context1, (String)"maxCount"))))))));
    }

    private static int clearUnlimited(CommandSourceStack source, Collection<ServerPlayer> targets, Predicate<ItemStack> filter) throws CommandSyntaxException {
        return ClearInventoryCommands.clearInventory(source, targets, filter, -1);
    }

    private static int clearInventory(CommandSourceStack source, Collection<ServerPlayer> targetPlayers, Predicate<ItemStack> itemPredicate, int maxCount) throws CommandSyntaxException {
        int i = 0;
        for (ServerPlayer serverPlayer : targetPlayers) {
            i += serverPlayer.getInventory().clearOrCountMatchingItems(itemPredicate, maxCount, serverPlayer.inventoryMenu.getCraftSlots());
            serverPlayer.containerMenu.broadcastChanges();
            serverPlayer.inventoryMenu.slotsChanged(serverPlayer.getInventory());
        }
        if (i == 0) {
            if (targetPlayers.size() == 1) {
                throw ERROR_SINGLE.create((Object)targetPlayers.iterator().next().getName());
            }
            throw ERROR_MULTIPLE.create((Object)targetPlayers.size());
        }
        int i1 = i;
        if (maxCount == 0) {
            if (targetPlayers.size() == 1) {
                source.sendSuccess(() -> Component.translatable("commands.clear.test.single", i1, ((ServerPlayer)targetPlayers.iterator().next()).getDisplayName()), true);
            } else {
                source.sendSuccess(() -> Component.translatable("commands.clear.test.multiple", i1, targetPlayers.size()), true);
            }
        } else if (targetPlayers.size() == 1) {
            source.sendSuccess(() -> Component.translatable("commands.clear.success.single", i1, ((ServerPlayer)targetPlayers.iterator().next()).getDisplayName()), true);
        } else {
            source.sendSuccess(() -> Component.translatable("commands.clear.success.multiple", i1, targetPlayers.size()), true);
        }
        return i;
    }
}

