/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.coordinates.BlockPosArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.level.NaturalSpawner;

public class DebugMobSpawningCommand {
    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        LiteralArgumentBuilder literalArgumentBuilder = (LiteralArgumentBuilder)Commands.literal("debugmobspawning").requires(Commands.hasPermission(2));
        for (MobCategory mobCategory : MobCategory.values()) {
            literalArgumentBuilder.then(Commands.literal(mobCategory.getName()).then(Commands.argument("at", BlockPosArgument.blockPos()).executes(commandContext -> DebugMobSpawningCommand.spawnMobs((CommandSourceStack)commandContext.getSource(), mobCategory, BlockPosArgument.getLoadedBlockPos((CommandContext<CommandSourceStack>)commandContext, "at")))));
        }
        dispatcher.register((LiteralArgumentBuilder<CommandSourceStack>)literalArgumentBuilder);
    }

    private static int spawnMobs(CommandSourceStack source, MobCategory mobCategory, BlockPos pos) {
        NaturalSpawner.spawnCategoryForPosition(mobCategory, source.getLevel(), pos);
        return 1;
    }
}

