/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.brigadier.tree.LiteralCommandNode;
import java.util.Collection;
import java.util.function.BiConsumer;
import java.util.function.BiPredicate;
import java.util.function.ToIntFunction;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;

public class ExperienceCommand {
    private static final SimpleCommandExceptionType ERROR_SET_POINTS_INVALID = new SimpleCommandExceptionType((Message)Component.translatable("commands.experience.set.points.invalid"));

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        LiteralCommandNode<CommandSourceStack> literalCommandNode = dispatcher.register((LiteralArgumentBuilder<CommandSourceStack>)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal("experience").requires(Commands.hasPermission(2))).then(Commands.literal("add").then(Commands.argument("target", EntityArgument.players()).then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)Commands.argument("amount", IntegerArgumentType.integer()).executes(context -> ExperienceCommand.addExperience((CommandSourceStack)context.getSource(), EntityArgument.getPlayers((CommandContext<CommandSourceStack>)context, "target"), IntegerArgumentType.getInteger((CommandContext)context, (String)"amount"), Type.POINTS))).then(Commands.literal("points").executes(context -> ExperienceCommand.addExperience((CommandSourceStack)context.getSource(), EntityArgument.getPlayers((CommandContext<CommandSourceStack>)context, "target"), IntegerArgumentType.getInteger((CommandContext)context, (String)"amount"), Type.POINTS)))).then(Commands.literal("levels").executes(context -> ExperienceCommand.addExperience((CommandSourceStack)context.getSource(), EntityArgument.getPlayers((CommandContext<CommandSourceStack>)context, "target"), IntegerArgumentType.getInteger((CommandContext)context, (String)"amount"), Type.LEVELS))))))).then(Commands.literal("set").then(Commands.argument("target", EntityArgument.players()).then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)Commands.argument("amount", IntegerArgumentType.integer((int)0)).executes(context -> ExperienceCommand.setExperience((CommandSourceStack)context.getSource(), EntityArgument.getPlayers((CommandContext<CommandSourceStack>)context, "target"), IntegerArgumentType.getInteger((CommandContext)context, (String)"amount"), Type.POINTS))).then(Commands.literal("points").executes(context -> ExperienceCommand.setExperience((CommandSourceStack)context.getSource(), EntityArgument.getPlayers((CommandContext<CommandSourceStack>)context, "target"), IntegerArgumentType.getInteger((CommandContext)context, (String)"amount"), Type.POINTS)))).then(Commands.literal("levels").executes(context -> ExperienceCommand.setExperience((CommandSourceStack)context.getSource(), EntityArgument.getPlayers((CommandContext<CommandSourceStack>)context, "target"), IntegerArgumentType.getInteger((CommandContext)context, (String)"amount"), Type.LEVELS))))))).then(Commands.literal("query").then(((RequiredArgumentBuilder)Commands.argument("target", EntityArgument.player()).then(Commands.literal("points").executes(context -> ExperienceCommand.queryExperience((CommandSourceStack)context.getSource(), EntityArgument.getPlayer((CommandContext<CommandSourceStack>)context, "target"), Type.POINTS)))).then(Commands.literal("levels").executes(context -> ExperienceCommand.queryExperience((CommandSourceStack)context.getSource(), EntityArgument.getPlayer((CommandContext<CommandSourceStack>)context, "target"), Type.LEVELS)))))));
        dispatcher.register((LiteralArgumentBuilder<CommandSourceStack>)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal("xp").requires(Commands.hasPermission(2))).redirect(literalCommandNode)));
    }

    private static int queryExperience(CommandSourceStack source, ServerPlayer player, Type type) {
        int i = type.query.applyAsInt(player);
        source.sendSuccess(() -> Component.translatable("commands.experience.query." + type.name, player.getDisplayName(), i), false);
        return i;
    }

    private static int addExperience(CommandSourceStack source, Collection<? extends ServerPlayer> targets, int amount, Type type) {
        for (ServerPlayer serverPlayer : targets) {
            type.add.accept(serverPlayer, amount);
        }
        if (targets.size() == 1) {
            source.sendSuccess(() -> Component.translatable("commands.experience.add." + type.name + ".success.single", amount, ((ServerPlayer)targets.iterator().next()).getDisplayName()), true);
        } else {
            source.sendSuccess(() -> Component.translatable("commands.experience.add." + type.name + ".success.multiple", amount, targets.size()), true);
        }
        return targets.size();
    }

    private static int setExperience(CommandSourceStack source, Collection<? extends ServerPlayer> targets, int amount, Type type) throws CommandSyntaxException {
        int i = 0;
        for (ServerPlayer serverPlayer : targets) {
            if (!type.set.test(serverPlayer, amount)) continue;
            ++i;
        }
        if (i == 0) {
            throw ERROR_SET_POINTS_INVALID.create();
        }
        if (targets.size() == 1) {
            source.sendSuccess(() -> Component.translatable("commands.experience.set." + type.name + ".success.single", amount, ((ServerPlayer)targets.iterator().next()).getDisplayName()), true);
        } else {
            source.sendSuccess(() -> Component.translatable("commands.experience.set." + type.name + ".success.multiple", amount, targets.size()), true);
        }
        return targets.size();
    }

    static enum Type {
        POINTS("points", Player::giveExperiencePoints, (player, experience) -> {
            if (experience >= player.getXpNeededForNextLevel()) {
                return false;
            }
            player.setExperiencePoints((int)experience);
            return true;
        }, player -> Mth.floor(player.experienceProgress * (float)player.getXpNeededForNextLevel())),
        LEVELS("levels", ServerPlayer::giveExperienceLevels, (player, experience) -> {
            player.setExperienceLevels((int)experience);
            return true;
        }, player -> player.experienceLevel);

        public final BiConsumer<ServerPlayer, Integer> add;
        public final BiPredicate<ServerPlayer, Integer> set;
        public final String name;
        final ToIntFunction<ServerPlayer> query;

        private Type(String name, BiConsumer<ServerPlayer, Integer> add, BiPredicate<ServerPlayer, Integer> set, ToIntFunction<ServerPlayer> query) {
            this.add = add;
            this.name = name;
            this.set = set;
            this.query = query;
        }
    }
}

