/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.commands;

import com.google.common.collect.Sets;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import java.util.Collection;
import java.util.HashSet;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentUtils;
import net.minecraft.world.entity.Entity;

public class TagCommand {
    private static final SimpleCommandExceptionType ERROR_ADD_FAILED = new SimpleCommandExceptionType((Message)Component.translatable("commands.tag.add.failed"));
    private static final SimpleCommandExceptionType ERROR_REMOVE_FAILED = new SimpleCommandExceptionType((Message)Component.translatable("commands.tag.remove.failed"));

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder<CommandSourceStack>)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal("tag").requires(Commands.hasPermission(2))).then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)Commands.argument("targets", EntityArgument.entities()).then(Commands.literal("add").then(Commands.argument("name", StringArgumentType.word()).executes(commandContext -> TagCommand.addTag((CommandSourceStack)commandContext.getSource(), EntityArgument.getEntities((CommandContext<CommandSourceStack>)commandContext, "targets"), StringArgumentType.getString((CommandContext)commandContext, (String)"name")))))).then(Commands.literal("remove").then(Commands.argument("name", StringArgumentType.word()).suggests((commandContext, suggestionsBuilder) -> SharedSuggestionProvider.suggest(TagCommand.getTags(EntityArgument.getEntities((CommandContext<CommandSourceStack>)commandContext, "targets")), suggestionsBuilder)).executes(commandContext -> TagCommand.removeTag((CommandSourceStack)commandContext.getSource(), EntityArgument.getEntities((CommandContext<CommandSourceStack>)commandContext, "targets"), StringArgumentType.getString((CommandContext)commandContext, (String)"name")))))).then(Commands.literal("list").executes(context -> TagCommand.listTags((CommandSourceStack)context.getSource(), EntityArgument.getEntities((CommandContext<CommandSourceStack>)context, "targets")))))));
    }

    private static Collection<String> getTags(Collection<? extends Entity> entities) {
        HashSet set = Sets.newHashSet();
        for (Entity entity : entities) {
            set.addAll(entity.getTags());
        }
        return set;
    }

    private static int addTag(CommandSourceStack source, Collection<? extends Entity> entities, String tagName) throws CommandSyntaxException {
        int i = 0;
        for (Entity entity : entities) {
            if (!entity.addTag(tagName)) continue;
            ++i;
        }
        if (i == 0) {
            throw ERROR_ADD_FAILED.create();
        }
        if (entities.size() == 1) {
            source.sendSuccess(() -> Component.translatable("commands.tag.add.success.single", tagName, ((Entity)entities.iterator().next()).getDisplayName()), true);
        } else {
            source.sendSuccess(() -> Component.translatable("commands.tag.add.success.multiple", tagName, entities.size()), true);
        }
        return i;
    }

    private static int removeTag(CommandSourceStack source, Collection<? extends Entity> entities, String tagName) throws CommandSyntaxException {
        int i = 0;
        for (Entity entity : entities) {
            if (!entity.removeTag(tagName)) continue;
            ++i;
        }
        if (i == 0) {
            throw ERROR_REMOVE_FAILED.create();
        }
        if (entities.size() == 1) {
            source.sendSuccess(() -> Component.translatable("commands.tag.remove.success.single", tagName, ((Entity)entities.iterator().next()).getDisplayName()), true);
        } else {
            source.sendSuccess(() -> Component.translatable("commands.tag.remove.success.multiple", tagName, entities.size()), true);
        }
        return i;
    }

    private static int listTags(CommandSourceStack source, Collection<? extends Entity> entities) {
        HashSet set = Sets.newHashSet();
        for (Entity entity : entities) {
            set.addAll(entity.getTags());
        }
        if (entities.size() == 1) {
            Entity entity1 = entities.iterator().next();
            if (set.isEmpty()) {
                source.sendSuccess(() -> Component.translatable("commands.tag.list.single.empty", entity1.getDisplayName()), false);
            } else {
                source.sendSuccess(() -> Component.translatable("commands.tag.list.single.success", entity1.getDisplayName(), set.size(), ComponentUtils.formatList(set)), false);
            }
        } else if (set.isEmpty()) {
            source.sendSuccess(() -> Component.translatable("commands.tag.list.multiple.empty", entities.size()), false);
        } else {
            source.sendSuccess(() -> Component.translatable("commands.tag.list.multiple.success", entities.size(), set.size(), ComponentUtils.formatList(set)), false);
        }
        return set.size();
    }
}

