/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.brigadier.tree.LiteralCommandNode;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Locale;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityAnchorArgument;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.commands.arguments.coordinates.Coordinates;
import net.minecraft.commands.arguments.coordinates.RotationArgument;
import net.minecraft.commands.arguments.coordinates.Vec3Argument;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.commands.LookAt;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Relative;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import org.bukkit.event.player.PlayerTeleportEvent;

public class TeleportCommand {
    private static final SimpleCommandExceptionType INVALID_POSITION = new SimpleCommandExceptionType((Message)Component.translatable("commands.teleport.invalidPosition"));

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        LiteralCommandNode<CommandSourceStack> literalCommandNode = dispatcher.register((LiteralArgumentBuilder<CommandSourceStack>)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal("teleport").requires(Commands.hasPermission(2))).then(Commands.argument("location", Vec3Argument.vec3()).executes(commandContext -> TeleportCommand.teleportToPos((CommandSourceStack)commandContext.getSource(), Collections.singleton(((CommandSourceStack)commandContext.getSource()).getEntityOrException()), ((CommandSourceStack)commandContext.getSource()).getLevel(), Vec3Argument.getCoordinates((CommandContext<CommandSourceStack>)commandContext, "location"), null, null)))).then(Commands.argument("destination", EntityArgument.entity()).executes(context -> TeleportCommand.teleportToEntity((CommandSourceStack)context.getSource(), Collections.singleton(((CommandSourceStack)context.getSource()).getEntityOrException()), EntityArgument.getEntity((CommandContext<CommandSourceStack>)context, "destination"))))).then(((RequiredArgumentBuilder)Commands.argument("targets", EntityArgument.entities()).then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)Commands.argument("location", Vec3Argument.vec3()).executes(context -> TeleportCommand.teleportToPos((CommandSourceStack)context.getSource(), EntityArgument.getEntities((CommandContext<CommandSourceStack>)context, "targets"), ((CommandSourceStack)context.getSource()).getLevel(), Vec3Argument.getCoordinates((CommandContext<CommandSourceStack>)context, "location"), null, null))).then(Commands.argument("rotation", RotationArgument.rotation()).executes(context -> TeleportCommand.teleportToPos((CommandSourceStack)context.getSource(), EntityArgument.getEntities((CommandContext<CommandSourceStack>)context, "targets"), ((CommandSourceStack)context.getSource()).getLevel(), Vec3Argument.getCoordinates((CommandContext<CommandSourceStack>)context, "location"), RotationArgument.getRotation((CommandContext<CommandSourceStack>)context, "rotation"), null)))).then(((LiteralArgumentBuilder)Commands.literal("facing").then(Commands.literal("entity").then(((RequiredArgumentBuilder)Commands.argument("facingEntity", EntityArgument.entity()).executes(context -> TeleportCommand.teleportToPos((CommandSourceStack)context.getSource(), EntityArgument.getEntities((CommandContext<CommandSourceStack>)context, "targets"), ((CommandSourceStack)context.getSource()).getLevel(), Vec3Argument.getCoordinates((CommandContext<CommandSourceStack>)context, "location"), null, new LookAt.LookAtEntity(EntityArgument.getEntity((CommandContext<CommandSourceStack>)context, "facingEntity"), EntityAnchorArgument.Anchor.FEET)))).then(Commands.argument("facingAnchor", EntityAnchorArgument.anchor()).executes(context -> TeleportCommand.teleportToPos((CommandSourceStack)context.getSource(), EntityArgument.getEntities((CommandContext<CommandSourceStack>)context, "targets"), ((CommandSourceStack)context.getSource()).getLevel(), Vec3Argument.getCoordinates((CommandContext<CommandSourceStack>)context, "location"), null, new LookAt.LookAtEntity(EntityArgument.getEntity((CommandContext<CommandSourceStack>)context, "facingEntity"), EntityAnchorArgument.getAnchor((CommandContext<CommandSourceStack>)context, "facingAnchor")))))))).then(Commands.argument("facingLocation", Vec3Argument.vec3()).executes(context -> TeleportCommand.teleportToPos((CommandSourceStack)context.getSource(), EntityArgument.getEntities((CommandContext<CommandSourceStack>)context, "targets"), ((CommandSourceStack)context.getSource()).getLevel(), Vec3Argument.getCoordinates((CommandContext<CommandSourceStack>)context, "location"), null, new LookAt.LookAtPosition(Vec3Argument.getVec3((CommandContext<CommandSourceStack>)context, "facingLocation")))))))).then(Commands.argument("destination", EntityArgument.entity()).executes(context -> TeleportCommand.teleportToEntity((CommandSourceStack)context.getSource(), EntityArgument.getEntities((CommandContext<CommandSourceStack>)context, "targets"), EntityArgument.getEntity((CommandContext<CommandSourceStack>)context, "destination")))))));
        dispatcher.register((LiteralArgumentBuilder<CommandSourceStack>)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal("tp").requires(Commands.hasPermission(2))).redirect(literalCommandNode)));
    }

    private static int teleportToEntity(CommandSourceStack source, Collection<? extends Entity> targets, Entity destination) throws CommandSyntaxException {
        for (Entity entity : targets) {
            TeleportCommand.performTeleport(source, entity, (ServerLevel)destination.level(), destination.getX(), destination.getY(), destination.getZ(), EnumSet.noneOf(Relative.class), destination.getYRot(), destination.getXRot(), null);
        }
        if (targets.size() == 1) {
            source.sendSuccess(() -> Component.translatable("commands.teleport.success.entity.single", ((Entity)targets.iterator().next()).getDisplayName(), destination.getDisplayName()), true);
        } else {
            source.sendSuccess(() -> Component.translatable("commands.teleport.success.entity.multiple", targets.size(), destination.getDisplayName()), true);
        }
        return targets.size();
    }

    private static int teleportToPos(CommandSourceStack source, Collection<? extends Entity> targets, ServerLevel level, Coordinates position, @Nullable Coordinates rotation, @Nullable LookAt lookAt) throws CommandSyntaxException {
        Vec3 position1 = position.getPosition(source);
        Vec2 vec2 = rotation == null ? null : rotation.getRotation(source);
        for (Entity entity : targets) {
            Set<Relative> relatives = TeleportCommand.getRelatives(position, rotation, entity.level().dimension() == level.dimension());
            if (vec2 == null) {
                TeleportCommand.performTeleport(source, entity, level, position1.x, position1.y, position1.z, relatives, entity.getYRot(), entity.getXRot(), lookAt);
                continue;
            }
            TeleportCommand.performTeleport(source, entity, level, position1.x, position1.y, position1.z, relatives, vec2.y, vec2.x, lookAt);
        }
        if (targets.size() == 1) {
            source.sendSuccess(() -> Component.translatable("commands.teleport.success.location.single", ((Entity)targets.iterator().next()).getDisplayName(), TeleportCommand.formatDouble(position1.x), TeleportCommand.formatDouble(position1.y), TeleportCommand.formatDouble(position1.z)), true);
        } else {
            source.sendSuccess(() -> Component.translatable("commands.teleport.success.location.multiple", targets.size(), TeleportCommand.formatDouble(position1.x), TeleportCommand.formatDouble(position1.y), TeleportCommand.formatDouble(position1.z)), true);
        }
        return targets.size();
    }

    private static Set<Relative> getRelatives(Coordinates position, @Nullable Coordinates rotation, boolean absolute) {
        Set<Relative> set = Relative.direction(position.isXRelative(), position.isYRelative(), position.isZRelative());
        Set set1 = absolute ? Relative.position(position.isXRelative(), position.isYRelative(), position.isZRelative()) : Set.of();
        Set<Relative> set2 = rotation == null ? Relative.ROTATION : Relative.rotation(rotation.isYRelative(), rotation.isXRelative());
        return Relative.union(set, set1, set2);
    }

    private static String formatDouble(double value) {
        return String.format(Locale.ROOT, "%f", value);
    }

    private static void performTeleport(CommandSourceStack source, Entity target, ServerLevel level, double x, double y, double z, Set<Relative> relatives, float yRot, float xRot, @Nullable LookAt lookAt) throws CommandSyntaxException {
        float f3;
        BlockPos blockPos = BlockPos.containing(x, y, z);
        if (!Level.isInSpawnableBounds(blockPos)) {
            throw INVALID_POSITION.create();
        }
        double d = relatives.contains((Object)Relative.X) ? x - target.getX() : x;
        double d1 = relatives.contains((Object)Relative.Y) ? y - target.getY() : y;
        double d2 = relatives.contains((Object)Relative.Z) ? z - target.getZ() : z;
        float f = relatives.contains((Object)Relative.Y_ROT) ? yRot - target.getYRot() : yRot;
        float f1 = relatives.contains((Object)Relative.X_ROT) ? xRot - target.getXRot() : xRot;
        float f2 = Mth.wrapDegrees(f);
        if (target.teleportTo(level, d, d1, d2, relatives, f2, f3 = Mth.wrapDegrees(f1), true, PlayerTeleportEvent.TeleportCause.COMMAND)) {
            LivingEntity livingEntity;
            if (lookAt != null) {
                lookAt.perform(source, target);
            }
            if (!(target instanceof LivingEntity) || !(livingEntity = (LivingEntity)target).isFallFlying()) {
                target.setDeltaMovement(target.getDeltaMovement().multiply(1.0, 0.0, 1.0));
                target.setOnGround(true);
            }
            if (target instanceof PathfinderMob) {
                PathfinderMob pathfinderMob = (PathfinderMob)target;
                pathfinderMob.getNavigation().stop();
            }
        }
    }
}

