/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import io.papermc.paper.configuration.GlobalConfiguration;
import java.util.List;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.TimeArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.event.Event;
import org.bukkit.event.world.TimeSkipEvent;

public class TimeCommand {
    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder<CommandSourceStack>)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal("time").requires(Commands.hasPermission(2))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal("set").then(Commands.literal("day").executes(commandContext -> TimeCommand.setTime((CommandSourceStack)commandContext.getSource(), 1000)))).then(Commands.literal("noon").executes(context -> TimeCommand.setTime((CommandSourceStack)context.getSource(), 6000)))).then(Commands.literal("night").executes(context -> TimeCommand.setTime((CommandSourceStack)context.getSource(), 13000)))).then(Commands.literal("midnight").executes(context -> TimeCommand.setTime((CommandSourceStack)context.getSource(), 18000)))).then(Commands.argument("time", TimeArgument.time()).executes(context -> TimeCommand.setTime((CommandSourceStack)context.getSource(), IntegerArgumentType.getInteger((CommandContext)context, (String)"time")))))).then(Commands.literal("add").then(Commands.argument("time", TimeArgument.time()).executes(context -> TimeCommand.addTime((CommandSourceStack)context.getSource(), IntegerArgumentType.getInteger((CommandContext)context, (String)"time")))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal("query").then(Commands.literal("daytime").executes(context -> TimeCommand.queryTime((CommandSourceStack)context.getSource(), TimeCommand.getDayTime(((CommandSourceStack)context.getSource()).getLevel()))))).then(Commands.literal("gametime").executes(context -> TimeCommand.queryTime((CommandSourceStack)context.getSource(), (int)(((CommandSourceStack)context.getSource()).getLevel().getGameTime() % Integer.MAX_VALUE))))).then(Commands.literal("day").executes(context -> TimeCommand.queryTime((CommandSourceStack)context.getSource(), (int)(((CommandSourceStack)context.getSource()).getLevel().getDayTime() / 24000L % Integer.MAX_VALUE)))))));
    }

    private static int getDayTime(ServerLevel level) {
        return (int)(level.getDayTime() % 24000L);
    }

    private static int queryTime(CommandSourceStack source, int time) {
        source.sendSuccess(() -> Component.translatable("commands.time.query", time), false);
        return time;
    }

    public static int setTime(CommandSourceStack source, int time) {
        for (ServerLevel serverLevel : GlobalConfiguration.get().commands.timeCommandAffectsAllWorlds ? source.getServer().getAllLevels() : List.of(source.getLevel())) {
            TimeSkipEvent event = new TimeSkipEvent((World)serverLevel.getWorld(), TimeSkipEvent.SkipReason.COMMAND, (long)time - serverLevel.getDayTime());
            Bukkit.getPluginManager().callEvent((Event)event);
            if (event.isCancelled()) continue;
            serverLevel.setDayTime(serverLevel.getDayTime() + event.getSkipAmount());
        }
        source.getServer().forceTimeSynchronization();
        source.sendSuccess(() -> Component.translatable("commands.time.set", time), true);
        return TimeCommand.getDayTime(source.getLevel());
    }

    public static int addTime(CommandSourceStack source, int amount) {
        for (ServerLevel serverLevel : GlobalConfiguration.get().commands.timeCommandAffectsAllWorlds ? source.getServer().getAllLevels() : List.of(source.getLevel())) {
            TimeSkipEvent event = new TimeSkipEvent((World)serverLevel.getWorld(), TimeSkipEvent.SkipReason.COMMAND, (long)amount);
            Bukkit.getPluginManager().callEvent((Event)event);
            if (event.isCancelled()) continue;
            serverLevel.setDayTime(serverLevel.getDayTime() + event.getSkipAmount());
        }
        source.getServer().forceTimeSynchronization();
        int dayTime = TimeCommand.getDayTime(source.getLevel());
        source.sendSuccess(() -> Component.translatable("commands.time.set", dayTime), true);
        return dayTime;
    }
}

