/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.dedicated;

import ca.spottedleaf.moonrise.common.util.JsonUtil;
import ca.spottedleaf.moonrise.patches.chunk_system.scheduling.ChunkTaskScheduler;
import com.destroystokyo.paper.Metrics;
import com.destroystokyo.paper.VersionHistoryManager;
import com.destroystokyo.paper.console.PaperConsole;
import com.destroystokyo.paper.event.server.WhitelistToggleEvent;
import com.google.common.collect.ImmutableMap;
import com.google.common.net.HostAndPort;
import com.google.gson.JsonElement;
import com.mojang.datafixers.DataFixer;
import com.mojang.logging.LogUtils;
import io.netty.channel.epoll.Epoll;
import io.netty.channel.unix.DomainSocketAddress;
import io.netty.handler.ssl.SslContext;
import io.papermc.paper.command.PaperCommands;
import io.papermc.paper.configuration.GlobalConfiguration;
import io.papermc.paper.util.ObfHelper;
import io.papermc.paper.util.ServerEnvironment;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.SocketAddress;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BooleanSupplier;
import java.util.logging.Handler;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import joptsimple.OptionSet;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import net.minecraft.DefaultUncaughtExceptionHandler;
import net.minecraft.SharedConstants;
import net.minecraft.SystemReport;
import net.minecraft.Util;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.BlockPos;
import net.minecraft.server.ConsoleInput;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.ServerInterface;
import net.minecraft.server.ServerLinks;
import net.minecraft.server.Services;
import net.minecraft.server.WorldLoader;
import net.minecraft.server.WorldStem;
import net.minecraft.server.dedicated.DedicatedPlayerList;
import net.minecraft.server.dedicated.DedicatedServerProperties;
import net.minecraft.server.dedicated.DedicatedServerSettings;
import net.minecraft.server.gui.MinecraftServerGui;
import net.minecraft.server.jsonrpc.JsonRpcNotificationService;
import net.minecraft.server.jsonrpc.ManagementServer;
import net.minecraft.server.jsonrpc.internalapi.MinecraftApi;
import net.minecraft.server.jsonrpc.security.AuthenticationHandler;
import net.minecraft.server.jsonrpc.security.JsonRpcSslContextProvider;
import net.minecraft.server.jsonrpc.security.SecurityConfig;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.level.progress.LoggingLevelLoadListener;
import net.minecraft.server.network.ServerTextFilter;
import net.minecraft.server.network.TextFilter;
import net.minecraft.server.packs.repository.PackRepository;
import net.minecraft.server.players.NameAndId;
import net.minecraft.server.players.OldUsersConverter;
import net.minecraft.server.rcon.RconConsoleSource;
import net.minecraft.server.rcon.thread.QueryThreadGs4;
import net.minecraft.server.rcon.thread.RconThread;
import net.minecraft.util.Mth;
import net.minecraft.util.StringUtil;
import net.minecraft.util.TimeUtil;
import net.minecraft.util.debug.DebugSubscriptions;
import net.minecraft.util.debugchart.RemoteDebugSampleType;
import net.minecraft.util.debugchart.RemoteSampleLogger;
import net.minecraft.util.debugchart.SampleLogger;
import net.minecraft.util.debugchart.TpsDebugDimensions;
import net.minecraft.util.monitoring.jmx.MinecraftServerStatistics;
import net.minecraft.world.Difficulty;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.storage.LevelData;
import net.minecraft.world.level.storage.LevelStorageSource;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.io.IoBuilder;
import org.bukkit.command.CommandSender;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.craftbukkit.Main;
import org.bukkit.craftbukkit.util.ForwardLogHandler;
import org.bukkit.event.Event;
import org.bukkit.event.server.RemoteServerCommandEvent;
import org.bukkit.event.server.ServerCommandEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginLoadOrder;
import org.slf4j.Logger;
import org.spigotmc.SpigotConfig;
import org.spigotmc.WatchdogThread;

public class DedicatedServer
extends MinecraftServer
implements ServerInterface {
    static final Logger LOGGER = LogUtils.getLogger();
    private static final int CONVERSION_RETRY_DELAY_MS = 5000;
    private static final int CONVERSION_RETRIES = 2;
    private final Queue<ConsoleInput> serverCommandQueue = new ConcurrentLinkedQueue<ConsoleInput>();
    @Nullable
    private QueryThreadGs4 queryThreadGs4;
    @Nullable
    private RconThread rconThread;
    public DedicatedServerSettings settings;
    @Nullable
    private MinecraftServerGui gui;
    @Nullable
    private final ServerTextFilter serverTextFilter;
    @Nullable
    private RemoteSampleLogger tickTimeLogger;
    private boolean isTickTimeLoggingEnabled;
    public ServerLinks serverLinks;
    private final Map<String, String> codeOfConductTexts;
    @Nullable
    private ManagementServer jsonRpcServer;
    private long lastHeartbeat;
    private static final AtomicInteger ASYNC_DEBUG_CHUNKS_COUNT = new AtomicInteger();

    public DedicatedServer(OptionSet options, WorldLoader.DataLoadContext worldLoader, Thread serverThread, LevelStorageSource.LevelStorageAccess storageSource, PackRepository packRepository, WorldStem worldStem, DedicatedServerSettings settings, DataFixer fixerUpper, Services services) {
        super(options, worldLoader, serverThread, storageSource, packRepository, worldStem, Proxy.NO_PROXY, fixerUpper, services, LoggingLevelLoadListener.forDedicatedServer());
        this.settings = settings;
        this.setMotd(settings.getProperties().motd.get());
        this.serverTextFilter = ServerTextFilter.createFromConfig(settings.getProperties());
        this.serverLinks = DedicatedServer.createServerLinks(settings);
        this.codeOfConductTexts = settings.getProperties().codeOfConduct ? DedicatedServer.readCodeOfConducts() : Map.of();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static Map<String, String> readCodeOfConducts() {
        Path path = Path.of("codeofconduct", new String[0]);
        if (!Files.isDirectory(path, LinkOption.NOFOLLOW_LINKS)) {
            throw new IllegalArgumentException("Code of Conduct folder does not exist: " + String.valueOf(path));
        }
        try {
            ImmutableMap.Builder builder = ImmutableMap.builder();
            try (Stream<Path> stream = Files.list(path);){
                for (Path path1 : stream.toList()) {
                    String string = path1.getFileName().toString();
                    if (!string.endsWith(".txt")) continue;
                    String string1 = string.substring(0, string.length() - 4).toLowerCase(Locale.ROOT);
                    if (!path1.toRealPath(new LinkOption[0]).getParent().equals(path.toAbsolutePath())) {
                        throw new IllegalArgumentException("Failed to read Code of Conduct file \"" + string + "\" because it links to a file outside the allowed directory");
                    }
                    try {
                        String string2 = String.join((CharSequence)"\n", Files.readAllLines(path1, StandardCharsets.UTF_8));
                        builder.put((Object)string1, (Object)StringUtil.stripColor(string2));
                    }
                    catch (IOException var9) {
                        throw new IllegalArgumentException("Failed to read Code of Conduct file " + string, var9);
                        return builder.build();
                    }
                }
            }
        }
        catch (IOException var11) {
            throw new IllegalArgumentException("Failed to read Code of Conduct folder", var11);
        }
    }

    private SslContext createSslContext() {
        try {
            return JsonRpcSslContextProvider.createFrom(this.getProperties().managementServerTlsKeystore, this.getProperties().managementServerTlsKeystorePassword);
        }
        catch (Exception var2) {
            JsonRpcSslContextProvider.printInstructions();
            throw new IllegalStateException("Failed to configure TLS for the server management protocol", var2);
        }
    }

    @Override
    public boolean initServer() throws IOException {
        String proxyLink;
        Object bindAddress;
        int i = this.getProperties().managementServerPort;
        if (this.getProperties().managementServerEnabled) {
            String string = this.settings.getProperties().managementServerSecret;
            if (!SecurityConfig.isValid(string)) {
                throw new IllegalStateException("Invalid management server secret, must be 40 alphanumeric characters");
            }
            String string1 = this.getProperties().managementServerHost;
            HostAndPort hostAndPort = HostAndPort.fromParts((String)string1, (int)i);
            SecurityConfig securityConfig = new SecurityConfig(string);
            AuthenticationHandler authenticationHandler = new AuthenticationHandler(securityConfig);
            LOGGER.info("Starting json RPC server on {}", (Object)hostAndPort);
            this.jsonRpcServer = new ManagementServer(hostAndPort, authenticationHandler);
            MinecraftApi minecraftApi = MinecraftApi.of(this);
            minecraftApi.notificationManager().registerService(new JsonRpcNotificationService(minecraftApi, this.jsonRpcServer));
            if (this.getProperties().managementServerTlsEnabled) {
                SslContext sslContext = this.createSslContext();
                this.jsonRpcServer.startWithTls(minecraftApi, sslContext);
            } else {
                this.jsonRpcServer.startWithoutTls(minecraftApi);
            }
        }
        Thread thread = new Thread("Server console handler"){

            @Override
            public void run() {
                if (!Main.useConsole) {
                    return;
                }
                new PaperConsole(DedicatedServer.this).start();
            }
        };
        java.util.logging.Logger global = java.util.logging.Logger.getLogger("");
        global.setUseParentHandlers(false);
        for (HostAndPort handler : global.getHandlers()) {
            global.removeHandler((Handler)handler);
        }
        global.addHandler(new ForwardLogHandler());
        org.apache.logging.log4j.Logger logger = LogManager.getRootLogger();
        System.setOut(IoBuilder.forLogger((org.apache.logging.log4j.Logger)logger).setLevel(Level.INFO).buildPrintStream());
        System.setErr(IoBuilder.forLogger((org.apache.logging.log4j.Logger)logger).setLevel(Level.WARN).buildPrintStream());
        thread.setDaemon(true);
        thread.setUncaughtExceptionHandler(new DefaultUncaughtExceptionHandler(LOGGER));
        LOGGER.info("Starting minecraft server version {}", (Object)SharedConstants.getCurrentVersion().name());
        if (Runtime.getRuntime().maxMemory() / 1024L / 1024L < 512L) {
            LOGGER.warn("To start the server with more ram, launch it as \"java -Xmx1024M -Xms1024M -jar minecraft_server.jar\"");
        }
        if (ServerEnvironment.userIsRootOrAdmin()) {
            LOGGER.warn("****************************");
            LOGGER.warn("YOU ARE RUNNING THIS SERVER AS AN ADMINISTRATIVE OR ROOT USER. THIS IS NOT ADVISED.");
            LOGGER.warn("YOU ARE OPENING YOURSELF UP TO POTENTIAL RISKS WHEN DOING THIS.");
            LOGGER.warn("FOR MORE INFORMATION, SEE https://madelinemiller.dev/blog/root-minecraft-server/");
            LOGGER.warn("****************************");
        }
        LOGGER.info("Loading properties");
        DedicatedServerProperties properties = this.settings.getProperties();
        if (this.isSingleplayer()) {
            this.setLocalIp("127.0.0.1");
        } else {
            this.setUsesAuthentication(properties.onlineMode);
            this.setPreventProxyConnections(properties.preventProxyConnections);
            this.setLocalIp(properties.serverIp);
        }
        this.setPlayerList(new DedicatedPlayerList(this, this.registries(), this.playerDataStorage));
        SpigotConfig.init((File)this.options.valueOf("spigot-settings"));
        SpigotConfig.registerCommands();
        ((Object)((Object)ObfHelper.INSTANCE)).getClass();
        this.paperConfigurations.initializeGlobalConfiguration(this.registryAccess());
        this.paperConfigurations.initializeWorldDefaultsConfiguration(this.registryAccess());
        this.server.spark.enableEarlyIfRequested();
        if (this.convertOldUsers()) {
            this.services().nameToIdCache().save(false);
        }
        this.getPlayerList().loadAndSaveFiles();
        WatchdogThread.doStart(SpigotConfig.timeoutTime, SpigotConfig.restartOnCrash);
        thread.start();
        PaperCommands.registerCommands(this);
        this.server.spark.registerCommandBeforePlugins(this.server);
        Metrics.PaperMetrics.startMetrics();
        ((Object)((Object)VersionHistoryManager.INSTANCE)).getClass();
        LOGGER.info("Default game type: {}", (Object)properties.gameMode.get());
        if (this.getLocalIp().startsWith("unix:")) {
            if (!Epoll.isAvailable()) {
                LOGGER.error("**** INVALID CONFIGURATION!");
                LOGGER.error("You are trying to use a Unix domain socket but you're not on a supported OS.");
                return false;
            }
            if (!GlobalConfiguration.get().proxies.velocity.enabled && !SpigotConfig.bungee) {
                LOGGER.error("**** INVALID CONFIGURATION!");
                LOGGER.error("Unix domain sockets require IPs to be forwarded from a proxy.");
                return false;
            }
            bindAddress = new DomainSocketAddress(this.getLocalIp().substring("unix:".length()));
        } else {
            InetAddress inetAddress = null;
            if (!this.getLocalIp().isEmpty()) {
                inetAddress = InetAddress.getByName(this.getLocalIp());
            }
            if (this.getPort() < 0) {
                this.setPort(properties.serverPort);
            }
            bindAddress = new InetSocketAddress(inetAddress, this.getPort());
        }
        this.initializeKeyPair();
        LOGGER.info("Starting Minecraft server on {}:{}", (Object)(this.getLocalIp().isEmpty() ? "*" : this.getLocalIp()), (Object)this.getPort());
        try {
            this.getConnection().startTcpServerListener((SocketAddress)bindAddress);
        }
        catch (IOException var11) {
            LOGGER.warn("**** FAILED TO BIND TO PORT!");
            LOGGER.warn("The exception was: {}", (Object)var11.toString());
            LOGGER.warn("Perhaps a server is already running on that port?");
            throw new IllegalStateException("Failed to bind to port", var11);
        }
        this.server.loadPlugins();
        this.server.enablePlugins(PluginLoadOrder.STARTUP);
        boolean usingProxy = SpigotConfig.bungee || GlobalConfiguration.get().proxies.velocity.enabled;
        String proxyFlavor = GlobalConfiguration.get().proxies.velocity.enabled ? "Velocity" : "BungeeCord";
        String string = proxyLink = GlobalConfiguration.get().proxies.velocity.enabled ? "https://docs.papermc.io/velocity/security" : "http://www.spigotmc.org/wiki/firewall-guide/";
        if (!this.usesAuthentication()) {
            LOGGER.warn("**** SERVER IS RUNNING IN OFFLINE/INSECURE MODE!");
            LOGGER.warn("The server will make no attempt to authenticate usernames. Beware.");
            if (usingProxy) {
                LOGGER.warn("Whilst this makes it possible to use {}, unless access to your server is properly restricted, it also opens up the ability for hackers to connect with any username they choose.", (Object)proxyFlavor);
                LOGGER.warn("Please see {} for further information.", (Object)proxyLink);
            } else {
                LOGGER.warn("While this makes the game possible to play without internet access, it also opens up the ability for hackers to connect with any username they choose.");
            }
            LOGGER.warn("To change this, set \"online-mode\" to \"true\" in the server.properties file.");
        }
        if (!OldUsersConverter.serverReadyAfterUserconversion(this)) {
            return false;
        }
        this.tickTimeLogger = new RemoteSampleLogger(TpsDebugDimensions.values().length, this.debugSubscribers(), RemoteDebugSampleType.TICK_TIME);
        long nanos = Util.getNanos();
        this.services.nameToIdCache().resolveOfflineUsers(!this.usesAuthentication());
        LOGGER.info("Preparing level \"{}\"", (Object)this.getLevelIdName());
        this.loadLevel(this.storageSource.getLevelId());
        long l = Util.getNanos() - nanos;
        String string2 = String.format(Locale.ROOT, "%.3fs", (double)l / 1.0E9);
        LOGGER.info("Done preparing level \"{}\" ({})", (Object)this.getLevelIdName(), (Object)string2);
        this.initPostWorld();
        if (properties.announcePlayerAchievements != null) {
            this.getGameRules().getRule(GameRules.RULE_ANNOUNCE_ADVANCEMENTS).set(properties.announcePlayerAchievements, this.overworld());
        }
        if (properties.enableQuery) {
            LOGGER.info("Starting GS4 status listener");
            this.queryThreadGs4 = QueryThreadGs4.create(this);
        }
        if (properties.enableRcon) {
            LOGGER.info("Starting remote control listener");
            this.rconThread = RconThread.create(this);
        }
        if (properties.enableJmxMonitoring) {
            MinecraftServerStatistics.registerJmxMonitoring(this);
            LOGGER.info("JMX monitoring enabled");
        }
        this.notificationManager().serverStarted();
        return true;
    }

    public File getPluginsFolder() {
        return (File)this.options.valueOf("plugins");
    }

    @Override
    public boolean isEnforceWhitelist() {
        return this.settings.getProperties().enforceWhitelist.get();
    }

    @Override
    public void setEnforceWhitelist(boolean enforceWhitelist) {
        this.settings.update(dedicatedServerProperties -> (DedicatedServerProperties)dedicatedServerProperties.enforceWhitelist.update(this.registryAccess(), enforceWhitelist));
    }

    @Override
    public boolean isUsingWhitelist() {
        return this.settings.getProperties().whiteList.get();
    }

    @Override
    public void setUsingWhitelist(boolean usingWhitelist) {
        new WhitelistToggleEvent(usingWhitelist).callEvent();
        this.settings.update(dedicatedServerProperties -> (DedicatedServerProperties)dedicatedServerProperties.whiteList.update(this.registryAccess(), usingWhitelist));
    }

    @Override
    public void tickServer(BooleanSupplier hasTimeLeft) {
        long l;
        super.tickServer(hasTimeLeft);
        if (this.jsonRpcServer != null) {
            this.jsonRpcServer.tick();
        }
        long millis = Util.getMillis();
        int i = this.statusHeartbeatInterval();
        if (i > 0 && millis - this.lastHeartbeat >= (l = (long)i * TimeUtil.MILLISECONDS_PER_SECOND)) {
            this.lastHeartbeat = millis;
            this.notificationManager().statusHeartbeat();
        }
    }

    @Override
    public boolean saveAllChunks(boolean suppressLogs, boolean flush, boolean force) {
        this.notificationManager().serverSaveStarted();
        boolean flag = super.saveAllChunks(suppressLogs, flush, force);
        this.notificationManager().serverSaveCompleted();
        return flag;
    }

    @Override
    public boolean allowFlight() {
        return this.settings.getProperties().allowFlight.get();
    }

    public void setAllowFlight(boolean allowFlight) {
        this.settings.update(dedicatedServerProperties -> (DedicatedServerProperties)dedicatedServerProperties.allowFlight.update(this.registryAccess(), allowFlight));
    }

    @Override
    public DedicatedServerProperties getProperties() {
        return this.settings.getProperties();
    }

    public void setDifficulty(Difficulty difficulty) {
        this.settings.update(dedicatedServerProperties -> (DedicatedServerProperties)dedicatedServerProperties.difficulty.update(this.registryAccess(), difficulty));
        this.forceDifficulty();
    }

    @Override
    public void forceDifficulty() {
    }

    public int viewDistance() {
        return this.settings.getProperties().viewDistance.get();
    }

    public void setViewDistance(int viewDistance) {
        this.settings.update(dedicatedServerProperties -> (DedicatedServerProperties)dedicatedServerProperties.viewDistance.update(this.registryAccess(), viewDistance));
        this.getPlayerList().setViewDistance(viewDistance);
    }

    public int simulationDistance() {
        return this.settings.getProperties().simulationDistance.get();
    }

    public void setSimulationDistance(int simulationDistance) {
        this.settings.update(dedicatedServerProperties -> (DedicatedServerProperties)dedicatedServerProperties.simulationDistance.update(this.registryAccess(), simulationDistance));
        this.getPlayerList().setSimulationDistance(simulationDistance);
    }

    @Override
    public SystemReport fillServerSystemReport(SystemReport report) {
        report.setDetail("Is Modded", () -> this.getModdedStatus().fullDescription());
        report.setDetail("Type", () -> "Dedicated Server (map_server.txt)");
        return report;
    }

    @Override
    public void dumpServerProperties(Path path) throws IOException {
        DedicatedServerProperties properties = this.getProperties();
        try (BufferedWriter bufferedWriter = Files.newBufferedWriter(path, new OpenOption[0]);){
            bufferedWriter.write(String.format(Locale.ROOT, "sync-chunk-writes=%s%n", properties.syncChunkWrites));
            bufferedWriter.write(String.format(Locale.ROOT, "gamemode=%s%n", properties.gameMode.get()));
            bufferedWriter.write(String.format(Locale.ROOT, "entity-broadcast-range-percentage=%d%n", properties.entityBroadcastRangePercentage.get()));
            bufferedWriter.write(String.format(Locale.ROOT, "max-world-size=%d%n", properties.maxWorldSize));
            bufferedWriter.write(String.format(Locale.ROOT, "view-distance=%d%n", properties.viewDistance.get()));
            bufferedWriter.write(String.format(Locale.ROOT, "simulation-distance=%d%n", properties.simulationDistance.get()));
            bufferedWriter.write(String.format(Locale.ROOT, "generate-structures=%s%n", properties.worldOptions.generateStructures()));
            bufferedWriter.write(String.format(Locale.ROOT, "use-native=%s%n", properties.useNativeTransport));
            bufferedWriter.write(String.format(Locale.ROOT, "rate-limit=%d%n", properties.rateLimitPacketsPerSecond));
        }
    }

    @Override
    public void onServerExit() {
        if (this.serverTextFilter != null) {
            this.serverTextFilter.close();
        }
        if (this.gui != null) {
            this.gui.close();
        }
        if (this.rconThread != null) {
            this.rconThread.stopNonBlocking();
        }
        if (this.queryThreadGs4 != null) {
            // empty if block
        }
        if (this.jsonRpcServer != null) {
            try {
                this.jsonRpcServer.stop(true);
            }
            catch (InterruptedException var2) {
                LOGGER.error("Interrupted while stopping the management server", (Throwable)var2);
            }
        }
        this.hasFullyShutdown = true;
        System.exit(this.abnormalExit ? 70 : 0);
    }

    @Override
    public void tickConnection() {
        super.tickConnection();
        this.handleConsoleInputs();
    }

    public void handleConsoleInput(String msg, CommandSourceStack source) {
        if (msg.equalsIgnoreCase("paper debug chunks --async")) {
            LOGGER.info("Scheduling async debug chunks");
            Runnable run = () -> {
                LOGGER.info("Async debug chunks executing");
                ChunkTaskScheduler.dumpAllChunkLoadInfo(this, false);
                ConsoleCommandSender sender = MinecraftServer.getServer().console;
                File file = ChunkTaskScheduler.getChunkDebugFile();
                sender.sendMessage((Component)Component.text((String)("Writing chunk information dump to " + String.valueOf(file)), (TextColor)NamedTextColor.GREEN));
                try {
                    JsonUtil.writeJson((JsonElement)ChunkTaskScheduler.debugAllWorlds(this), file);
                    sender.sendMessage((Component)Component.text((String)"Successfully written chunk information!", (TextColor)NamedTextColor.GREEN));
                }
                catch (Throwable thr) {
                    MinecraftServer.LOGGER.warn("Failed to dump chunk information to file " + file.toString(), thr);
                    sender.sendMessage((Component)Component.text((String)"Failed to dump chunk information, see console", (TextColor)NamedTextColor.RED));
                }
            };
            Thread t = new Thread(run);
            t.setName("Async debug thread #" + ASYNC_DEBUG_CHUNKS_COUNT.getAndIncrement());
            t.setDaemon(true);
            t.start();
            return;
        }
        this.serverCommandQueue.add(new ConsoleInput(msg, source));
    }

    public void handleConsoleInputs() {
        ConsoleInput consoleInput;
        while ((consoleInput = this.serverCommandQueue.poll()) != null) {
            ServerCommandEvent event = new ServerCommandEvent((CommandSender)this.console, consoleInput.msg);
            this.server.getPluginManager().callEvent((Event)event);
            if (event.isCancelled()) continue;
            consoleInput = new ConsoleInput(event.getCommand(), consoleInput.source);
            this.getCommands().performPrefixedCommand(consoleInput.source, consoleInput.msg);
        }
    }

    @Override
    public boolean isDedicatedServer() {
        return true;
    }

    @Override
    public int getRateLimitPacketsPerSecond() {
        return this.getProperties().rateLimitPacketsPerSecond;
    }

    @Override
    public boolean isEpollEnabled() {
        return this.getProperties().useNativeTransport;
    }

    @Override
    public DedicatedPlayerList getPlayerList() {
        return (DedicatedPlayerList)super.getPlayerList();
    }

    @Override
    public int getMaxPlayers() {
        return this.settings.getProperties().maxPlayers.get();
    }

    public void setMaxPlayers(int maxPlayers) {
        this.settings.update(dedicatedServerProperties -> (DedicatedServerProperties)dedicatedServerProperties.maxPlayers.update(this.registryAccess(), maxPlayers));
    }

    @Override
    public boolean isPublished() {
        return true;
    }

    @Override
    public String getServerIp() {
        return this.getLocalIp();
    }

    @Override
    public int getServerPort() {
        return this.getPort();
    }

    @Override
    public String getServerName() {
        return this.getMotd();
    }

    public void showGui() {
        if (this.gui == null) {
            this.gui = MinecraftServerGui.showFrameFor(this);
        }
    }

    @Override
    public boolean hasGui() {
        return this.gui != null;
    }

    public int spawnProtectionRadius() {
        return this.getProperties().spawnProtection.get();
    }

    public void setSpawnProtectionRadius(int radius) {
        this.settings.update(dedicatedServerProperties -> (DedicatedServerProperties)dedicatedServerProperties.spawnProtection.update(this.registryAccess(), radius));
    }

    @Override
    public boolean isUnderSpawnProtection(ServerLevel level, BlockPos pos, Player player) {
        int abs1;
        LevelData.RespawnData respawnData = level.getRespawnData();
        if (level.dimension() != respawnData.dimension()) {
            return false;
        }
        if (this.getPlayerList().getOps().isEmpty()) {
            return false;
        }
        if (this.getPlayerList().isOp(player.nameAndId())) {
            return false;
        }
        if (this.spawnProtectionRadius() <= 0) {
            return false;
        }
        BlockPos blockPos = respawnData.pos();
        int abs = Mth.abs(pos.getX() - blockPos.getX());
        int max = Math.max(abs, abs1 = Mth.abs(pos.getZ() - blockPos.getZ()));
        return max <= this.spawnProtectionRadius();
    }

    @Override
    public boolean repliesToStatus() {
        return this.getProperties().enableStatus.get();
    }

    public void setRepliesToStatus(boolean repliesToStatus) {
        this.settings.update(dedicatedServerProperties -> (DedicatedServerProperties)dedicatedServerProperties.enableStatus.update(this.registryAccess(), repliesToStatus));
    }

    @Override
    public boolean hidesOnlinePlayers() {
        return this.getProperties().hideOnlinePlayers.get();
    }

    public void setHidesOnlinePlayers(boolean hidesOnlinePlayers) {
        this.settings.update(dedicatedServerProperties -> (DedicatedServerProperties)dedicatedServerProperties.hideOnlinePlayers.update(this.registryAccess(), hidesOnlinePlayers));
    }

    @Override
    public int operatorUserPermissionLevel() {
        return this.getProperties().opPermissionLevel.get();
    }

    public void setOperatorUserPermissionLevel(int operatorUserPermissionLevel) {
        this.settings.update(dedicatedServerProperties -> (DedicatedServerProperties)dedicatedServerProperties.opPermissionLevel.update(this.registryAccess(), operatorUserPermissionLevel));
    }

    @Override
    public int getFunctionCompilationLevel() {
        return this.getProperties().functionPermissionLevel;
    }

    @Override
    public int playerIdleTimeout() {
        return this.settings.getProperties().playerIdleTimeout.get();
    }

    @Override
    public void setPlayerIdleTimeout(int idleTimeout) {
        this.settings.update(dedicatedServerProperties -> (DedicatedServerProperties)dedicatedServerProperties.playerIdleTimeout.update(this.registryAccess(), idleTimeout));
    }

    public int statusHeartbeatInterval() {
        return this.settings.getProperties().statusHeartbeatInterval.get();
    }

    public void setStatusHeartbeatInterval(int heartbeatInterval) {
        this.settings.update(dedicatedServerProperties -> (DedicatedServerProperties)dedicatedServerProperties.statusHeartbeatInterval.update(this.registryAccess(), heartbeatInterval));
    }

    @Override
    public String getMotd() {
        return super.getMotd();
    }

    @Override
    public void setMotd(String motd) {
        super.setMotd(motd);
        this.settings.update(dedicatedServerProperties -> (DedicatedServerProperties)dedicatedServerProperties.motd.update(this.registryAccess(), this.getMotd()));
    }

    @Override
    public boolean shouldRconBroadcast() {
        return this.getProperties().broadcastRconToOps;
    }

    @Override
    public boolean shouldInformAdmins() {
        return this.getProperties().broadcastConsoleToOps;
    }

    @Override
    public int getAbsoluteMaxWorldSize() {
        return this.getProperties().maxWorldSize;
    }

    @Override
    public int getCompressionThreshold() {
        return this.getProperties().networkCompressionThreshold;
    }

    @Override
    public boolean enforceSecureProfile() {
        DedicatedServerProperties properties = this.getProperties();
        return properties.enforceSecureProfile && GlobalConfiguration.get().proxies.isProxyOnlineMode() && this.services.canValidateProfileKeys();
    }

    @Override
    public boolean logIPs() {
        return this.getProperties().logIPs;
    }

    protected boolean convertOldUsers() {
        boolean flag = false;
        for (int i = 0; !flag && i <= 2; ++i) {
            if (i > 0) {
                LOGGER.warn("Encountered a problem while converting the user banlist, retrying in a few seconds");
                this.waitForRetry();
            }
            flag = OldUsersConverter.convertUserBanlist(this);
        }
        boolean flag1 = false;
        for (int var7 = 0; !flag1 && var7 <= 2; ++var7) {
            if (var7 > 0) {
                LOGGER.warn("Encountered a problem while converting the ip banlist, retrying in a few seconds");
                this.waitForRetry();
            }
            flag1 = OldUsersConverter.convertIpBanlist(this);
        }
        boolean flag2 = false;
        for (int var8 = 0; !flag2 && var8 <= 2; ++var8) {
            if (var8 > 0) {
                LOGGER.warn("Encountered a problem while converting the op list, retrying in a few seconds");
                this.waitForRetry();
            }
            flag2 = OldUsersConverter.convertOpsList(this);
        }
        boolean flag3 = false;
        for (int var9 = 0; !flag3 && var9 <= 2; ++var9) {
            if (var9 > 0) {
                LOGGER.warn("Encountered a problem while converting the whitelist, retrying in a few seconds");
                this.waitForRetry();
            }
            flag3 = OldUsersConverter.convertWhiteList(this);
        }
        boolean flag4 = false;
        for (int var10 = 0; !flag4 && var10 <= 2; ++var10) {
            if (var10 > 0) {
                LOGGER.warn("Encountered a problem while converting the player save files, retrying in a few seconds");
                this.waitForRetry();
            }
            flag4 = OldUsersConverter.convertPlayers(this);
        }
        return flag || flag1 || flag2 || flag3 || flag4;
    }

    private void waitForRetry() {
        try {
            Thread.sleep(5000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public long getMaxTickLength() {
        return this.getProperties().maxTickTime;
    }

    @Override
    public int getMaxChainedNeighborUpdates() {
        return this.getProperties().maxChainedNeighborUpdates;
    }

    @Override
    public String getPluginNames() {
        StringBuilder result = new StringBuilder();
        Plugin[] plugins = this.server.getPluginManager().getPlugins();
        result.append(this.server.getName());
        result.append(" on Bukkit ");
        result.append(this.server.getBukkitVersion());
        if (plugins.length > 0 && this.server.getQueryPlugins()) {
            result.append(": ");
            for (int i = 0; i < plugins.length; ++i) {
                if (i > 0) {
                    result.append("; ");
                }
                result.append(plugins[i].getDescription().getName());
                result.append(" ");
                result.append(plugins[i].getDescription().getVersion().replaceAll(";", ","));
            }
        }
        return result.toString();
    }

    @Override
    public String runCommand(String command) {
        throw new UnsupportedOperationException("Not supported - remote source required.");
    }

    public String runCommand(RconConsoleSource rconConsoleSource, String s) {
        if (s.isBlank()) {
            return "";
        }
        rconConsoleSource.prepareForCommand();
        this.executeBlocking(() -> {
            CommandSourceStack wrapper = rconConsoleSource.createCommandSourceStack();
            RemoteServerCommandEvent event = new RemoteServerCommandEvent(rconConsoleSource.getBukkitSender(wrapper), s);
            this.server.getPluginManager().callEvent((Event)event);
            if (event.isCancelled()) {
                return;
            }
            this.getCommands().performPrefixedCommand(wrapper, event.getCommand());
        });
        return rconConsoleSource.getCommandResponse();
    }

    @Override
    public void stopServer() {
        this.notificationManager().serverShuttingDown();
        super.stopServer();
    }

    @Override
    public boolean isSingleplayerOwner(NameAndId nameAndId) {
        return false;
    }

    @Override
    public int getScaledTrackingDistance(int trackingDistance) {
        return this.entityBroadcastRangePercentage() * trackingDistance / 100;
    }

    public int entityBroadcastRangePercentage() {
        return this.getProperties().entityBroadcastRangePercentage.get();
    }

    public void setEntityBroadcastRangePercentage(int entityBroadcastRangePercentage) {
        this.settings.update(dedicatedServerProperties -> (DedicatedServerProperties)dedicatedServerProperties.entityBroadcastRangePercentage.update(this.registryAccess(), entityBroadcastRangePercentage));
    }

    @Override
    public String getLevelIdName() {
        return this.storageSource.getLevelId();
    }

    @Override
    public boolean forceSynchronousWrites() {
        return this.settings.getProperties().syncChunkWrites;
    }

    @Override
    public TextFilter createTextFilterForPlayer(ServerPlayer player) {
        return this.serverTextFilter != null ? this.serverTextFilter.createContext(player.getGameProfile()) : TextFilter.DUMMY;
    }

    @Override
    @Nullable
    public GameType getForcedGameType() {
        return this.forceGameMode() ? this.worldData.getGameType() : null;
    }

    public boolean forceGameMode() {
        return this.settings.getProperties().forceGameMode.get();
    }

    public void setForceGameMode(boolean forceGameMode) {
        this.settings.update(dedicatedServerProperties -> (DedicatedServerProperties)dedicatedServerProperties.forceGameMode.update(this.registryAccess(), forceGameMode));
        this.enforceGameTypeForPlayers(this.getForcedGameType());
    }

    public GameType gameMode() {
        return this.getProperties().gameMode.get();
    }

    public void setGameMode(GameType gameMode) {
        this.settings.update(dedicatedServerProperties -> (DedicatedServerProperties)dedicatedServerProperties.gameMode.update(this.registryAccess(), gameMode));
        this.worldData.setGameType(this.gameMode());
        this.enforceGameTypeForPlayers(this.getForcedGameType());
    }

    @Override
    public Optional<MinecraftServer.ServerResourcePackInfo> getServerResourcePack() {
        return this.settings.getProperties().serverResourcePackInfo;
    }

    @Override
    public void endMetricsRecordingTick() {
        super.endMetricsRecordingTick();
        this.isTickTimeLoggingEnabled = this.debugSubscribers().hasAnySubscriberFor(DebugSubscriptions.DEDICATED_SERVER_TICK_TIME);
    }

    @Override
    public SampleLogger getTickTimeLogger() {
        return this.tickTimeLogger;
    }

    @Override
    public boolean isTickTimeLoggingEnabled() {
        return this.isTickTimeLoggingEnabled;
    }

    @Override
    public boolean acceptsTransfers() {
        return this.settings.getProperties().acceptsTransfers.get();
    }

    public void setAcceptsTransfers(boolean acceptsTransfers) {
        this.settings.update(dedicatedServerProperties -> (DedicatedServerProperties)dedicatedServerProperties.acceptsTransfers.update(this.registryAccess(), acceptsTransfers));
    }

    @Override
    public ServerLinks serverLinks() {
        return this.serverLinks;
    }

    @Override
    public int pauseWhenEmptySeconds() {
        return this.settings.getProperties().pauseWhenEmptySeconds.get();
    }

    public void setPauseWhenEmptySeconds(int pauseWhenEmptySeconds) {
        this.settings.update(dedicatedServerProperties -> (DedicatedServerProperties)dedicatedServerProperties.pauseWhenEmptySeconds.update(this.registryAccess(), pauseWhenEmptySeconds));
    }

    private static ServerLinks createServerLinks(DedicatedServerSettings settings) {
        Optional<URI> optional = DedicatedServer.parseBugReportLink(settings.getProperties());
        return optional.map(uri -> new ServerLinks(List.of(ServerLinks.KnownLinkType.BUG_REPORT.create((URI)uri)))).orElse(ServerLinks.EMPTY);
    }

    private static Optional<URI> parseBugReportLink(DedicatedServerProperties properties) {
        String string = properties.bugReportLink;
        if (string.isEmpty()) {
            return Optional.empty();
        }
        try {
            return Optional.of(Util.parseAndValidateUntrustedUri(string));
        }
        catch (Exception var3) {
            LOGGER.warn("Failed to parse bug link {}", (Object)string, (Object)var3);
            return Optional.empty();
        }
    }

    @Override
    public Map<String, String> getCodeOfConducts() {
        return this.codeOfConductTexts;
    }

    @Override
    public boolean isDebugging() {
        return this.getProperties().debug;
    }

    @Override
    public CommandSender getBukkitSender(CommandSourceStack wrapper) {
        return this.console;
    }
}

