/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.jsonrpc.methods;

import com.google.common.net.InetAddresses;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.time.Instant;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.network.chat.Component;
import net.minecraft.server.jsonrpc.api.PlayerDto;
import net.minecraft.server.jsonrpc.internalapi.MinecraftApi;
import net.minecraft.server.jsonrpc.methods.ClientInfo;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.players.IpBanListEntry;
import net.minecraft.util.ExtraCodecs;

public class IpBanlistService {
    private static final String BAN_SOURCE = "Management server";

    public static List<IpBanDto> get(MinecraftApi api) {
        return api.banListService().getIpBanEntries().stream().map(IpBan::from).map(IpBanDto::from).toList();
    }

    public static List<IpBanDto> add(MinecraftApi api, List<IncomingIpBanDto> ipBan, ClientInfo client) {
        ipBan.stream().map(incomingIpBanDto -> IpBanlistService.banIp(api, incomingIpBanDto, client)).flatMap(Collection::stream).forEach(serverPlayer -> serverPlayer.connection.disconnect(Component.translatable("multiplayer.disconnect.ip_banned")));
        return IpBanlistService.get(api);
    }

    private static List<ServerPlayer> banIp(MinecraftApi api, IncomingIpBanDto ipBan, ClientInfo client) {
        Optional<ServerPlayer> player;
        IpBan ipBan1 = ipBan.toIpBan();
        if (ipBan1 != null) {
            return IpBanlistService.banIp(api, ipBan1, client);
        }
        if (ipBan.player().isPresent() && (player = api.playerListService().getPlayer(ipBan.player().get().id(), ipBan.player().get().name())).isPresent()) {
            return IpBanlistService.banIp(api, ipBan.toIpBan(player.get()), client);
        }
        return List.of();
    }

    private static List<ServerPlayer> banIp(MinecraftApi api, IpBan ipBan, ClientInfo client) {
        api.banListService().addIpBan(ipBan.toIpBanEntry(), client);
        return api.playerListService().getPlayersWithAddress(ipBan.ip());
    }

    public static List<IpBanDto> clear(MinecraftApi api, ClientInfo client) {
        api.banListService().clearIpBans(client);
        return IpBanlistService.get(api);
    }

    public static List<IpBanDto> remove(MinecraftApi api, List<String> ips, ClientInfo client) {
        ips.forEach(string -> api.banListService().removeIpBan((String)string, client));
        return IpBanlistService.get(api);
    }

    public static List<IpBanDto> set(MinecraftApi api, List<IpBanDto> ipBans, ClientInfo client) {
        Set set = ipBans.stream().filter(ipBanDto -> InetAddresses.isInetAddress((String)ipBanDto.ip())).map(IpBanDto::toIpBan).collect(Collectors.toSet());
        Set set1 = api.banListService().getIpBanEntries().stream().map(IpBan::from).collect(Collectors.toSet());
        set1.stream().filter(ipBan -> !set.contains(ipBan)).forEach(ipBan -> api.banListService().removeIpBan(ipBan.ip(), client));
        set.stream().filter(ipBan -> !set1.contains(ipBan)).forEach(ipBan -> api.banListService().addIpBan(ipBan.toIpBanEntry(), client));
        set.stream().filter(ipBan -> !set1.contains(ipBan)).flatMap(ipBan -> api.playerListService().getPlayersWithAddress(ipBan.ip()).stream()).forEach(serverPlayer -> serverPlayer.connection.disconnect(Component.translatable("multiplayer.disconnect.ip_banned")));
        return IpBanlistService.get(api);
    }

    public record IncomingIpBanDto(Optional<PlayerDto> player, Optional<String> ip, Optional<String> reason, Optional<String> source, Optional<Instant> expires) {
        public static final MapCodec<IncomingIpBanDto> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)PlayerDto.CODEC.codec().optionalFieldOf("player").forGetter(IncomingIpBanDto::player), (App)Codec.STRING.optionalFieldOf("ip").forGetter(IncomingIpBanDto::ip), (App)Codec.STRING.optionalFieldOf("reason").forGetter(IncomingIpBanDto::reason), (App)Codec.STRING.optionalFieldOf("source").forGetter(IncomingIpBanDto::source), (App)ExtraCodecs.INSTANT_ISO8601.optionalFieldOf("expires").forGetter(IncomingIpBanDto::expires)).apply((Applicative)instance, IncomingIpBanDto::new));

        IpBan toIpBan(ServerPlayer player) {
            return new IpBan(player.getIpAddress(), this.reason().orElse(null), this.source().orElse(IpBanlistService.BAN_SOURCE), this.expires());
        }

        @Nullable
        IpBan toIpBan() {
            return !this.ip().isEmpty() && InetAddresses.isInetAddress((String)this.ip().get()) ? new IpBan(this.ip().get(), this.reason().orElse(null), this.source().orElse(IpBanlistService.BAN_SOURCE), this.expires()) : null;
        }
    }

    record IpBan(String ip, @Nullable String reason, String source, Optional<Instant> expires) {
        static IpBan from(IpBanListEntry entry) {
            return new IpBan(Objects.requireNonNull((String)entry.getUser()), entry.getReason(), entry.getSource(), Optional.ofNullable(entry.getExpires()).map(Date::toInstant));
        }

        IpBanListEntry toIpBanEntry() {
            return new IpBanListEntry(this.ip(), null, this.source(), (Date)this.expires().map(Date::from).orElse(null), this.reason());
        }
    }

    public record IpBanDto(String ip, Optional<String> reason, Optional<String> source, Optional<Instant> expires) {
        public static final MapCodec<IpBanDto> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.STRING.fieldOf("ip").forGetter(IpBanDto::ip), (App)Codec.STRING.optionalFieldOf("reason").forGetter(IpBanDto::reason), (App)Codec.STRING.optionalFieldOf("source").forGetter(IpBanDto::source), (App)ExtraCodecs.INSTANT_ISO8601.optionalFieldOf("expires").forGetter(IpBanDto::expires)).apply((Applicative)instance, IpBanDto::new));

        private static IpBanDto from(IpBan ipBan) {
            return new IpBanDto(ipBan.ip(), Optional.ofNullable(ipBan.reason()), Optional.of(ipBan.source()), ipBan.expires());
        }

        public static IpBanDto from(IpBanListEntry entry) {
            return IpBanDto.from(IpBan.from(entry));
        }

        private IpBan toIpBan() {
            return new IpBan(this.ip(), this.reason().orElse(null), this.source().orElse(IpBanlistService.BAN_SOURCE), this.expires());
        }
    }
}

