/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.jsonrpc.security;

import com.mojang.logging.LogUtils;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.util.AttributeKey;
import java.net.InetSocketAddress;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import net.minecraft.server.jsonrpc.security.SecurityConfig;
import org.slf4j.Logger;

@ChannelHandler.Sharable
public class AuthenticationHandler
extends ChannelInboundHandlerAdapter {
    private final Logger LOGGER = LogUtils.getLogger();
    private static final AttributeKey<Boolean> AUTHENTICATED_KEY = AttributeKey.valueOf((String)"authenticated");
    public static final String AUTH_HEADER = "Authorization";
    public static final String BEARER_PREFIX = "Bearer ";
    private final SecurityConfig securityConfig;

    public AuthenticationHandler(SecurityConfig securityConfig) {
        this.securityConfig = securityConfig;
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        Boolean _boolean;
        String clientIp = this.getClientIp(ctx);
        if (msg instanceof HttpRequest) {
            HttpRequest httpRequest = (HttpRequest)msg;
            SecurityCheckResult securityCheckResult = this.performSecurityChecks(httpRequest);
            if (!securityCheckResult.isAllowed()) {
                this.LOGGER.debug("Authentication rejected for connection with ip {}: {}", (Object)clientIp, (Object)securityCheckResult.getReason());
                ctx.channel().attr(AUTHENTICATED_KEY).set((Object)false);
                this.sendUnauthorizedResponse(ctx, securityCheckResult.getReason());
                return;
            }
            ctx.channel().attr(AUTHENTICATED_KEY).set((Object)true);
        }
        if (Boolean.TRUE.equals(_boolean = (Boolean)ctx.channel().attr(AUTHENTICATED_KEY).get())) {
            super.channelRead(ctx, msg);
        } else {
            this.LOGGER.debug("Dropping unauthenticated connection with ip {}", (Object)clientIp);
            ctx.close();
        }
    }

    private SecurityCheckResult performSecurityChecks(HttpRequest request) {
        return !this.validateAuthentication(request) ? SecurityCheckResult.denied("Invalid or missing API key") : SecurityCheckResult.allowed();
    }

    private boolean validateAuthentication(HttpRequest request) {
        String string = request.headers().get(AUTH_HEADER);
        if (string == null || string.trim().isEmpty()) {
            return false;
        }
        if (string.startsWith(BEARER_PREFIX)) {
            String trimmed = string.substring(BEARER_PREFIX.length()).trim();
            return this.isValidApiKey(trimmed);
        }
        return false;
    }

    public boolean isValidApiKey(String key) {
        if (key != null && !key.isEmpty()) {
            byte[] bytes = key.getBytes(StandardCharsets.UTF_8);
            byte[] bytes1 = this.securityConfig.secretKey().getBytes(StandardCharsets.UTF_8);
            return MessageDigest.isEqual(bytes, bytes1);
        }
        return false;
    }

    private String getClientIp(ChannelHandlerContext ctx) {
        InetSocketAddress inetSocketAddress = (InetSocketAddress)ctx.channel().remoteAddress();
        return inetSocketAddress.getAddress().getHostAddress();
    }

    private void sendUnauthorizedResponse(ChannelHandlerContext ctx, String message) {
        String string = "{\"error\":\"Unauthorized\",\"message\":\"" + message + "\"}";
        byte[] bytes = string.getBytes(StandardCharsets.UTF_8);
        DefaultFullHttpResponse defaultFullHttpResponse = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.UNAUTHORIZED, Unpooled.wrappedBuffer((byte[])bytes));
        defaultFullHttpResponse.headers().set((CharSequence)HttpHeaderNames.CONTENT_TYPE, (Object)"application/json");
        defaultFullHttpResponse.headers().set((CharSequence)HttpHeaderNames.CONTENT_LENGTH, (Object)bytes.length);
        defaultFullHttpResponse.headers().set((CharSequence)HttpHeaderNames.CONNECTION, (Object)"close");
        ctx.writeAndFlush((Object)defaultFullHttpResponse).addListener(future -> ctx.close());
    }

    static class SecurityCheckResult {
        private final boolean allowed;
        private final String reason;

        private SecurityCheckResult(boolean allowed, String reason) {
            this.allowed = allowed;
            this.reason = reason;
        }

        public static SecurityCheckResult allowed() {
            return new SecurityCheckResult(true, null);
        }

        public static SecurityCheckResult denied(String reason) {
            return new SecurityCheckResult(false, reason);
        }

        public boolean isAllowed() {
            return this.allowed;
        }

        public String getReason() {
            return this.reason;
        }
    }
}

