/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.level;

import ca.spottedleaf.moonrise.common.PlatformHooks;
import ca.spottedleaf.moonrise.patches.chunk_system.ticket.ChunkSystemTicketType;
import java.util.Comparator;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicLong;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;

public final class TicketType<T>
implements ChunkSystemTicketType<T> {
    private static final AtomicLong ID_GENERATOR = new AtomicLong();
    private final long id = ID_GENERATOR.getAndIncrement();
    private Comparator<T> identifierComparator;
    private volatile long[] counterTypes;
    public static final long NO_TIMEOUT = 0L;
    public static final int FLAG_PERSIST = 1;
    public static final int FLAG_LOADING = 2;
    public static final int FLAG_SIMULATION = 4;
    public static final int FLAG_KEEP_DIMENSION_ACTIVE = 8;
    public static final int FLAG_CAN_EXPIRE_IF_UNLOADED = 16;
    public static final TicketType PLAYER_SPAWN = TicketType.register("player_spawn", 20L, 2);
    public static final TicketType SPAWN_SEARCH = TicketType.register("spawn_search", 1L, 2);
    public static final TicketType DRAGON = TicketType.register("dragon", 0L, 6);
    public static final TicketType PLAYER_LOADING = TicketType.register("player_loading", 0L, 2);
    public static final TicketType PLAYER_SIMULATION = TicketType.register("player_simulation", 0L, 12);
    public static final TicketType FORCED = TicketType.register("forced", 0L, 15);
    public static final TicketType PORTAL = TicketType.register("portal", 300L, 15);
    public static final TicketType ENDER_PEARL = TicketType.register("ender_pearl", 40L, 14);
    public static final TicketType UNKNOWN = TicketType.register("unknown", 1L, 18);
    public static final TicketType PLUGIN = TicketType.register("plugin", 0L, 6);
    public static final TicketType POST_TELEPORT = TicketType.register("post_teleport", 5L, 6);
    public static final TicketType PLUGIN_TICKET = TicketType.register("plugin_ticket", 0L, 6);
    public static final TicketType FUTURE_AWAIT;
    public static final TicketType CHUNK_LOAD;
    private long timeout;
    private final int flags;
    public static int PLUGIN_TYPE_TIMEOUT;

    @Override
    public final long moonrise$getId() {
        return this.id;
    }

    @Override
    public final Comparator<T> moonrise$getIdentifierComparator() {
        return this.identifierComparator;
    }

    @Override
    public final void moonrise$setIdentifierComparator(Comparator<T> comparator) {
        this.identifierComparator = comparator;
    }

    @Override
    public final long[] moonrise$getCounterTypes() {
        long[] types = this.counterTypes;
        if (types != null) {
            return types;
        }
        this.counterTypes = PlatformHooks.get().getCounterTypesUncached(this);
        return this.counterTypes;
    }

    @Override
    public final void moonrise$setTimeout(long to) {
        this.timeout = to;
    }

    private static TicketType register(String name, long timeout, int flags) {
        return Registry.register(BuiltInRegistries.TICKET_TYPE, name, new TicketType(timeout, flags));
    }

    public boolean persist() {
        return (this.flags & 1) != 0;
    }

    public boolean doesLoad() {
        return (this.flags & 2) != 0;
    }

    public boolean doesSimulate() {
        return (this.flags & 4) != 0;
    }

    public boolean shouldKeepDimensionActive() {
        return (this.flags & 8) != 0;
    }

    public boolean canExpireIfUnloaded() {
        return (this.flags & 0x10) != 0;
    }

    public TicketType(long timeout, int flags) {
        this.timeout = timeout;
        this.flags = flags;
    }

    public int flags() {
        return this.flags;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        TicketType that = (TicketType)obj;
        return this.timeout == that.timeout && this.flags == that.flags;
    }

    public int hashCode() {
        return Objects.hash(this.timeout, this.flags);
    }

    public String toString() {
        return "TicketType[timeout=" + this.timeout + ", flags=" + this.flags + "]";
    }

    public long timeout() {
        return this == PLUGIN ? (long)PLUGIN_TYPE_TIMEOUT : this.timeout;
    }

    public boolean hasTimeout() {
        return this.timeout() != 0L;
    }

    static {
        PLUGIN_TICKET.moonrise$setIdentifierComparator((p1, p2) -> p1.getName().compareTo(p2.getName()));
        FUTURE_AWAIT = TicketType.register("future_await", 0L, 6);
        CHUNK_LOAD = TicketType.register("chunk_load", 0L, 2);
        PLUGIN_TYPE_TIMEOUT = 600;
    }
}

