/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.packs;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Sets;
import com.mojang.logging.LogUtils;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.AbstractPackResources;
import net.minecraft.server.packs.CompositePackResources;
import net.minecraft.server.packs.PackLocationInfo;
import net.minecraft.server.packs.PackResources;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.repository.Pack;
import net.minecraft.server.packs.resources.IoSupplier;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;

public class FilePackResources
extends AbstractPackResources {
    static final Logger LOGGER = LogUtils.getLogger();
    private final SharedZipFileAccess zipFileAccess;
    private final String prefix;

    FilePackResources(PackLocationInfo location, SharedZipFileAccess zipFileAccess, String prefix) {
        super(location);
        this.zipFileAccess = zipFileAccess;
        this.prefix = prefix;
    }

    private static String getPathFromLocation(PackType packType, ResourceLocation location) {
        return String.format(Locale.ROOT, "%s/%s/%s", packType.getDirectory(), location.getNamespace(), location.getPath());
    }

    @Override
    @Nullable
    public IoSupplier<InputStream> getRootResource(String ... elements) {
        return this.getResource(String.join((CharSequence)"/", elements));
    }

    @Override
    public IoSupplier<InputStream> getResource(PackType packType, ResourceLocation location) {
        return this.getResource(FilePackResources.getPathFromLocation(packType, location));
    }

    private String addPrefix(String resourcePath) {
        return this.prefix.isEmpty() ? resourcePath : this.prefix + "/" + resourcePath;
    }

    @Nullable
    private IoSupplier<InputStream> getResource(String resourcePath) {
        ZipFile zipFile = this.zipFileAccess.getOrCreateZipFile();
        if (zipFile == null) {
            return null;
        }
        ZipEntry entry = zipFile.getEntry(this.addPrefix(resourcePath));
        return entry == null ? null : IoSupplier.create(zipFile, entry);
    }

    @Override
    public Set<String> getNamespaces(PackType type) {
        ZipFile zipFile = this.zipFileAccess.getOrCreateZipFile();
        if (zipFile == null) {
            return Set.of();
        }
        Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
        HashSet set = Sets.newHashSet();
        String string = this.addPrefix(type.getDirectory() + "/");
        while (enumeration.hasMoreElements()) {
            ZipEntry zipEntry = enumeration.nextElement();
            String name = zipEntry.getName();
            String string1 = FilePackResources.extractNamespace(string, name);
            if (string1.isEmpty()) continue;
            if (ResourceLocation.isValidNamespace(string1)) {
                set.add(string1);
                continue;
            }
            LOGGER.warn("Non [a-z0-9_.-] character in namespace {} in pack {}, ignoring", (Object)string1, (Object)this.zipFileAccess.file);
        }
        return set;
    }

    @VisibleForTesting
    public static String extractNamespace(String directory, String name) {
        if (!name.startsWith(directory)) {
            return "";
        }
        int len = directory.length();
        int index = name.indexOf(47, len);
        return index == -1 ? name.substring(len) : name.substring(len, index);
    }

    @Override
    public void close() {
        this.zipFileAccess.close();
    }

    @Override
    public void listResources(PackType packType, String namespace, String path, PackResources.ResourceOutput resourceOutput) {
        ZipFile zipFile = this.zipFileAccess.getOrCreateZipFile();
        if (zipFile != null) {
            Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
            String string = this.addPrefix(packType.getDirectory() + "/" + namespace + "/");
            String string1 = string + path + "/";
            while (enumeration.hasMoreElements()) {
                String name;
                ZipEntry zipEntry = enumeration.nextElement();
                if (zipEntry.isDirectory() || !(name = zipEntry.getName()).startsWith(string1)) continue;
                String sub = name.substring(string.length());
                ResourceLocation resourceLocation = ResourceLocation.tryBuild(namespace, sub);
                if (resourceLocation != null) {
                    resourceOutput.accept(resourceLocation, IoSupplier.create(zipFile, zipEntry));
                    continue;
                }
                LOGGER.warn("Invalid path in datapack: {}:{}, ignoring", (Object)namespace, (Object)sub);
            }
        }
    }

    static class SharedZipFileAccess
    implements AutoCloseable {
        final File file;
        @Nullable
        private ZipFile zipFile;
        private boolean failedToLoad;

        SharedZipFileAccess(File file) {
            this.file = file;
        }

        @Nullable
        ZipFile getOrCreateZipFile() {
            if (this.failedToLoad) {
                return null;
            }
            if (this.zipFile == null) {
                try {
                    this.zipFile = new ZipFile(this.file);
                }
                catch (IOException var2) {
                    LOGGER.error("Failed to open pack {}", (Object)this.file, (Object)var2);
                    this.failedToLoad = true;
                    return null;
                }
            }
            return this.zipFile;
        }

        @Override
        public void close() {
            if (this.zipFile != null) {
                IOUtils.closeQuietly((Closeable)this.zipFile);
                this.zipFile = null;
            }
        }

        protected void finalize() throws Throwable {
            this.close();
            super.finalize();
        }
    }

    public static class FileResourcesSupplier
    implements Pack.ResourcesSupplier {
        private final File content;

        public FileResourcesSupplier(Path content) {
            this(content.toFile());
        }

        public FileResourcesSupplier(File content) {
            this.content = content;
        }

        @Override
        public PackResources openPrimary(PackLocationInfo location) {
            SharedZipFileAccess sharedZipFileAccess = new SharedZipFileAccess(this.content);
            return new FilePackResources(location, sharedZipFileAccess, "");
        }

        @Override
        public PackResources openFull(PackLocationInfo location, Pack.Metadata metadata) {
            SharedZipFileAccess sharedZipFileAccess = new SharedZipFileAccess(this.content);
            FilePackResources packResources = new FilePackResources(location, sharedZipFileAccess, "");
            List<String> list = metadata.overlays();
            if (list.isEmpty()) {
                return packResources;
            }
            ArrayList<PackResources> list1 = new ArrayList<PackResources>(list.size());
            for (String string : list) {
                list1.add(new FilePackResources(location, sharedZipFileAccess, string));
            }
            return new CompositePackResources(packResources, list1);
        }
    }
}

