/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.players;

import com.destroystokyo.paper.profile.CraftPlayerProfile;
import com.google.gson.JsonObject;
import io.papermc.paper.event.server.WhitelistStateUpdateEvent;
import java.io.File;
import java.util.Objects;
import net.minecraft.server.notifications.NotificationService;
import net.minecraft.server.players.NameAndId;
import net.minecraft.server.players.StoredUserEntry;
import net.minecraft.server.players.StoredUserList;
import net.minecraft.server.players.UserWhiteListEntry;

public class UserWhiteList
extends StoredUserList<NameAndId, UserWhiteListEntry> {
    public UserWhiteList(File file, NotificationService notificationService) {
        super(file, notificationService);
    }

    @Override
    protected StoredUserEntry<NameAndId> createEntry(JsonObject entryData) {
        return new UserWhiteListEntry(entryData);
    }

    public boolean isWhiteListed(NameAndId nameAndId) {
        return this.contains(nameAndId);
    }

    @Override
    public boolean add(UserWhiteListEntry entry) {
        if (!new WhitelistStateUpdateEvent(CraftPlayerProfile.asBukkitCopy(((NameAndId)entry.getUser()).toUncompletedGameProfile()), WhitelistStateUpdateEvent.WhitelistStatus.ADDED).callEvent()) {
            return false;
        }
        if (super.add(entry)) {
            if (entry.getUser() != null) {
                this.notificationService.playerAddedToAllowlist((NameAndId)entry.getUser());
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean remove(NameAndId user) {
        if (!new WhitelistStateUpdateEvent(CraftPlayerProfile.asBukkitCopy(user.toUncompletedGameProfile()), WhitelistStateUpdateEvent.WhitelistStatus.REMOVED).callEvent()) {
            return false;
        }
        if (super.remove(user)) {
            this.notificationService.playerRemovedFromAllowlist(user);
            return true;
        }
        return false;
    }

    @Override
    public void clear() {
        for (UserWhiteListEntry userWhiteListEntry : this.getEntries()) {
            if (userWhiteListEntry.getUser() == null) continue;
            this.notificationService.playerRemovedFromAllowlist((NameAndId)userWhiteListEntry.getUser());
        }
        super.clear();
    }

    @Override
    public String[] getUserList() {
        return (String[])this.getEntries().stream().map(StoredUserEntry::getUser).filter(Objects::nonNull).map(NameAndId::name).toArray(String[]::new);
    }

    @Override
    protected String getKeyForUser(NameAndId user) {
        return user.id().toString();
    }
}

