/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.util.ExtraCodecs;

public record Brightness(int block, int sky) {
    public static final Codec<Integer> LIGHT_VALUE_CODEC = ExtraCodecs.intRange(0, 15);
    public static final Codec<Brightness> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)LIGHT_VALUE_CODEC.fieldOf("block").forGetter(Brightness::block), (App)LIGHT_VALUE_CODEC.fieldOf("sky").forGetter(Brightness::sky)).apply((Applicative)instance, Brightness::new));
    public static final Brightness FULL_BRIGHT = new Brightness(15, 15);

    public static int pack(int block, int sky) {
        return block << 4 | sky << 20;
    }

    public int pack() {
        return Brightness.pack(this.block, this.sky);
    }

    public static int block(int packed) {
        return packed >> 4 & 0xFFFF;
    }

    public static int sky(int packed) {
        return packed >> 20 & 0xFFFF;
    }

    public static Brightness unpack(int packedBrightness) {
        return new Brightness(Brightness.block(packedBrightness), Brightness.sky(packedBrightness));
    }
}

