/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import net.minecraft.nbt.Tag;

public class EncoderCache {
    final LoadingCache<Key<?, ?>, DataResult<?>> cache;

    public EncoderCache(int maxSize) {
        this.cache = CacheBuilder.newBuilder().maximumSize((long)maxSize).concurrencyLevel(1).softValues().build(new CacheLoader<Key<?, ?>, DataResult<?>>(this){

            public DataResult<?> load(Key<?, ?> key) {
                return key.resolve();
            }
        });
    }

    public <A> Codec<A> wrap(final Codec<A> codec) {
        return new Codec<A>(){

            public <T> DataResult<Pair<A, T>> decode(DynamicOps<T> ops, T input) {
                return codec.decode(ops, input);
            }

            public <T> DataResult<T> encode(A input, DynamicOps<T> ops, T value) {
                return ((DataResult)EncoderCache.this.cache.getUnchecked(new Key(codec, input, ops))).map(object -> {
                    Object object2;
                    if (object instanceof Tag) {
                        Tag tag = (Tag)object;
                        object2 = tag.copy();
                    } else {
                        object2 = object;
                    }
                    return object2;
                });
            }
        };
    }

    record Key<A, T>(Codec<A> codec, A value, DynamicOps<T> ops) {
        public DataResult<T> resolve() {
            return this.codec.encodeStart(this.ops, this.value);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean equals(Object other) {
            if (this == other) return true;
            if (!(other instanceof Key)) return false;
            Key key = (Key)other;
            if (this.codec != key.codec) return false;
            if (!this.value.equals(key.value)) return false;
            if (!this.ops.equals(key.ops)) return false;
            return true;
        }

        @Override
        public int hashCode() {
            int i = System.identityHashCode(this.codec);
            i = 31 * i + this.value.hashCode();
            return 31 * i + this.ops.hashCode();
        }
    }
}

