/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util;

import com.destroystokyo.paper.event.entity.PreCreatureSpawnEvent;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.StainedGlassBlock;
import net.minecraft.world.level.block.StainedGlassPaneBlock;
import net.minecraft.world.level.block.state.BlockState;
import org.bukkit.craftbukkit.entity.CraftEntityType;
import org.bukkit.craftbukkit.util.CraftLocation;
import org.bukkit.event.entity.CreatureSpawnEvent;

public class SpawnUtil {
    public static <T extends Mob> Optional<T> trySpawnMob(EntityType<T> entityType, EntitySpawnReason spawnReason, ServerLevel level, BlockPos pos, int attempts, int range, int yOffset, Strategy strategy, boolean checkCollision) {
        return SpawnUtil.trySpawnMob(entityType, spawnReason, level, pos, attempts, range, yOffset, strategy, checkCollision, CreatureSpawnEvent.SpawnReason.DEFAULT, null);
    }

    public static <T extends Mob> Optional<T> trySpawnMob(EntityType<T> entityType, EntitySpawnReason spawnReason, ServerLevel level, BlockPos pos, int attempts, int range, int yOffset, Strategy strategy, boolean checkCollision, CreatureSpawnEvent.SpawnReason reason, @Nullable Runnable onAbort) {
        BlockPos.MutableBlockPos mutableBlockPos = pos.mutable();
        for (int i = 0; i < attempts; ++i) {
            int i1 = Mth.randomBetweenInclusive(level.random, -range, range);
            int i2 = Mth.randomBetweenInclusive(level.random, -range, range);
            mutableBlockPos.setWithOffset(pos, i1, yOffset, i2);
            if (!level.getWorldBorder().isWithinBounds(mutableBlockPos) || !SpawnUtil.moveToPossibleSpawnPosition(level, yOffset, mutableBlockPos, strategy) || checkCollision && !level.noCollision(entityType.getSpawnAABB((double)mutableBlockPos.getX() + 0.5, mutableBlockPos.getY(), (double)mutableBlockPos.getZ() + 0.5))) continue;
            PreCreatureSpawnEvent event = new PreCreatureSpawnEvent(CraftLocation.toBukkit((Vec3i)pos, (Level)level), CraftEntityType.minecraftToBukkit(entityType), reason);
            if (!event.callEvent()) {
                if (!event.shouldAbortSpawn()) break;
                if (onAbort != null) {
                    onAbort.run();
                }
                return Optional.empty();
            }
            Mob mob = (Mob)entityType.create(level, null, mutableBlockPos, spawnReason, false, false);
            if (mob == null) continue;
            if (mob.checkSpawnRules(level, spawnReason) && mob.checkSpawnObstruction(level)) {
                level.addFreshEntityWithPassengers(mob, reason);
                if (mob.isRemoved()) {
                    return Optional.empty();
                }
                mob.playAmbientSound();
                return Optional.of(mob);
            }
            mob.discard(null);
        }
        return Optional.empty();
    }

    private static boolean moveToPossibleSpawnPosition(ServerLevel level, int yOffset, BlockPos.MutableBlockPos pos, Strategy strategy) {
        BlockPos.MutableBlockPos mutableBlockPos = new BlockPos.MutableBlockPos().set(pos);
        BlockState blockState = level.getBlockState(mutableBlockPos);
        for (int i = yOffset; i >= -yOffset; --i) {
            pos.move(Direction.DOWN);
            mutableBlockPos.setWithOffset((Vec3i)pos, Direction.UP);
            BlockState blockState1 = level.getBlockState(pos);
            if (strategy.canSpawnOn(level, pos, blockState1, mutableBlockPos, blockState)) {
                pos.move(Direction.UP);
                return true;
            }
            blockState = blockState1;
        }
        return false;
    }

    public static interface Strategy {
        @Deprecated
        public static final Strategy LEGACY_IRON_GOLEM = (level, targetPos, targetState, attemptedPos, attemptedState) -> !(targetState.is(Blocks.COBWEB) || targetState.is(Blocks.CACTUS) || targetState.is(Blocks.GLASS_PANE) || targetState.getBlock() instanceof StainedGlassPaneBlock || targetState.getBlock() instanceof StainedGlassBlock || targetState.getBlock() instanceof LeavesBlock || targetState.is(Blocks.CONDUIT) || targetState.is(Blocks.ICE) || targetState.is(Blocks.TNT) || targetState.is(Blocks.GLOWSTONE) || targetState.is(Blocks.BEACON) || targetState.is(Blocks.SEA_LANTERN) || targetState.is(Blocks.FROSTED_ICE) || targetState.is(Blocks.TINTED_GLASS) || targetState.is(Blocks.GLASS) || !attemptedState.isAir() && !attemptedState.liquid() || !targetState.isSolid() && !targetState.is(Blocks.POWDER_SNOW));
        public static final Strategy ON_TOP_OF_COLLIDER = (level, targetPos, targetState, attemptedPos, attemptedState) -> attemptedState.getCollisionShape(level, attemptedPos).isEmpty() && Block.isFaceFull(targetState.getCollisionShape(level, targetPos), Direction.UP);
        public static final Strategy ON_TOP_OF_COLLIDER_NO_LEAVES = (level, targetPos, targetState, attemptedPos, attemptedState) -> attemptedState.getCollisionShape(level, attemptedPos).isEmpty() && !targetState.is(BlockTags.LEAVES) && Block.isFaceFull(targetState.getCollisionShape(level, targetPos), Direction.UP);

        public boolean canSpawnOn(ServerLevel var1, BlockPos var2, BlockState var3, BlockPos var4, BlockState var5);
    }
}

