/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util;

import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.Style;
import net.minecraft.util.FormattedCharSink;
import net.minecraft.util.Unit;

public class StringDecomposer {
    private static final char REPLACEMENT_CHAR = '\ufffd';
    private static final Optional<Object> STOP_ITERATION = Optional.of(Unit.INSTANCE);

    private static boolean feedChar(Style style, FormattedCharSink sink, int position, char character) {
        return Character.isSurrogate(character) ? sink.accept(position, style, 65533) : sink.accept(position, style, character);
    }

    public static boolean iterate(String text, Style style, FormattedCharSink sink) {
        int len = text.length();
        for (int i = 0; i < len; ++i) {
            char c = text.charAt(i);
            if (Character.isHighSurrogate(c)) {
                if (i + 1 >= len) {
                    if (sink.accept(i, style, 65533)) break;
                    return false;
                }
                char c1 = text.charAt(i + 1);
                if (Character.isLowSurrogate(c1)) {
                    if (!sink.accept(i, style, Character.toCodePoint(c, c1))) {
                        return false;
                    }
                    ++i;
                    continue;
                }
                if (sink.accept(i, style, 65533)) continue;
                return false;
            }
            if (StringDecomposer.feedChar(style, sink, i, c)) continue;
            return false;
        }
        return true;
    }

    public static boolean iterateBackwards(String text, Style style, FormattedCharSink sink) {
        int len = text.length();
        for (int i = len - 1; i >= 0; --i) {
            char c = text.charAt(i);
            if (Character.isLowSurrogate(c)) {
                if (i - 1 < 0) {
                    if (sink.accept(0, style, 65533)) break;
                    return false;
                }
                char c1 = text.charAt(i - 1);
                if (!(Character.isHighSurrogate(c1) ? !sink.accept(--i, style, Character.toCodePoint(c1, c)) : !sink.accept(i, style, 65533))) continue;
                return false;
            }
            if (StringDecomposer.feedChar(style, sink, i, c)) continue;
            return false;
        }
        return true;
    }

    public static boolean iterateFormatted(String text, Style style, FormattedCharSink sink) {
        return StringDecomposer.iterateFormatted(text, 0, style, sink);
    }

    public static boolean iterateFormatted(String text, int skip, Style style, FormattedCharSink sink) {
        return StringDecomposer.iterateFormatted(text, skip, style, style, sink);
    }

    public static boolean iterateFormatted(String text, int skip, Style currentStyle, Style defaultStyle, FormattedCharSink sink) {
        int len = text.length();
        Style style = currentStyle;
        for (int i = skip; i < len; ++i) {
            char c1;
            char c = text.charAt(i);
            if (c == '\u00a7') {
                if (i + 1 >= len) break;
                c1 = text.charAt(i + 1);
                ChatFormatting byCode = ChatFormatting.getByCode(c1);
                if (byCode != null) {
                    style = byCode == ChatFormatting.RESET ? defaultStyle : style.applyLegacyFormat(byCode);
                }
                ++i;
                continue;
            }
            if (Character.isHighSurrogate(c)) {
                if (i + 1 >= len) {
                    if (sink.accept(i, style, 65533)) break;
                    return false;
                }
                c1 = text.charAt(i + 1);
                if (Character.isLowSurrogate(c1)) {
                    if (!sink.accept(i, style, Character.toCodePoint(c, c1))) {
                        return false;
                    }
                    ++i;
                    continue;
                }
                if (sink.accept(i, style, 65533)) continue;
                return false;
            }
            if (StringDecomposer.feedChar(style, sink, i, c)) continue;
            return false;
        }
        return true;
    }

    public static boolean iterateFormatted(FormattedText text, Style style, FormattedCharSink sink) {
        return text.visit((style1, content) -> StringDecomposer.iterateFormatted(content, 0, style1, sink) ? Optional.empty() : STOP_ITERATION, style).isEmpty();
    }

    public static String filterBrokenSurrogates(String text) {
        StringBuilder stringBuilder = new StringBuilder();
        StringDecomposer.iterate(text, Style.EMPTY, (position, style, codePoint) -> {
            stringBuilder.appendCodePoint(codePoint);
            return true;
        });
        return stringBuilder.toString();
    }

    public static String getPlainText(FormattedText text) {
        StringBuilder stringBuilder = new StringBuilder();
        StringDecomposer.iterateFormatted(text, Style.EMPTY, (int position, Style style, int codePoint) -> {
            stringBuilder.appendCodePoint(codePoint);
            return true;
        });
        return stringBuilder.toString();
    }
}

