/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.context;

import com.google.common.base.Joiner;
import com.google.common.collect.Sets;
import java.util.Set;
import net.minecraft.util.context.ContextKey;

public class ContextKeySet {
    private final Set<ContextKey<?>> required;
    private final Set<ContextKey<?>> allowed;

    ContextKeySet(Set<ContextKey<?>> required, Set<ContextKey<?>> allowed) {
        this.required = Set.copyOf(required);
        this.allowed = Set.copyOf(Sets.union(required, allowed));
    }

    public Set<ContextKey<?>> required() {
        return this.required;
    }

    public Set<ContextKey<?>> allowed() {
        return this.allowed;
    }

    public String toString() {
        return "[" + Joiner.on((String)", ").join(this.allowed.stream().map(key -> (this.required.contains(key) ? "!" : "") + String.valueOf(key.name())).iterator()) + "]";
    }

    public static class Builder {
        private final Set<ContextKey<?>> required = Sets.newIdentityHashSet();
        private final Set<ContextKey<?>> optional = Sets.newIdentityHashSet();

        public Builder required(ContextKey<?> key) {
            if (this.optional.contains(key)) {
                throw new IllegalArgumentException("Parameter " + String.valueOf(key.name()) + " is already optional");
            }
            this.required.add(key);
            return this;
        }

        public Builder optional(ContextKey<?> key) {
            if (this.required.contains(key)) {
                throw new IllegalArgumentException("Parameter " + String.valueOf(key.name()) + " is already required");
            }
            this.optional.add(key);
            return this;
        }

        public ContextKeySet build() {
            return new ContextKeySet(this.required, this.optional);
        }
    }
}

