/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.datafix.fixes;

import com.mojang.datafixers.DSL;
import com.mojang.datafixers.OpticFinder;
import com.mojang.datafixers.TypeRewriteRule;
import com.mojang.datafixers.schemas.Schema;
import com.mojang.datafixers.types.Type;
import com.mojang.serialization.Dynamic;
import net.minecraft.util.datafix.fixes.AbstractUUIDFix;
import net.minecraft.util.datafix.fixes.References;
import net.minecraft.util.datafix.schemas.NamespacedSchema;

public class ItemStackUUIDFix
extends AbstractUUIDFix {
    public ItemStackUUIDFix(Schema outputSchema) {
        super(outputSchema, References.ITEM_STACK);
    }

    public TypeRewriteRule makeRule() {
        OpticFinder opticFinder = DSL.fieldFinder((String)"id", (Type)DSL.named((String)References.ITEM_NAME.typeName(), NamespacedSchema.namespacedString()));
        return this.fixTypeEverywhereTyped("ItemStackUUIDFix", this.getInputSchema().getType(this.typeReference), typed -> {
            OpticFinder opticFinder1 = typed.getType().findField("tag");
            return typed.updateTyped(opticFinder1, typed1 -> typed1.update(DSL.remainderFinder(), dynamic -> {
                dynamic = this.updateAttributeModifiers((Dynamic<?>)((Object)((Object)((Object)dynamic))));
                if (typed.getOptional(opticFinder).map(pair -> "minecraft:player_head".equals(pair.getSecond())).orElse(false).booleanValue()) {
                    dynamic = this.updateSkullOwner((Dynamic<?>)((Object)((Object)((Object)dynamic))));
                }
                return dynamic;
            }));
        });
    }

    private Dynamic<?> updateAttributeModifiers(Dynamic<?> dynamic) {
        return dynamic.update("AttributeModifiers", dynamic1 -> dynamic.createList(dynamic1.asStream().map(dynamic2 -> ItemStackUUIDFix.replaceUUIDLeastMost(dynamic2, "UUID", "UUID").orElse((Dynamic<?>)((Object)((Object)dynamic2))))));
    }

    private Dynamic<?> updateSkullOwner(Dynamic<?> dynamic) {
        return dynamic.update("SkullOwner", dynamic1 -> ItemStackUUIDFix.replaceUUIDString(dynamic1, "Id", "Id").orElse((Dynamic<?>)((Object)dynamic1)));
    }
}

