/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.datafix.fixes;

import com.mojang.datafixers.DSL;
import com.mojang.datafixers.DataFix;
import com.mojang.datafixers.OpticFinder;
import com.mojang.datafixers.TypeRewriteRule;
import com.mojang.datafixers.Typed;
import com.mojang.datafixers.schemas.Schema;
import com.mojang.datafixers.types.Type;
import com.mojang.datafixers.types.templates.List;
import java.util.Optional;
import java.util.Set;
import net.minecraft.Util;
import net.minecraft.util.datafix.fixes.References;
import net.minecraft.util.datafix.schemas.NamespacedSchema;

public class RemoveBlockEntityTagFix
extends DataFix {
    private final Set<String> blockEntityIdsToDrop;

    public RemoveBlockEntityTagFix(Schema outputSchema, Set<String> blockEntityIdsToDrop) {
        super(outputSchema, true);
        this.blockEntityIdsToDrop = blockEntityIdsToDrop;
    }

    public TypeRewriteRule makeRule() {
        Type type = this.getInputSchema().getType(References.ITEM_STACK);
        OpticFinder opticFinder = type.findField("tag");
        OpticFinder opticFinder1 = opticFinder.type().findField("BlockEntityTag");
        Type type1 = this.getInputSchema().getType(References.ENTITY);
        OpticFinder opticFinder2 = DSL.namedChoice((String)"minecraft:falling_block", (Type)this.getInputSchema().getChoiceType(References.ENTITY, "minecraft:falling_block"));
        OpticFinder opticFinder3 = opticFinder2.type().findField("TileEntityData");
        Type type2 = this.getInputSchema().getType(References.STRUCTURE);
        OpticFinder opticFinder4 = type2.findField("blocks");
        OpticFinder opticFinder5 = DSL.typeFinder((Type)((List.ListType)opticFinder4.type()).getElement());
        OpticFinder opticFinder6 = opticFinder5.type().findField("nbt");
        OpticFinder opticFinder7 = DSL.fieldFinder((String)"id", NamespacedSchema.namespacedString());
        return TypeRewriteRule.seq((TypeRewriteRule)this.fixTypeEverywhereTyped("ItemRemoveBlockEntityTagFix", type, typed -> typed.updateTyped(opticFinder, typed1 -> this.removeBlockEntity((Typed<?>)typed1, (OpticFinder<?>)opticFinder1, (OpticFinder<String>)opticFinder7, "BlockEntityTag"))), (TypeRewriteRule[])new TypeRewriteRule[]{this.fixTypeEverywhereTyped("FallingBlockEntityRemoveBlockEntityTagFix", type1, typed -> typed.updateTyped(opticFinder2, typed1 -> this.removeBlockEntity((Typed<?>)typed1, (OpticFinder<?>)opticFinder3, (OpticFinder<String>)opticFinder7, "TileEntityData"))), this.fixTypeEverywhereTyped("StructureRemoveBlockEntityTagFix", type2, typed -> typed.updateTyped(opticFinder4, typed1 -> typed1.updateTyped(opticFinder5, typed2 -> this.removeBlockEntity((Typed<?>)typed2, (OpticFinder<?>)opticFinder6, (OpticFinder<String>)opticFinder7, "nbt")))), this.convertUnchecked("ItemRemoveBlockEntityTagFix - update block entity type", this.getInputSchema().getType(References.BLOCK_ENTITY), this.getOutputSchema().getType(References.BLOCK_ENTITY))});
    }

    private Typed<?> removeBlockEntity(Typed<?> data, OpticFinder<?> tagFinder, OpticFinder<String> idFinder, String key) {
        Optional optionalTyped = data.getOptionalTyped(tagFinder);
        if (optionalTyped.isEmpty()) {
            return data;
        }
        String string = ((Typed)optionalTyped.get()).getOptional(idFinder).orElse("");
        return !this.blockEntityIdsToDrop.contains(string) ? data : Util.writeAndReadTypedOrThrow(data, data.getType(), dynamic -> dynamic.remove(key));
    }
}

