/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.datafix.fixes;

import com.mojang.datafixers.DataFix;
import com.mojang.datafixers.OpticFinder;
import com.mojang.datafixers.TypeRewriteRule;
import com.mojang.datafixers.Typed;
import com.mojang.datafixers.schemas.Schema;
import com.mojang.datafixers.types.Type;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import java.util.List;
import net.minecraft.util.datafix.fixes.References;

public class SpawnerDataFix
extends DataFix {
    public SpawnerDataFix(Schema outputSchema) {
        super(outputSchema, true);
    }

    protected TypeRewriteRule makeRule() {
        Type type = this.getInputSchema().getType(References.UNTAGGED_SPAWNER);
        Type type1 = this.getOutputSchema().getType(References.UNTAGGED_SPAWNER);
        OpticFinder opticFinder = type.findField("SpawnData");
        Type type2 = type1.findField("SpawnData").type();
        OpticFinder opticFinder1 = type.findField("SpawnPotentials");
        Type type3 = type1.findField("SpawnPotentials").type();
        return this.fixTypeEverywhereTyped("Fix mob spawner data structure", type, type1, typed -> typed.updateTyped(opticFinder, type2, typed1 -> this.wrapEntityToSpawnData((Type)type2, (Typed<?>)typed1)).updateTyped(opticFinder1, type3, typed1 -> this.wrapSpawnPotentialsToWeightedEntries((Type)type3, (Typed<?>)typed1)));
    }

    private <T> Typed<T> wrapEntityToSpawnData(Type<T> type, Typed<?> typed) {
        DynamicOps ops = typed.getOps();
        return new Typed(type, ops, (Object)Pair.of((Object)typed.getValue(), new Dynamic(ops)));
    }

    private <T> Typed<T> wrapSpawnPotentialsToWeightedEntries(Type<T> type, Typed<?> typed) {
        DynamicOps ops = typed.getOps();
        List list = (List)typed.getValue();
        List<Pair> list1 = list.stream().map(object -> {
            Pair pair = (Pair)object;
            int i = ((Number)((Dynamic)((Object)((Object)pair.getSecond()))).get("Weight").asNumber().result().orElse(1)).intValue();
            Dynamic dynamic = new Dynamic(ops);
            dynamic = dynamic.set("weight", dynamic.createInt(i));
            Dynamic dynamic1 = ((Dynamic)((Object)((Object)pair.getSecond()))).remove("Weight").remove("Entity");
            return Pair.of((Object)Pair.of((Object)pair.getFirst(), dynamic1), dynamic);
        }).toList();
        return new Typed(type, ops, list1);
    }
}

